/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.service.impl;

import cn.smarthse.invoice.bootstrap.properties.InvoiceProperties;
import cn.smarthse.invoice.model.InValidInvoiceParam;
import cn.smarthse.invoice.model.InvoiceCommonParamModel;
import cn.smarthse.invoice.model.InvoiceKpDetailModel;
import cn.smarthse.invoice.model.InvoiceKpOrderModel;
import cn.smarthse.invoice.model.QueryInvoiceResultParam;
import cn.smarthse.invoice.service.InvoiceSDKService;
import cn.smarthse.invoice.service.InvoiceService;
import com.alibaba.fastjson.JSONArray;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InvoiceServiceImpl
implements InvoiceService {
    @Resource
    private InvoiceSDKService sdkService;
    private final InvoiceProperties invoiceProperties;

    @Override
    public String requestBillingNew(InvoiceKpDetailModel model) {
        model.setSalerTaxNum(this.invoiceProperties.taxNum);
        model.setSalerTel(this.invoiceProperties.salerTel);
        model.setSalerAddress(this.invoiceProperties.salerAddress);
        model.setSalerAccount(this.invoiceProperties.salerAccount);
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        InvoiceKpOrderModel orderModel = new InvoiceKpOrderModel();
        orderModel.setOrder(model);
        param.setUrl(this.invoiceProperties.requestUrl);
        param.setMethod(this.invoiceProperties.apiMethod.requestBillingNew);
        param.setContent(JSONArray.toJSON((Object)orderModel).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        param.setUrl(this.invoiceProperties.requestUrl);
        param.setMethod(this.invoiceProperties.apiMethod.queryInvoiceResult);
        param.setContent(JSONArray.toJSON((Object)queryParam).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String invoiceCancellation(InValidInvoiceParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        param.setUrl(this.invoiceProperties.requestUrl);
        param.setMethod(this.invoiceProperties.apiMethod.invoiceCancellation);
        param.setContent(JSONArray.toJSON((Object)queryParam).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }

    public InvoiceServiceImpl(InvoiceProperties invoiceProperties) {
        this.invoiceProperties = invoiceProperties;
    }
}

