package cn.smarthse.invoice.service.impl;

import cn.smarthse.invoice.bootstrap.properties.InvoiceProperties;
import cn.smarthse.invoice.model.*;
import cn.smarthse.invoice.service.InvoiceSDKService;
import cn.smarthse.invoice.service.InvoiceService;
import com.alibaba.fastjson.JSONArray;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author <开发者>
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2019-05-29 02:39
 */
@Service
@Transactional(readOnly = true)
@RequiredArgsConstructor
public class InvoiceServiceImpl implements InvoiceService {

    @Resource
    private InvoiceSDKService sdkService;

    private final InvoiceProperties invoiceProperties;

    @Override
    public String requestBillingNew(InvoiceKpDetailModel model) {
        // 开票方信息
        model.setSalerTaxNum(invoiceProperties.taxNum);
        model.setSalerTel(invoiceProperties.salerTel);
        model.setSalerAddress(invoiceProperties.salerAddress);
        model.setSalerAccount(invoiceProperties.salerAccount);

        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        // 填充请求参数对象
        InvoiceKpOrderModel orderModel = new InvoiceKpOrderModel();
        orderModel.setOrder(model);

        param.setUrl(invoiceProperties.requestUrl);
        param.setMethod(invoiceProperties.apiMethod.requestBillingNew);
        param.setContent(JSONArray.toJSON(orderModel).toString());

        return sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        //填充请求参数对象
        param.setUrl(invoiceProperties.requestUrl);
        param.setMethod(invoiceProperties.apiMethod.queryInvoiceResult);
        param.setContent(JSONArray.toJSON(queryParam).toString());

        return this.sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String invoiceCancellation(InValidInvoiceParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        //填充请求参数对象
        param.setUrl(invoiceProperties.requestUrl);
        param.setMethod(invoiceProperties.apiMethod.invoiceCancellation);
        param.setContent(JSONArray.toJSON(queryParam).toString());

        return this.sdkService.sendPostSyncRequest(param);
    }
}
