package cn.smarthse.invoice.service;

import cn.smarthse.invoice.bootstrap.properties.InvoiceProperties;
import cn.smarthse.invoice.model.InvoiceCommonParamModel;
import lombok.RequiredArgsConstructor;
import nuonuo.open.sdk.NNOpenSDK;
import org.springframework.stereotype.Service;

/**
 * @ClassName InvoiceSDKService
 * @Description 在线发票请求接口---sdk调用
 * @Author Wuxq
 * @Date 2021/7/5
 */
@Service
@RequiredArgsConstructor
public class InvoiceSDKService {

    private final InvoiceProperties invoiceProperties;

    public String sendPostSyncRequest(InvoiceCommonParamModel paramModel) {
        NNOpenSDK sdk = NNOpenSDK.getIntance();
        return sdk.sendPostSyncRequest(
                paramModel.getUrl(),
                paramModel.getSenid(),
                invoiceProperties.appKey,
                invoiceProperties.appSecret,
                invoiceProperties.accessToken,
                invoiceProperties.taxNum,
                paramModel.getMethod(),
                paramModel.getContent()
        );
    }

}
