package cn.smarthse.invoice.provider;

import cn.smarthse.invoice.model.*;
import cn.smarthse.invoice.service.InvoiceProvider;
import cn.smarthse.invoice.service.InvoiceService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 在线发票公共服务接口实现类
 *
 * @author wuxq
 * @JDK version used:      <JDK1.8>
 * @since 2021年2月30日-下午1:41:15
 */
@Service
@Transactional(readOnly = true)
public class InvoiceProvideServiceImpl implements InvoiceProvider {

    @Autowired
    private InvoiceService invoiceService;

    @Override
    public InvoiceKpOrInvalidResultModel getInvoicing(InvoiceKpParam param) {
        // 开票请求参数转换
        InvoiceKpDetailModel model = new InvoiceKpDetailModel();
        BeanUtils.copyProperties(param,model);
        model.setInvoiceDetail(param.getInvoiceDetail());

        // 开票请求，成功则返回流水号
        String applyResult =  invoiceService.requestBillingNew(model);

        // 将JSON转换成  InvoiceKpOrInvalidResultModel
        return JSONObject.parseObject(applyResult, InvoiceKpOrInvalidResultModel.class);
    }

    @Override
    public InvoiceKpResultModel queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        // 开票结果查询
        String jsonString = invoiceService.queryInvoiceBySerialNumber(new QueryInvoiceResultParam(queryParam.getSerialNos(),queryParam.getOrderNos(),queryParam.getIsOfferInvoiceDetail()));

        // 将JSON转换成  InvoiceKpResultModel
        return JSONObject.parseObject(jsonString, InvoiceKpResultModel.class);
    }

    @Override
    public InvoiceKpOrInvalidResultModel inValidInvoice(InValidInvoiceParam inValidInvoiceParam) {

        String applyResult =  invoiceService.invoiceCancellation(inValidInvoiceParam);

        // 将JSON转换成  InvoiceKpOrInvalidResultModel
        return JSONObject.parseObject(applyResult, InvoiceKpOrInvalidResultModel.class);
    }


}
