/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.util.file.m3u8;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.file.FileContentTypeUtils;
import cn.smarthse.common.framework.file.UploadFileParameter;
import cn.smarthse.modules.datacentre.entity.system.OperationFileSlicing;
import cn.smarthse.modules.datacentre.enums.VideoSlicingStatusEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileVo;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.service.system.IOperationFileSlicingService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.m3u8.FFmpegUtils;
import cn.smarthse.modules.uploader.m3u8.TranscodeConfig;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationFileSlicingThread
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationFileSlicingThread.class);
    private ISysFileProvideService sysFileService = null;
    private OperationFileSlicing operationFileSlicing = null;
    private IOperationFileSlicingService operationFileSlicingService = null;
    private OssClientBean ossClientBean = null;
    private RMap<String, SysOperationFileVo> map = null;
    private RMap<String, SysOperationFileVo> mapNull = null;
    private RedissonClient redissonClient = null;

    public OperationFileSlicingThread(ISysFileProvideService sysFileService, OperationFileSlicing operationFileSlicing, IOperationFileSlicingService operationFileSlicingService, OssClientBean ossClientBean, RMap<String, SysOperationFileVo> map, RMap<String, SysOperationFileVo> mapNull, RedissonClient redissonClient) {
        this.sysFileService = sysFileService;
        this.operationFileSlicing = operationFileSlicing;
        this.operationFileSlicingService = operationFileSlicingService;
        this.ossClientBean = ossClientBean;
        this.map = map;
        this.mapNull = mapNull;
        this.redissonClient = redissonClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        File destFile;
        Object realPath;
        block23: {
            block24: {
                block21: {
                    block22: {
                        if (ObjectUtil.isNull((Object)this.operationFileSlicing)) {
                            return;
                        }
                        realPath = "";
                        destFile = null;
                        try {
                            SysFileModel sysFileModel = this.sysFileService.getFileById(this.operationFileSlicing.getFileId());
                            String fileUrl = sysFileModel.getFullOssurl();
                            if (StrUtil.isBlank((CharSequence)fileUrl)) {
                                this.operationFileSlicingService.updateSlicingStatus(this.operationFileSlicing.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null, this.operationFileSlicing.getUpdateBy(), this.operationFileSlicing.getUpdateDate());
                                return;
                            }
                            String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.supervise_05.getCode() + File.separator + "m3u8" + File.separator + new SimpleDateFormat("yyyyMM").format(new Date()) + File.separator + new SimpleDateFormat("HHmmss").format(new Date()) + RandomUtil.randomNumbers((int)2);
                            realPath = uploadDir;
                            String ossUrl = uploadDir.replace("\\", "/") + "/index.m3u8";
                            String tsUrl = uploadDir.replace("\\", "/");
                            destFile = File.createTempFile(UUID.randomUUID().toString(), sysFileModel.getFileExt());
                            if (ObjectUtil.isNull((Object)destFile)) {
                                this.operationFileSlicingService.updateSlicingStatus(this.operationFileSlicing.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null, this.operationFileSlicing.getUpdateBy(), this.operationFileSlicing.getUpdateDate());
                                if (!StrUtil.isNotBlank((CharSequence)realPath)) break block21;
                                break block22;
                            }
                            HttpUtil.downloadFile((String)fileUrl, (File)destFile);
                            log.info("\u5f00\u59cb\u8f6c\u7801\u6587\u4ef6\u76ee\u5f55\uff1a{}", (Object)destFile.getAbsoluteFile());
                            this.operationFileSlicingService.updateSlicingStatus(this.operationFileSlicing.getId(), VideoSlicingStatusEnum.IN.getCode(), null, this.operationFileSlicing.getUpdateBy(), this.operationFileSlicing.getUpdateDate());
                            RLock lock = this.redissonClient.getLock("DATACENTRE-VIDEO-FFMPEGLOCK");
                            Boolean falg = this.extracted((String)realPath, destFile, lock);
                            if (!falg.booleanValue()) {
                                throw new ServiceException("\u672a\u83b7\u53d6\u9501\uff0c\u8bf7\u5bf9\u8be5\u9875\u9762\u91cd\u65b0\u4e0a\u4f20\u4efb\u610f\u4e00\u4e2a\u8f83\u5c0f\u89c6\u9891\uff0c\u4e4b\u540e\u53ef\u4ee5\u9009\u62e9\u5220\u9664\u8be5\u89c6\u9891");
                            }
                            File[] files = new File((String)realPath).listFiles();
                            if (files != null) {
                                for (File file : files) {
                                    if (!file.getName().endsWith(".m3u8") && !file.getName().endsWith(".ts") && !file.getName().endsWith(".jpg") && !file.getName().equals("key") || !this.ossClientBean.isAsynch()) continue;
                                    this.ossClientBean.OSSPutObject(file.getName(), file, tsUrl, file.getName(), null, FileContentTypeUtils.contentType((String)file.getName()));
                                }
                            }
                            log.info("\u5b8c\u6210\u8f6c\u7801\u6587\u4ef6\u76ee\u5f55\uff1a{}", (Object)destFile.getAbsoluteFile());
                            SysFileModel addSysFileModel = new SysFileModel();
                            addSysFileModel.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
                            addSysFileModel.setFileName(destFile.getName());
                            addSysFileModel.setFileSize(String.valueOf(FileUtil.size((File)destFile)));
                            addSysFileModel.setFileExt("m3u8");
                            addSysFileModel.setFileHash(String.valueOf(FileUtils.checksumCRC32((File)destFile)));
                            addSysFileModel.setOssUrl(ossUrl);
                            addSysFileModel = this.sysFileService.addSysFile(addSysFileModel, this.operationFileSlicing.getUpdateBy());
                            this.operationFileSlicingService.updateSlicingStatus(this.operationFileSlicing.getId(), VideoSlicingStatusEnum.SUCCESS.getCode(), addSysFileModel.getId(), this.operationFileSlicing.getUpdateBy(), this.operationFileSlicing.getUpdateDate());
                            if (!StrUtil.isNotBlank((CharSequence)realPath)) break block23;
                            break block24;
                        }
                        catch (Exception e) {
                            log.error("\u8f6c\u7801\u5f02\u5e38\uff1a", (Throwable)e);
                            this.operationFileSlicingService.updateSlicingStatus(this.operationFileSlicing.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null, this.operationFileSlicing.getUpdateBy(), this.operationFileSlicing.getUpdateDate());
                            throw new ServiceException("\u5206\u7247\u5f02\u5e38\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                        }
                    }
                    FileUtil.del((File)new File((String)realPath));
                }
                if (ObjectUtil.isNotNull((Object)destFile)) {
                    FileUtil.del((File)destFile);
                }
                if (ObjectUtil.isNotNull(this.map)) {
                    this.map.delete();
                }
                if (!ObjectUtil.isNotNull(this.mapNull)) return;
                this.mapNull.delete();
                return;
            }
            FileUtil.del((File)new File((String)realPath));
        }
        if (ObjectUtil.isNotNull((Object)destFile)) {
            FileUtil.del((File)destFile);
        }
        if (ObjectUtil.isNotNull(this.map)) {
            this.map.delete();
        }
        if (!ObjectUtil.isNotNull(this.mapNull)) return;
        this.mapNull.delete();
        return;
        finally {
            if (StrUtil.isNotBlank((CharSequence)realPath)) {
                FileUtil.del((File)new File((String)realPath));
            }
            if (ObjectUtil.isNotNull(destFile)) {
                FileUtil.del(destFile);
            }
            if (ObjectUtil.isNotNull(this.map)) {
                this.map.delete();
            }
            if (ObjectUtil.isNotNull(this.mapNull)) {
                this.mapNull.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean extracted(String realPath, File destFile, RLock lock) throws Exception {
        Boolean falg = false;
        try {
            falg = lock.tryLock(5L, 30L, TimeUnit.MINUTES);
            if (falg.booleanValue()) {
                FFmpegUtils.transcodeToM3u8((String)destFile.getAbsolutePath(), (String)realPath, (TranscodeConfig)new TranscodeConfig());
            }
        }
        catch (Exception e) {
            if (falg.booleanValue()) {
                lock.unlock();
            }
            Boolean bl = falg = Boolean.valueOf(false);
            return bl;
        }
        finally {
            if (falg.booleanValue()) {
                lock.unlock();
            }
            return falg;
        }
    }
}

