/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.util;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanySupervise;
import cn.smarthse.modules.datacentre.entity.system.Industry;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.system.IIndustryService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.util.common.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanySuperviseModelUtil {
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private ISysParamService paramService;
    @Autowired
    private ICompanySuperviseService superviseService;
    @Autowired
    private IIndustryService industryService;

    public CompanySuperviseModel company2model(Company company) {
        CompanySupervise companySupervise;
        Industry industry;
        if (company == null) {
            return null;
        }
        CompanySuperviseModel companyInfo = new CompanySuperviseModel();
        BeanUtils.copyProperties((Object)company, (Object)companyInfo);
        SysArea area = this.areaService.getAreaById(company.getAreaId());
        if (area != null) {
            companyInfo.setAreaId(area.getAreaId());
            companyInfo.setAreaName(area.getAreaName());
            companyInfo.setCityId(area.getCityId());
            companyInfo.setCityName(area.getCityName());
            companyInfo.setStreetId(area.getStreetId());
            companyInfo.setStreetName(area.getStreetName());
            companyInfo.setProvinceId(area.getProvinceId());
            companyInfo.setProvinceName(area.getProvinceName());
            companyInfo.setAreaLevel(area.getLevel());
            companyInfo.setAreaDetailName(area.getAreaDetailName());
        }
        companyInfo.setAreaDetailId(company.getAreaId());
        Long supervisionUnit = companyInfo.getSupervisionUnit();
        if (supervisionUnit != null) {
            String unitName = this.superviseService.getCompanySupervisionUnitNameById(supervisionUnit);
            companyInfo.setSupervisionUnitName(unitName);
        }
        companyInfo.setIndustryCategory(company.getIndustryCategory());
        if (company.getIndustryCategory() != null && company.getIndustryCategory() > 0L && (industry = (Industry)this.industryService.getById(company.getIndustryCategory())) != null) {
            companyInfo.setIndustryCategoryName(industry.getName());
        }
        companyInfo.setRegisterType(company.getRegisterType());
        if (company.getRegisterType() != null && company.getRegisterType() > 0L) {
            String registerType = this.paramService.getParamValue(company.getRegisterType());
            companyInfo.setRegisterTypeName(registerType);
        }
        if (StringUtils.isNotEmpty((String)company.getScale()) && NumberUtil.isNumber((String)company.getScale())) {
            Integer scale = NumberUtil.toInt((String)company.getScale());
            String scaleName = CompanySizeEnum.getName((Integer)scale);
            companyInfo.setScaleName(scaleName);
        }
        if ((companySupervise = this.superviseService.getCompanySuperviseByCid(company.getId())) != null) {
            companyInfo.setInspectionClassification(companySupervise.getInspectionClassification());
            companyInfo.setIsBest(companySupervise.getIsBest());
            companyInfo.setBestUpdateTime(companySupervise.getBestUpdateTime());
            companyInfo.setGovern(companySupervise.getGovern());
            companyInfo.setGovernTime(companySupervise.getGovernTime());
            companyInfo.setOperationStatus(companySupervise.getOperationStatus());
            companyInfo.setReportCompanyName(companySupervise.getReportCompanyName());
            companyInfo.setReportDate(companySupervise.getReportDate());
            companyInfo.setReportType(companySupervise.getReportType());
            companyInfo.setBelongType(companySupervise.getBelongType());
            companyInfo.setSuperviseIsHide(companySupervise.getSuperviseIsHide());
            companyInfo.setSuperviseIsDel(companySupervise.getSuperviseIsDel());
            companyInfo.setSuperviseDelTime(companySupervise.getSuperviseDelTime());
            companyInfo.setDelReasonItem(companySupervise.getDelReasonItem());
            companyInfo.setDelReason(companySupervise.getDelReason());
            companyInfo.setRecoverTime(companySupervise.getRecoverTime());
            companyInfo.setBusinessState(companySupervise.getBusinessState());
            companyInfo.setBusinessUpdateTime(companySupervise.getBusinessUpdateTime());
            companyInfo.setNameListTotal(companySupervise.getNameListTotal());
            companyInfo.setExternalTotal(companySupervise.getExternalTotal());
            companyInfo.setOccTotal(companySupervise.getOccTotal());
            companyInfo.setContactDustNum(companySupervise.getContactDustNum());
            companyInfo.setContactChemistryNum(companySupervise.getContactChemistryNum());
            companyInfo.setContactPhysicsNum(companySupervise.getContactPhysicsNum());
            companyInfo.setContactRadiationNum(companySupervise.getContactRadiationNum());
            companyInfo.setContactBiologyNum(companySupervise.getContactBiologyNum());
            companyInfo.setContactOtherNum(companySupervise.getContactOtherNum());
            companyInfo.setHasHazardFactors(companySupervise.getHasHazardFactors());
            companyInfo.setIrsBusinessState(companySupervise.getIrsBusinessState());
        }
        return companyInfo;
    }

    public void settingDetailName(CompanySuperviseModel companyInfo, String spliter) {
        if (companyInfo == null) {
            return;
        }
        StringBuffer fullName = new StringBuffer("");
        String provinceName = companyInfo.getProvinceName();
        String cityName = companyInfo.getCityName();
        String areaName = companyInfo.getAreaName();
        String streetName = companyInfo.getStreetName();
        if (StringUtils.isNotBlank((CharSequence)provinceName)) {
            fullName.append(provinceName);
        }
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            fullName.append(spliter);
            fullName.append(cityName);
        }
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            fullName.append(spliter);
            fullName.append(areaName);
        }
        if (StringUtils.isNotBlank((CharSequence)streetName)) {
            fullName.append(spliter);
            fullName.append(streetName);
        }
        companyInfo.setAreaDetailName(fullName.toString());
    }
}

