/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.util;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanySupervise;
import cn.smarthse.modules.datacentre.entity.system.Industry;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.system.IIndustryService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.util.common.StringUtils;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyBaseInfoModelUtil {
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private ICompanySuperviseService companySuperviseService;
    @Autowired
    private ISysParamService paramService;
    @Autowired
    private IIndustryService industryService;
    @Autowired
    private RedisClient redisClient;

    public CompanyBaseInfoModel company2model(Company company) {
        Industry industry;
        if (company == null) {
            return null;
        }
        CompanyBaseInfoModel companyInfo = new CompanyBaseInfoModel();
        BeanUtils.copyProperties((Object)company, (Object)companyInfo);
        companyInfo.setId(company.getId());
        companyInfo.setCid(company.getId());
        companyInfo.setName(company.getName());
        companyInfo.setShortName(company.getShortName());
        companyInfo.setCreateDate(company.getCreateDate());
        companyInfo.setCompanyType(company.getCompanyType());
        SysArea area = this.areaService.getAreaById(company.getAreaId());
        if (area != null) {
            companyInfo.setAreaId(area.getAreaId());
            companyInfo.setAreaName(area.getAreaName());
            companyInfo.setCityId(area.getCityId());
            companyInfo.setCityName(area.getCityName());
            companyInfo.setStreetId(area.getStreetId());
            companyInfo.setStreetName(area.getStreetName());
            companyInfo.setProvinceId(area.getProvinceId());
            companyInfo.setProvinceName(area.getProvinceName());
            companyInfo.setAreaLevel(area.getLevel());
            companyInfo.setAreaDetailName(area.getAreaDetailName());
        }
        companyInfo.setAreaDetailId(company.getAreaId());
        SysArea registerArea = this.areaService.getAreaById(company.getRegisterAddressRegionId());
        if (registerArea != null) {
            companyInfo.setRegisterAreaId(registerArea.getAreaId());
            companyInfo.setRegisterAreaName(registerArea.getAreaName());
            companyInfo.setRegisterCityId(registerArea.getCityId());
            companyInfo.setRegisterCityName(registerArea.getCityName());
            companyInfo.setRegisterStreetId(registerArea.getStreetId());
            companyInfo.setRegisterStreetName(registerArea.getStreetName());
            companyInfo.setRegisterProvinceId(registerArea.getProvinceId());
            companyInfo.setRegisterProvinceName(registerArea.getProvinceName());
            companyInfo.setRegisterAreaLevel(registerArea.getLevel());
            companyInfo.setRegisterAreaDetailName(registerArea.getAreaDetailName());
        }
        companyInfo.setRegisterAreaDetailId(company.getRegisterAddressRegionId());
        companyInfo.setIndustryCategory(company.getIndustryCategory());
        if (company.getIndustryCategory() != null && company.getIndustryCategory() > 0L && (industry = (Industry)this.industryService.getById(company.getIndustryCategory())) != null) {
            companyInfo.setIndustryCategoryName(industry.getName());
        }
        companyInfo.setRegisterType(company.getRegisterType());
        if (company.getRegisterType() != null && company.getRegisterType() > 0L) {
            String registerType = this.paramService.getParamValue(company.getRegisterType());
            companyInfo.setRegisterTypeName(registerType);
        }
        companyInfo.setChemicalEmergencyPhone(company.getChemicalEmergencyPhone());
        companyInfo.setCompanyContactEmail(company.getCompanyContactEmail());
        companyInfo.setCompanyContactFax(company.getCompanyContactFax());
        companyInfo.setCompanyContactTel(company.getCompanyContactTel());
        companyInfo.setCompanyPostalAdress(company.getCompanyPostalAdress());
        companyInfo.setFatherDept(company.getFatherDept());
        companyInfo.setLegalName(company.getLegalName());
        companyInfo.setLegalTel(company.getLegalTel());
        companyInfo.setLogoFileUrl(company.getLogoFileUrl());
        companyInfo.setMainOperaIncome(company.getMainOperaIncome());
        companyInfo.setOccLeaderSid(company.getOccLeaderSid());
        companyInfo.setOccLeaderTel(company.getOccLeaderTel());
        companyInfo.setOccupationalRiskClassify(company.getOccupationalRiskClassify());
        companyInfo.setPickupCount(company.getPickupCount());
        companyInfo.setRegisterAddressRegionId(company.getRegisterAddressRegionId());
        companyInfo.setRegisterAddress(company.getRegisterAddress());
        companyInfo.setRegisterCapital(company.getRegisterCapital());
        companyInfo.setRegisterPost(company.getRegisterPost());
        companyInfo.setScale(company.getScale());
        if (StringUtils.isNotEmpty((String)company.getScale()) && NumberUtil.isNumber((String)company.getScale())) {
            Integer scale = NumberUtil.toInt((String)company.getScale());
            String scaleName = CompanySizeEnum.getName((Integer)scale);
            companyInfo.setScaleName(scaleName);
        }
        if (company.getIsExistRadioactivity().booleanValue()) {
            CompanySupervise companySupervise = (CompanySupervise)this.redisClient.get("ICompanySuperviseService", "getCompanySuperviseByCid" + company.getId(), 1800L, () -> this.companySuperviseService.getCompanySuperviseByCid(company.getId()));
            companyInfo.setCompanyRadioactivityType(Integer.valueOf(1));
            if (companySupervise != null) {
                if (Objects.equals(true, companySupervise.getIsFlawDetection())) {
                    companyInfo.setCompanyRadioactivityType(Integer.valueOf(5));
                    if (Objects.equals(0, companySupervise.getFlawDetectionType())) {
                        companyInfo.setCompanyRadioactivityType(Integer.valueOf(6));
                    } else if (Objects.equals(1, companySupervise.getFlawDetectionType())) {
                        companyInfo.setCompanyRadioactivityType(Integer.valueOf(7));
                    }
                } else {
                    companyInfo.setCompanyRadioactivityType(Integer.valueOf(4));
                }
            }
        } else {
            companyInfo.setCompanyRadioactivityType(Integer.valueOf(2));
        }
        companyInfo.setSettingTime(company.getSettingTime());
        companyInfo.setStaffCount(company.getStaffCount());
        companyInfo.setTotalAssets(company.getTotalAssets());
        companyInfo.setUnifiedSocialCc(company.getUnifiedSocialCc());
        companyInfo.setWorkAddress(company.getWorkAddress());
        companyInfo.setYearAssets(company.getYearAssets());
        companyInfo.setPunishNum(company.getPunishNum());
        companyInfo.setCreditSupervise(company.getCreditSupervise());
        return companyInfo;
    }
}

