/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.task;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.http.HttpUtil;
import cn.smarthse.modules.datacentre.entity.system.SysFile;
import cn.smarthse.modules.datacentre.enums.sysfile.SysFileConvertEnum;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.service.system.ISysFileService;
import cn.smarthse.modules.datacentre.util.FileUtils;
import cn.smarthse.modules.datacentre.util.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysFileConvertTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysFileConvertTask.class);
    @Autowired
    ISysFileService sysFileService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    private static final int pageRecycleSize = 1000;
    ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 8, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNamePrefix("\u9644\u4ef6\u8f6c\u6362\u4efb\u52a1\u7ebf\u7a0b-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u7ebf\u7a0b\uff1a{}\uff0c \u9644\u4ef6\u8f6c\u6362\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    });

    @XxlJob(value="SysFileConvertTask-loadNeedConvertFile")
    public void loadNeedConvertFile() {
        log.info("\u3010\u52a0\u8f7d\u9700\u8981\u8f6c\u6362\u7684\u9644\u4ef6\u3011   \u5f00\u59cb");
        List<SysFile> needConvertFileList = this.sysFileService.getNeedConvertFile(1000);
        if (CollectionUtils.isNotEmpty(needConvertFileList)) {
            for (SysFile sysFile : needConvertFileList) {
                sysFile.setConvertFlag(SysFileConvertEnum.CONVERTING.getCode());
            }
            this.sysFileService.updateConvertState(needConvertFileList);
            for (SysFile sysFile : needConvertFileList) {
                this.executorService.execute(() -> this.convertFile(sysFile));
            }
        }
        log.info("\u3010\u52a0\u8f7d\u9700\u8981\u8f6c\u6362\u7684\u9644\u4ef6\u3011   \u7ed3\u675f");
    }

    @XxlJob(value="SysFileConvertTask-handleRecycleFile")
    public void handleRecycleFile() throws InterruptedException {
        List<SysFile> sysFiles;
        log.info("\u3010\u56de\u6536\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u5f00\u59cb");
        int pages = 0;
        do {
            ++pages;
            sysFiles = this.sysFileService.pageFileByRecycle(1, 1000);
            if (CollectionUtils.isEmpty(sysFiles)) {
                return;
            }
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406page:{} \u7684\u6570\u636e", (Object[])new Object[]{pages});
            this.dohandleRecycleFile(sysFiles);
        } while (sysFiles.size() >= 1000);
        log.info("\u3010\u56de\u6536\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u7ed3\u675f");
    }

    public void dohandleRecycleFile(List<SysFile> sysFiles) throws InterruptedException {
        List<Long> successList = Collections.synchronizedList(new ArrayList());
        List<Long> failList = Collections.synchronizedList(new ArrayList());
        CountDownLatch cdl = new CountDownLatch(sysFiles.size());
        for (SysFile sysFile : sysFiles) {
            this.executorService.execute(() -> {
                try {
                    String destOssUrl = "smarthse-recycle/" + sysFile.getOssUrl();
                    if (StringUtils.isNotBlank((String)sysFile.getOssUrl()) && sysFile.getOssUrl().startsWith("/")) {
                        destOssUrl = "smarthse-recycle" + sysFile.getOssUrl();
                    }
                    this.ossClientBean.moveOssFile(sysFile.getOssUrl(), destOssUrl, true);
                    successList.add(sysFile.getId());
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a{}", (Throwable)e);
                    failList.add(sysFile.getId());
                }
                finally {
                    cdl.countDown();
                }
            });
        }
        cdl.await();
        if (CollectionUtils.isNotEmpty(successList)) {
            this.sysFileService.updateRecycleFlag(11, successList);
        }
        if (CollectionUtils.isNotEmpty(failList)) {
            this.sysFileService.updateRecycleFlag(13, failList);
        }
    }

    @XxlJob(value="SysFileConvertTask-handleUndoRecycleFile")
    public void handleUndoRecycleFile() throws InterruptedException {
        List<SysFile> sysFiles;
        log.info("\u3010\u64a4\u9500\u56de\u6536\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u5f00\u59cb");
        int pages = 0;
        do {
            ++pages;
            sysFiles = this.sysFileService.pageFileByRecycle(2, 1000);
            if (CollectionUtils.isEmpty(sysFiles)) {
                return;
            }
            List<Long> successList = Collections.synchronizedList(new ArrayList());
            List<Long> failList = Collections.synchronizedList(new ArrayList());
            CountDownLatch cdl = new CountDownLatch(sysFiles.size());
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406page:{} \u7684\u6570\u636e", (Object[])new Object[]{pages});
            for (SysFile sysFile : sysFiles) {
                this.executorService.execute(() -> {
                    try {
                        String destOssUrl = "smarthse-recycle/" + sysFile.getOssUrl();
                        if (StringUtils.isNotBlank((String)sysFile.getOssUrl()) && sysFile.getOssUrl().startsWith("/")) {
                            destOssUrl = "smarthse-recycle" + sysFile.getOssUrl();
                        }
                        this.ossClientBean.moveOssFile(destOssUrl, sysFile.getOssUrl(), true);
                        successList.add(sysFile.getId());
                    }
                    catch (Exception e) {
                        log.error("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a{}", (Throwable)e);
                        failList.add(sysFile.getId());
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            cdl.await();
            if (CollectionUtils.isNotEmpty(successList)) {
                this.sysFileService.updateRecycleFlag(21, successList);
            }
            if (!CollectionUtils.isNotEmpty(failList)) continue;
            this.sysFileService.updateRecycleFlag(23, failList);
        } while (sysFiles.size() >= 1000);
        log.info("\u3010\u64a4\u9500\u56de\u6536\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u7ed3\u675f");
    }

    @XxlJob(value="SysFileConvertTask-handleUndoDelFile")
    public void handleUndoDelFile() throws InterruptedException {
        List<SysFile> sysFiles;
        log.info("\u3010\u64a4\u9500\u5220\u9664\u7684\u6587\u4ef6\u3011   \u5f00\u59cb");
        int pages = 0;
        do {
            ++pages;
            sysFiles = this.sysFileService.pageFileByRecycle(4, 1000);
            if (CollectionUtils.isEmpty(sysFiles)) {
                return;
            }
            List<Long> successList = Collections.synchronizedList(new ArrayList());
            List<Long> failList = Collections.synchronizedList(new ArrayList());
            CountDownLatch cdl = new CountDownLatch(sysFiles.size());
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406page:{} \u7684\u6570\u636e", (Object[])new Object[]{pages});
            for (SysFile sysFile : sysFiles) {
                this.executorService.execute(() -> {
                    try {
                        String destOssUrl = "smarthse-deleted/" + sysFile.getOssUrl();
                        if (StringUtils.isNotBlank((String)sysFile.getOssUrl()) && sysFile.getOssUrl().startsWith("/")) {
                            destOssUrl = "smarthse-deleted" + sysFile.getOssUrl();
                        }
                        this.ossClientBean.copyOssFile(destOssUrl, sysFile.getOssUrl());
                        successList.add(sysFile.getId());
                    }
                    catch (Exception e) {
                        log.error("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a{}", (Throwable)e);
                        failList.add(sysFile.getId());
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            cdl.await();
            if (CollectionUtils.isNotEmpty(successList)) {
                this.sysFileService.updateRecycleFlag(41, successList);
            }
            if (!CollectionUtils.isNotEmpty(failList)) continue;
            this.sysFileService.updateRecycleFlag(43, failList);
        } while (sysFiles.size() >= 1000);
        log.info("\u3010\u64a4\u9500\u5220\u9664\u7684\u6587\u4ef6\u3011   \u7ed3\u675f");
    }

    @XxlJob(value="SysFileConvertTask-handleDelFile")
    public void handleDelFile() throws InterruptedException {
        List<SysFile> sysFiles;
        log.info("\u3010\u76f4\u63a5\u5220\u9664\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u5f00\u59cb");
        int pages = 0;
        do {
            ++pages;
            sysFiles = this.sysFileService.pageFileByRecycle(3, 1000);
            if (CollectionUtils.isEmpty(sysFiles)) {
                return;
            }
            List<Long> successList = Collections.synchronizedList(new ArrayList());
            List<Long> failList = Collections.synchronizedList(new ArrayList());
            CountDownLatch cdl = new CountDownLatch(sysFiles.size());
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406page:{} \u7684\u6570\u636e", (Object[])new Object[]{pages});
            for (SysFile sysFile : sysFiles) {
                this.executorService.execute(() -> {
                    try {
                        String destOssUrl = "smarthse-deleted/" + sysFile.getOssUrl();
                        if (StringUtils.isNotBlank((String)sysFile.getOssUrl()) && sysFile.getOssUrl().startsWith("/")) {
                            destOssUrl = "smarthse-deleted" + sysFile.getOssUrl();
                        }
                        this.ossClientBean.moveOssFile(sysFile.getOssUrl(), destOssUrl, true);
                        successList.add(sysFile.getId());
                    }
                    catch (Exception e) {
                        log.error("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a{}", (Throwable)e);
                        failList.add(sysFile.getId());
                    }
                    finally {
                        cdl.countDown();
                    }
                });
            }
            cdl.await();
            if (CollectionUtils.isNotEmpty(successList)) {
                this.sysFileService.updateRecycleFlag(31, successList);
            }
            if (!CollectionUtils.isNotEmpty(failList)) continue;
            this.sysFileService.updateRecycleFlag(33, failList);
        } while (sysFiles.size() >= 1000);
        log.info("\u3010\u76f4\u63a5\u5220\u9664\u65e0\u6548\u7684\u6587\u4ef6\u3011   \u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFile(SysFile needConvertFile) {
        String outOssUrl = needConvertFile.getOssUrl();
        String fileName = FileUtils.getFileNameFromURL(outOssUrl);
        String suffixName = FileUtils.suffixFromUrl(outOssUrl);
        File destFile = null;
        try {
            destFile = File.createTempFile(UUID.randomUUID().toString(), suffixName);
            HttpUtil.downloadFile((String)outOssUrl, (File)destFile);
            String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + suffixName, destFile, "outurl/convertfile", fileName, null);
            needConvertFile.setConvertFlag(SysFileConvertEnum.CONVERTED.getCode());
            needConvertFile.setOssUrl(oss);
            this.sysFileService.updateConvertState(Arrays.asList(needConvertFile));
        }
        catch (Exception e) {
            needConvertFile.setConvertFlag(SysFileConvertEnum.ERROR.getCode());
            String message = e.getMessage();
            needConvertFile.setConvertErrReason(StringUtils.abbreviate((String)message, (int)200));
            this.sysFileService.updateConvertState(Arrays.asList(needConvertFile));
            log.error("\u8f6c\u6362\u9644\u4ef6\u51fa\u9519:", (Throwable)e);
        }
        finally {
            if (destFile != null) {
                destFile.delete();
            }
        }
    }

    @Generated
    public SysFileConvertTask() {
    }
}

