/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.task;

import cn.smarthse.common.util.date.TimeUtil;
import cn.smarthse.modules.datacentre.dao.system.DelayedSmsMapper;
import cn.smarthse.modules.datacentre.model.sms.DelayedSms;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedSmsTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelayedSmsTask.class);
    @Autowired
    private DelayedSmsMapper delayedSmsMapper;
    @Autowired
    private ISMSProvideMasService masService;
    @Autowired
    private ISMSProviderWelinkService welinkService;

    @XxlJob(value="DelayedSms-resend")
    public void resendDelayedSms() {
        Boolean isWeekday = HolidayUtils.isWeekday((LocalDate)LocalDate.now());
        List<DelayedSms> smsList = this.delayedSmsMapper.getUnsentSms();
        if (!isWeekday.booleanValue()) {
            smsList = smsList.stream().filter(sms -> sms.getWorkdayOnly() == null || sms.getWorkdayOnly() != 1).collect(Collectors.toList());
        }
        for (DelayedSms sms2 : smsList) {
            try {
                LocalTime start = LocalTime.parse(sms2.getAllowedStartTime());
                LocalTime end = LocalTime.parse(sms2.getAllowedEndTime());
                if (TimeUtil.isWithinAllowedTime((LocalTime)start, (LocalTime)end)) {
                    if (sms2.getSmsType() == 1) {
                        this.masService.sendSms(sms2.getMobile(), sms2.getContent());
                    } else if (sms2.getSmsType() == 2) {
                        this.welinkService.singleSendSms(sms2.getMobile(), sms2.getContent());
                    } else {
                        log.warn("\u672a\u77e5\u7684\u77ed\u4fe1\u7c7b\u578b -> \u77ed\u4fe1ID\uff1a{}\uff0c\u7c7b\u578b\uff1a{}", (Object)sms2.getId(), (Object)sms2.getSmsType());
                        continue;
                    }
                    sms2.setStatus(1);
                    sms2.setSendTime(LocalDateTime.now());
                    this.delayedSmsMapper.updateByPrimaryKey(sms2);
                    Thread.sleep(500L);
                    log.info("\u8865\u53d1\u6210\u529f -> \u77ed\u4fe1ID\uff1a{}\uff0c\u624b\u673a\u53f7\uff1a{}\uff0c\u7c7b\u578b\uff1a{}", new Object[]{sms2.getId(), sms2.getMobile(), sms2.getSmsType()});
                    continue;
                }
                log.info("\u5f53\u524d\u4e0d\u5728\u5141\u8bb8\u65f6\u95f4\u8303\u56f4\uff0c\u8df3\u8fc7\u77ed\u4fe1ID\uff1a{}", (Object)sms2.getId());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                log.error("\u77ed\u4fe1\u53d1\u9001\u88ab\u4e2d\u65ad -> \u77ed\u4fe1ID\uff1a{}", (Object)sms2.getId(), (Object)ie);
            }
            catch (Exception e) {
                log.error("\u8865\u53d1\u77ed\u4fe1\u5931\u8d25 -> \u77ed\u4fe1ID\uff1a{}", (Object)sms2.getId(), (Object)e);
            }
        }
    }
}

