/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.bootstrap.properties.ZwddProperties;
import cn.smarthse.modules.datacentre.dao.CompanyLngLatMapper;
import cn.smarthse.modules.datacentre.entity.CompanyLngLat;
import cn.smarthse.modules.datacentre.entity.CompanyLngLatChangeInfo;
import cn.smarthse.modules.datacentre.model.lnglat.SecretData;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sztech.gateway.shared.core.TypeRef;
import com.sztech.gateway.shared.jackson.JacksonUtil;
import com.sztech.gateway.shared.service.core.OpenServiceClient;
import com.sztech.gateway.shared.service.info.GatewayRequest;
import com.sztech.gateway.shared.service.info.GatewayResult;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CompanyLngLatTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyLngLatTask.class);
    @Resource
    private ZwddProperties zwddProperties;
    @Resource
    private CompanyLngLatMapper companyLngLatMapper;
    @Autowired
    private OpenServiceClient openServiceClient;
    private static SecretData secretCache = null;
    private final ObjectMapper objectMapper = JacksonUtil.MAPPER;
    private static final int limit = 1000;
    private static final int day_limit = 10000;
    @Value(value="${spring.profiles.active}")
    private String active;
    @Value(value="${x.security.check.type}")
    private String xSecurityCheckType;
    @Value(value="${x.security.user.id}")
    private String xSecurityUserId;
    @Value(value="${x.security.user.ip}")
    private String xSecurityUserIp;
    private static final String LNG_LAT_RESOURCE_CODE = "x83e086N0Z41FHh0";
    private final AtomicInteger refreshTokenCount = new AtomicInteger(0);
    private final AtomicInteger callIrsDataCount = new AtomicInteger(0);

    @XxlJob(value="CompanyLngLatTask-updateCompanyLngLat")
    public void updateCompanyLngLat() throws InterruptedException {
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0]::\u8fdb\u5165\u5b9a\u65f6\u4efb\u52a1::\u5f53\u524d\u73af\u5883[{}]", (Object[])new Object[]{this.active});
        if (this.active == null || !"pro".equalsIgnoreCase(this.active) && !"prod".equalsIgnoreCase(this.active) && Arrays.stream(this.active.split(",")).map(String::trim).noneMatch(s -> "pro".equalsIgnoreCase((String)s) || "prod".equalsIgnoreCase((String)s))) {
            return;
        }
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0]::start", (Object[])new Object[0]);
        this.companyLngLatMapper.initCompanyLngLat();
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0]::initCompanyLngLat::end", (Object[])new Object[0]);
        Long firstId = null;
        Long lastId = this.companyLngLatMapper.getLastId();
        int updateNum = 0;
        for (int i = 0; i < 10; ++i) {
            List<CompanyLngLat> companyList = this.companyLngLatMapper.getCompanyList(1000, lastId);
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0]::\u4e00\u6b21\u67e5\u8be21k\u6761\u6570\u636e::\u7b2c[{}]\u6279\u4f01\u4e1a\u603b\u6570[{}]", (Object[])new Object[]{i + 1, companyList.size()});
            if (CollUtil.isEmpty(companyList)) {
                lastId = null;
            } else {
                firstId = firstId == null ? companyList.get(0).getId() : firstId;
                lastId = companyList.get(companyList.size() - 1).getId();
                Map<Long, CompanyLngLatChangeInfo> lastLngLatChangeMap = this.getLastLngLatChangeMap(companyList.stream().map(CompanyLngLat::getId).collect(Collectors.toList()));
                for (CompanyLngLat company : companyList) {
                    CompanyLngLat irsLngLat;
                    Long cid = company.getId();
                    boolean needUpdateLngLat = this.isNeedUpdateLngLat(lastLngLatChangeMap.get(cid));
                    DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0]::cid[{}]\u662f\u5426\u9700\u8981\u66f4\u65b0[{}]", (Object[])new Object[]{cid, needUpdateLngLat});
                    if (needUpdateLngLat && (irsLngLat = this.invokeIRSLngLatWithSdk(company.getUnifiedSocialCc())) != null) {
                        String irsLng = irsLngLat.getIrsLng();
                        String irsLat = irsLngLat.getIrsLat();
                        if (CharSequenceUtil.isNotBlank((CharSequence)irsLng) && CharSequenceUtil.isNotBlank((CharSequence)irsLat)) {
                            this.companyLngLatMapper.updateLngLat(cid, irsLng, irsLat);
                            this.companyLngLatMapper.updateCompanyLngLat(cid, irsLng, irsLat);
                            ++updateNum;
                        }
                    }
                    Thread.sleep(4000L);
                }
            }
            DebugUtils.info((String)"\u5b9a\u65f6\u4efb\u52a1::\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0::index[{}]::firstId[{}]::lastId[{}]::updateNum[{}]::end", (Object[])new Object[]{i, firstId, lastId, updateNum});
        }
        this.companyLngLatMapper.addCompanyLngLatTaskLog(firstId, lastId, updateNum);
        DebugUtils.info((String)"\u5b9a\u65f6\u4efb\u52a1::\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0::addCompanyLngLatTaskLog::firstId[{}]::lastId[{}]::updateNum[{}]::end", (Object[])new Object[]{firstId, lastId, updateNum});
        DebugUtils.info((String)"\u5b9a\u65f6\u4efb\u52a1::\u4f01\u4e1a\u7ecf\u7eac\u5ea6\u66f4\u65b0::end", (Object[])new Object[0]);
    }

    private boolean isNeedUpdateLngLat(CompanyLngLatChangeInfo companyLngLatChangeInfo) {
        return companyLngLatChangeInfo == null || companyLngLatChangeInfo.getCreateDate() != null && DateUtils.addYear((Date)companyLngLatChangeInfo.getCreateDate(), (int)1).before(new Date());
    }

    private Map<Long, CompanyLngLatChangeInfo> getLastLngLatChangeMap(List<Long> cidList) {
        List<CompanyLngLatChangeInfo> lastLngLatChangeList = this.companyLngLatMapper.getLastCompanyLngLatChangeInfoList(cidList);
        if (CollUtil.isEmpty(lastLngLatChangeList)) {
            return new HashMap<Long, CompanyLngLatChangeInfo>();
        }
        return lastLngLatChangeList.stream().collect(Collectors.toMap(CompanyLngLatChangeInfo::getCid, Function.identity(), (l1, l2) -> l2));
    }

    public CompanyLngLat invokeIRSLngLatWithSdk(String unifiedSocialCc) {
        boolean hasData;
        String retString;
        SecretData secretData;
        if (CharSequenceUtil.isBlank((CharSequence)unifiedSocialCc)) {
            return null;
        }
        String appSecret = this.zwddProperties.getDataSharing().getJwd().getAppSecret();
        if (secretCache != null && System.currentTimeMillis() < secretCache.getRequestSecretEndTime()) {
            secretData = secretCache;
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u83b7\u53d6\u5230\u7f13\u5b58\u4e2d\u5bc6\u94a5\uff0c\u8fc7\u671f\u65f6\u95f4[{}]\u3002", (Object[])new Object[]{secretCache.getRequestSecretEndTime()});
        } else {
            secretData = this.refreshTokenByKeyWithSdk(appSecret);
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u83b7\u53d6\u5230SDK\u5237\u65b0\u5bc6\u94a5\u3002", (Object[])new Object[0]);
        }
        if (secretData == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u83b7\u53d6Secret\u51fa\u9519\u3002", (Object[])new Object[0]);
            return null;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-SECURITY-CHECK-TYPE", this.xSecurityCheckType);
        headerMap.put("X-SECURITY-USER-ID", this.xSecurityUserId);
        headerMap.put("X-SECURITY-USER-IP", this.xSecurityUserIp);
        headerMap.put("unicode", unifiedSocialCc);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("unicode", unifiedSocialCc);
        GatewayRequest request = GatewayRequest.builder().resourceCode(LNG_LAT_RESOURCE_CODE).requestSecret(secretData.getRequestSecret()).contentType("json").method("POST").headers(headerMap).body(bodyMap).build();
        int count = this.callIrsDataCount.incrementAndGet();
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u5f00\u59cb\u7b2c{}\u6b21\u8c03\u7528\u6570\u636e\u3002", (Object[])new Object[]{count});
        GatewayResult ret = this.openServiceClient.callGatewayService(request, (TypeRef)new TypeRef<GatewayResult<Object>>(){});
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u8bf7\u6c42\u7b2c\u4e00\u54cd\u5e94\u7ed3\u679c\u6253\u5370::{}", (Object[])new Object[]{ret});
        try {
            retString = this.objectMapper.writeValueAsString((Object)ret);
        }
        catch (Exception e) {
            throw new ServiceException("\u7a0b\u5e8f\u5f02\u5e38::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u7ed3\u679c\u89e3\u6790\u5931\u8d25::{}", (Throwable)e);
        }
        CompanyLngLat companyLngLat = new CompanyLngLat();
        companyLngLat.setUnifiedSocialCc(unifiedSocialCc);
        JSONObject retJson = JSONObject.parseObject((String)retString);
        if (retJson == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u7ed3\u679c\u4e3a\u7a7a::{}", (Object[])new Object[]{retString});
            return null;
        }
        String code = retJson.getString("code");
        if (!"00".equalsIgnoreCase(code)) {
            if ("11".equalsIgnoreCase(code)) {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::Token\u5df2\u8fc7\u671f/\u8fc7\u671f\u65f6\u95f4[{}]::\u672c\u5730\u65f6\u95f4[{}]::\u5373\u5c06\u91cd\u65b0\u5237\u65b0\u5bc6\u94a5", (Object[])new Object[]{DateUtil.getDateStringByMil((long)secretData.getRequestSecretEndTime()), DateUtil.getDateStringByMil((long)System.currentTimeMillis())});
                this.refreshTokenByKeyWithSdk(appSecret);
            }
            if ("14".equalsIgnoreCase(code)) {
                DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u7b7e\u540d\u9519\u8bef\uff0csign\u503c\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u6570\u636e\u8bf7\u6c42\u51fa\u9519/\u72b6\u6001\u7801[{}]::\u7ed3\u679c\u503c[{}]", (Object[])new Object[]{code, retJson});
            return null;
        }
        String datasString = retJson.getString("datas");
        boolean bl = hasData = CharSequenceUtil.isNotBlank((CharSequence)datasString) && !"[]".equalsIgnoreCase(datasString);
        if (hasData) {
            JSONArray jsonArray = JSONArray.parseArray((String)datasString);
            JSONObject jsonObject = (JSONObject)jsonArray.get(0);
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u8bf7\u6c42\u6210\u529f/\u54cd\u5e94\u7ed3\u679c[{}]", (Object[])new Object[]{retJson});
            companyLngLat.setIrsLat(jsonObject.getString("latitude"));
            companyLngLat.setIrsLng(jsonObject.getString("longitude"));
        } else {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u8bf7\u6c42\u6210\u529f/\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a[{}]", (Object[])new Object[]{retJson});
        }
        return companyLngLat;
    }

    public SecretData refreshTokenByKeyWithSdk(String appSecret) {
        String secretString;
        int count = this.refreshTokenCount.incrementAndGet();
        DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::IRS[\u7ecf\u7eac\u5ea6\u4fe1\u606f]::\u5f00\u59cb\u7b2c{}\u6b21\u5237\u65b0\u5bc6\u94a5\u3002", (Object[])new Object[]{count});
        GatewayResult secret = this.openServiceClient.refreshSecretByKey(appSecret);
        try {
            secretString = this.objectMapper.writeValueAsString((Object)secret);
        }
        catch (Exception e) {
            throw new ServiceException("\u7a0b\u5e8f\u5f02\u5e38::secret\u5bc6\u94a5\u89e3\u6790\u5931\u8d25::{}", (Throwable)e);
        }
        JSONObject secretJson = JSONObject.parseObject((String)secretString);
        if (secretJson == null) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::SDK\u65b9\u5f0f::\u6839\u636eappSecret\u5237\u65b0\u5bc6\u94a5::\u5bc6\u94a5\u7ed3\u679c\u4e3a\u7a7a::{}", (Object[])new Object[]{secretString});
            return null;
        }
        if (!"00".equalsIgnoreCase(secretJson.getString("code"))) {
            DebugUtils.error((String)"\u65e5\u5fd7\u6253\u5370::SDK\u65b9\u5f0f::\u6839\u636eappSecret\u5237\u65b0\u5bc6\u94a5::\u8bf7\u6c42\u51fa\u9519(code!=00)::{}", (Object[])new Object[]{secretString});
            return null;
        }
        SecretData secretData = null;
        String datasString = secretJson.getString("datas");
        if (CharSequenceUtil.isNotBlank((CharSequence)datasString)) {
            secretData = (SecretData)JSONUtil.toBean((String)datasString, SecretData.class);
        }
        if (secretData != null) {
            secretData.setCacheTime(LocalDateTime.now());
            secretData.setRequestSecretEndTime(System.currentTimeMillis() + 600000L);
            secretCache = secretData;
        }
        return secretData;
    }

    @Generated
    public CompanyLngLatTask() {
    }
}

