/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.riskFactors.impl;

import cn.smarthse.modules.datacentre.dao.system.riskFactors.OccupationalRiskFactorsMapper;
import cn.smarthse.modules.datacentre.entity.system.riskFactors.OccupationalRiskFactors;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.RiskFactorSearchModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskFactorsModel;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.riskFactors.IOccupationalRiskFactorsService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class OccupationalRiskFactorsServiceImpl
extends ZYJBaseServiceImpl<OccupationalRiskFactorsMapper, OccupationalRiskFactors>
implements IOccupationalRiskFactorsService {
    @Override
    public List<OccupationalRiskFactorsModel> getRiskFactorsList(RiskFactorSearchModel param) {
        List<OccupationalRiskFactorsModel> list = ((OccupationalRiskFactorsMapper)this.dao).selectRiskFactorsList(param);
        if (list != null && !list.isEmpty()) {
            list.stream().forEach(record -> {
                StringBuffer sb = new StringBuffer();
                if (record.getBelongCatalog() == 1) {
                    sb.append("\u76ee\u5f55\uff0c");
                }
                if (record.getBelongGbz22007() == 1) {
                    sb.append("GBZ2-2007\uff0c");
                }
                if (record.getBelongGbz188() == 1) {
                    sb.append("GBZ188-2014\uff0c");
                }
                if (record.getBelongGbz22019() == 1) {
                    sb.append("GBZ2-2019\uff0c");
                }
                if (sb.length() > 1) {
                    record.setResourceStr(sb.toString().substring(0, sb.length() - 1));
                }
            });
        }
        return list;
    }

    @Override
    public PageInfo<OccupationalRiskFactorsModel> getRiskFactorsListData(RiskFactorSearchModel param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<OccupationalRiskFactorsModel> list = this.getRiskFactorsList(param);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public List<OccupationalRiskFactorsModel> getRiskFactorsListByType(String type) {
        RiskFactorSearchModel param = new RiskFactorSearchModel();
        param.setType(type);
        List<OccupationalRiskFactorsModel> list = this.getRiskFactorsList(param);
        return list;
    }

    @Override
    public OccupationalRiskFactorsModel getRiskFactors(Long id) {
        RiskFactorSearchModel param = new RiskFactorSearchModel();
        param.setRiskFactorId(id);
        List<OccupationalRiskFactorsModel> list = this.getRiskFactorsList(param);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Override
    public boolean isExistParamCode(String paramCode) {
        Example e = new Example(OccupationalRiskFactors.class);
        e.createCriteria().andEqualTo("paramCode", (Object)paramCode).andEqualTo("isValid", (Object)true);
        return this.getCountByExample(e) > 0;
    }

    @Override
    public OccupationalRiskFactors getByParamCode(String paramCode) {
        Example e = new Example(OccupationalRiskFactors.class);
        e.createCriteria().andEqualTo("paramCode", (Object)paramCode).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(e);
        return list == null || list.isEmpty() ? null : (OccupationalRiskFactors)list.get(0);
    }
}

