/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.smarthse.modules.datacentre.dao.system.SysVirtualAreaMapper;
import cn.smarthse.modules.datacentre.entity.system.SysVirtualArea;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysVirtualAreaService;
import cn.smarthse.modules.datacentre.util.PinyinUtil;
import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.util.common.StringUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SysVirtualAreaServiceImpl
extends ZYJBaseServiceImpl<SysVirtualAreaMapper, SysVirtualArea>
implements ISysVirtualAreaService {
    @Autowired
    private ISysAreaService areaService;

    @Override
    @Transactional(readOnly=false)
    public SuperviseAreaModel addOrUpdateVirtualArea(SuperviseAreaModel model, Long loginStaffId) throws Exception {
        this.verifyParam(model);
        SysVirtualArea result = new SysVirtualArea();
        BeanUtils.copyProperties((Object)model, (Object)result);
        result.setChildrenId(model.getVirtualPid());
        this.settingPinyin(result);
        if (model.getId() == null) {
            String[] pids = model.getVirtualPid().split(",");
            String newAreaId = this.areaService.getNewAreaId(Long.parseLong(pids[0]));
            result.setId(Long.parseLong(newAreaId));
            result.setSort(Long.parseLong(newAreaId));
            result.setCreateDate(new Date());
            result.setIsValid(true);
            result.setParentId(Long.parseLong(model.getPid()));
            this.add(result, loginStaffId);
        } else {
            this.update(result, loginStaffId);
        }
        model.setId(result.getId());
        return model;
    }

    @Override
    public List<SysVirtualArea> getListByParentId(Long parentId) {
        return ((SysVirtualAreaMapper)this.dao).getListByParentId(parentId);
    }

    private void verifyParam(SuperviseAreaModel model) throws Exception {
        if (!StringUtils.isNotBlank((CharSequence)model.getVirtualPid())) {
            throw new Exception("\u865a\u62df\u533a\u57df\u7684\u7236\u7ea7\u4e3a\u7a7a");
        }
        if (!StringUtils.isNotBlank((CharSequence)model.getName())) {
            throw new Exception("\u865a\u62df\u533a\u57df\u7684\u540d\u79f0\u4e3a\u7a7a");
        }
        if (model.getLevel() == null) {
            throw new Exception("\u865a\u62df\u533a\u57df\u7684\u884c\u653f\u7ea7\u522b\u4e3a\u7a7a");
        }
        if (model.getPid() == null) {
            throw new Exception("\u865a\u62df\u533a\u57df\u7684\u7236\u7ea7\u4e3a\u7a7a");
        }
    }

    private void settingPinyin(SysVirtualArea result) {
        if (StringUtils.isNotBlank((CharSequence)result.getName())) {
            String pinyin = PinyinUtil.getPinyin(result.getName());
            String firstLetters = PinyinUtil.getFirstLettersUp(result.getName());
            result.setPy(firstLetters);
            result.setPyFull(pinyin);
        }
    }
}

