/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.modules.datacentre.dao.system.OperationFileSlicingMapper;
import cn.smarthse.modules.datacentre.dao.system.SysOperationFileMapper;
import cn.smarthse.modules.datacentre.entity.system.OperationFileSlicing;
import cn.smarthse.modules.datacentre.entity.system.SysOperationFile;
import cn.smarthse.modules.datacentre.enums.VideoSlicingStatusEnum;
import cn.smarthse.modules.datacentre.model.system.OperationFileVo;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileModel;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileVo;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.IOperationFileSlicingService;
import cn.smarthse.modules.datacentre.service.system.ISysOperationFileService;
import cn.smarthse.modules.datacentre.util.file.m3u8.OperationFileSlicingThread;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysOperationFileServiceImpl
extends ZYJBaseServiceImpl<SysOperationFileMapper, SysOperationFile>
implements ISysOperationFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysOperationFileServiceImpl.class);
    @Autowired
    private SysOperationFileMapper sysOperationFileMapper;
    @Autowired
    private OperationFileSlicingMapper operationFileSlicingMapper;
    @Autowired
    private IOperationFileSlicingService operationFileSlicingService;
    @Resource
    protected RedissonClient redissonClient;
    public static final String SYSOPERATIONFILEURL = "-sysOperationFileUrl:";
    public static final String SYSTEMWIDE = "systemWide:";
    @Resource
    private ISysFileProvideService sysFileService;
    @Autowired
    OssClientBean ossClientBean;
    @Autowired
    private IdWorker idworker;

    @Override
    public PageInfo<SysOperationFileVo> getOperationFilesByType(SysOperationFileModel model) {
        List<Object> sysOperationFileVoList = new ArrayList();
        if (ObjectUtil.isNull((Object)model.getSystemType())) {
            return new PageInfo(sysOperationFileVoList);
        }
        PageMethod.startPage((int)model.getPage(), (int)model.getRows());
        sysOperationFileVoList = this.sysOperationFileMapper.selectOperationFilesByType(model);
        for (SysOperationFileVo sysOperationFileVo : sysOperationFileVoList) {
            Long id = sysOperationFileVo.getId();
            List<OperationFileVo> fileList = this.operationFileSlicingMapper.getFileListBySysOperationId(id, 2);
            if (CollectionUtils.isNotEmpty(fileList)) {
                for (OperationFileVo fileModel : fileList) {
                    fileModel.setDestPath(fileModel.getOssUrl());
                    fileModel.setFullOssurl(this.ossClientBean.getUrl(fileModel.getOssUrl()));
                    fileModel.setOssUrl(fileModel.getFullOssurl());
                }
            }
            sysOperationFileVo.setFileList(fileList);
            List<OperationFileVo> videoList = this.operationFileSlicingMapper.getFileListBySysOperationId(id, 1);
            if (CollectionUtils.isNotEmpty(videoList)) {
                for (OperationFileVo fileModel : videoList) {
                    fileModel.setDestPath(fileModel.getOssUrl());
                    fileModel.setFullOssurl(this.ossClientBean.getUrl(fileModel.getOssUrl()));
                    fileModel.setOssUrl(fileModel.getFullOssurl());
                }
            }
            sysOperationFileVo.setVideoList(videoList);
        }
        return new PageInfo(sysOperationFileVoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOperationFilesByType(SysOperationFileModel model) {
        if (ObjectUtil.isNull((Object)model.getSystemType())) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7cfb\u7edf\u8303\u56f4\u4e3a\u5fc5\u9009\u9879");
        }
        String parameter = model.getParameter();
        if (ObjectUtil.isNull((Object)parameter)) {
            parameter = "";
        }
        if (StringUtils.isNotEmpty((String)parameter)) {
            parameter = parameter.trim().replaceAll("\\s+", "");
        }
        model.setRemarks(model.getRemarks().trim());
        Integer count = this.sysOperationFileMapper.selectRemarksCountExcludeId(model);
        if (count > 0) {
            throw new ServiceException("\u9875\u9762\u540d\u79f0\u552f\u4e00\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        RMap map = this.redissonClient.getMap(SYSTEMWIDE + model.getSystemType() + SYSOPERATIONFILEURL + model.getUrl());
        map.delete();
        RMap mapNull = this.redissonClient.getMap(SYSTEMWIDE + model.getSystemType() + "-sysOperationFileUrl:null");
        mapNull.delete();
        Example example = new Example(SysOperationFile.class);
        example.createCriteria().andEqualTo("url", (Object)model.getUrl()).andEqualTo("systemWide", (Object)model.getSystemType());
        List sysOperationFiles = this.getListByExample(example);
        SysOperationFile oldSysOperationFile = null;
        for (SysOperationFile sysOperationFile : sysOperationFiles) {
            if (StringUtils.isEmpty((CharSequence)parameter) && StringUtils.isEmpty((CharSequence)sysOperationFile.getParameter())) {
                if (sysOperationFile.getIsValid().equals(true)) {
                    throw new ServiceException("\u8be5\u9875\u9762\u5728\u7cfb\u7edf\u5f53\u4e2d\u5df2\u7ecf\u5b58\u5728");
                }
                oldSysOperationFile = sysOperationFile;
                break;
            }
            if (!StringUtils.isNotEmpty((String)parameter) || !parameter.equals(sysOperationFile.getParameter())) continue;
            if (sysOperationFile.getIsValid().equals(true)) {
                throw new ServiceException("\u8be5\u9875\u9762\u5728\u7cfb\u7edf\u5f53\u4e2d\u5df2\u7ecf\u5b58\u5728");
            }
            oldSysOperationFile = sysOperationFile;
            break;
        }
        if (ObjectUtil.isNull(oldSysOperationFile)) {
            SysOperationFile newSysOperationFile = new SysOperationFile();
            newSysOperationFile.setId(this.idworker.nextId());
            newSysOperationFile.setUrl(model.getUrl());
            newSysOperationFile.setParameter(parameter);
            newSysOperationFile.setSystemWide(model.getSystemType());
            newSysOperationFile.setRemarks(model.getRemarks());
            newSysOperationFile.setUpdateBy(model.getLoginUserId());
            newSysOperationFile.setCreateBy(model.getLoginUserId());
            newSysOperationFile.setCreateDate(new Date());
            newSysOperationFile.setUpdateDate(new Date());
            newSysOperationFile.setIsValid(true);
            this.sysOperationFileMapper.insert(newSysOperationFile);
            return;
        }
        oldSysOperationFile.setParameter(parameter);
        oldSysOperationFile.setUrl(model.getUrl());
        oldSysOperationFile.setSystemWide(model.getSystemType());
        oldSysOperationFile.setRemarks(model.getRemarks());
        oldSysOperationFile.setUpdateBy(model.getLoginUserId());
        oldSysOperationFile.setUpdateDate(new Date());
        oldSysOperationFile.setIsValid(true);
        this.sysOperationFileMapper.updateByPrimaryKey(oldSysOperationFile);
        this.operationFileSlicingMapper.initializationByOperationFileId(oldSysOperationFile.getId(), oldSysOperationFile.getUpdateBy());
        map.delete();
        mapNull.delete();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFilesById(SysOperationFileModel model) {
        SysOperationFile byId = this.getSysOperationFile(model);
        RMap map = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + SYSOPERATIONFILEURL + byId.getUrl());
        map.delete();
        RMap mapNull = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + "-sysOperationFileUrl:null");
        mapNull.delete();
        List<OperationFileSlicing> operationFileSlicings = this.operationFileSlicingMapper.selectAllFileByOperationFileId(model);
        Map<Long, OperationFileSlicing> operationFileSlicingMap = operationFileSlicings.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getFileId()) && ObjectUtil.isNotNull((Object)s.getFileType())).collect(Collectors.toMap(OperationFileSlicing::getFileId, s -> s, (s1, s2) -> s1));
        ArrayList<OperationFileSlicing> addOperationFileSlicings = new ArrayList<OperationFileSlicing>();
        ArrayList<OperationFileSlicing> slicingsFileIds = new ArrayList<OperationFileSlicing>();
        if (model.getFileIdsType() == 1) {
            for (OperationFileSlicing operationFileSlicing2 : operationFileSlicings) {
                Integer videoSlicingStatus = operationFileSlicing2.getVideoSlicingStatus();
                if (!Boolean.TRUE.equals(operationFileSlicing2.getIsValid()) || !ObjectUtil.isNotNull((Object)operationFileSlicing2.getFileId()) || !ObjectUtil.isNull((Object)videoSlicingStatus) && videoSlicingStatus != VideoSlicingStatusEnum.NOT.getCode() && videoSlicingStatus != VideoSlicingStatusEnum.FAIL.getCode()) continue;
                operationFileSlicing2.setUpdateBy(model.getLoginUserId());
                slicingsFileIds.add(operationFileSlicing2);
            }
        }
        if (MapUtils.isNotEmpty(operationFileSlicingMap)) {
            for (Long fileId : model.getFileIds()) {
                OperationFileSlicing operationFileSlicing3 = operationFileSlicingMap.get(fileId);
                if (ObjectUtil.isNotNull((Object)operationFileSlicing3)) {
                    if (Boolean.TRUE.equals(operationFileSlicing3.getIsValid())) continue;
                    operationFileSlicing3.setIsValid(true);
                    operationFileSlicing3.setUpdateBy(model.getLoginUserId());
                    operationFileSlicing3.setUpdateDate(new Date());
                    this.operationFileSlicingMapper.updateById(operationFileSlicing3);
                    if (model.getFileIdsType() != 1) continue;
                    Integer videoSlicingStatus = operationFileSlicing3.getVideoSlicingStatus();
                    if (!ObjectUtil.isNotNull((Object)operationFileSlicing3.getFileId()) || !ObjectUtil.isNull((Object)videoSlicingStatus) && videoSlicingStatus != VideoSlicingStatusEnum.NOT.getCode() && videoSlicingStatus != VideoSlicingStatusEnum.FAIL.getCode()) continue;
                    slicingsFileIds.add(operationFileSlicing3);
                    continue;
                }
                OperationFileSlicing newOperationFileSlicing = new OperationFileSlicing();
                newOperationFileSlicing.setId(this.idworker.nextId());
                newOperationFileSlicing.setOperationFileId(model.getId());
                newOperationFileSlicing.setFileId(fileId);
                newOperationFileSlicing.setSystemWide(model.getSystemWide());
                newOperationFileSlicing.setFileType(model.getFileIdsType());
                newOperationFileSlicing.setVideoSlicingStatus(model.getFileIdsType() == 1 ? VideoSlicingStatusEnum.NOT.getCode() : null);
                newOperationFileSlicing.setCreateBy(model.getLoginUserId());
                newOperationFileSlicing.setUpdateBy(model.getLoginUserId());
                newOperationFileSlicing.setCreateDate(new Date());
                newOperationFileSlicing.setUpdateDate(new Date());
                addOperationFileSlicings.add(newOperationFileSlicing);
                if (model.getFileIdsType() != 1) continue;
                slicingsFileIds.add(newOperationFileSlicing);
            }
        } else {
            for (Long fileId : model.getFileIds()) {
                OperationFileSlicing newOperationFileSlicing = new OperationFileSlicing();
                newOperationFileSlicing.setId(this.idworker.nextId());
                newOperationFileSlicing.setOperationFileId(model.getId());
                newOperationFileSlicing.setFileId(fileId);
                newOperationFileSlicing.setSystemWide(model.getSystemWide());
                newOperationFileSlicing.setFileType(model.getFileIdsType());
                newOperationFileSlicing.setVideoSlicingStatus(model.getFileIdsType() == 1 ? VideoSlicingStatusEnum.NOT.getCode() : null);
                newOperationFileSlicing.setCreateBy(model.getLoginUserId());
                newOperationFileSlicing.setUpdateBy(model.getLoginUserId());
                newOperationFileSlicing.setCreateDate(new Date());
                newOperationFileSlicing.setUpdateDate(new Date());
                addOperationFileSlicings.add(newOperationFileSlicing);
                if (model.getFileIdsType() != 1) continue;
                slicingsFileIds.add(newOperationFileSlicing);
            }
        }
        if (addOperationFileSlicings.size() > 0) {
            this.operationFileSlicingMapper.batchInsertOperationFileSlicing(addOperationFileSlicings);
        }
        if (slicingsFileIds.size() > 0) {
            ExecutorService executorService = Executors.newFixedThreadPool(slicingsFileIds.size());
            slicingsFileIds.forEach(operationFileSlicing -> executorService.execute(new OperationFileSlicingThread(this.sysFileService, (OperationFileSlicing)operationFileSlicing, this.operationFileSlicingService, this.ossClientBean, (RMap<String, SysOperationFileVo>)map, (RMap<String, SysOperationFileVo>)mapNull, this.redissonClient)));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delFilesById(SysOperationFileModel model) {
        SysOperationFile byId = this.getSysOperationFile(model);
        RMap map = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + SYSOPERATIONFILEURL + byId.getUrl());
        map.delete();
        RMap mapNull = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + "-sysOperationFileUrl:null");
        mapNull.delete();
        for (Long fileId : model.getFileIds()) {
            this.operationFileSlicingMapper.delFilesById(fileId, model.getId(), model.getLoginUserId(), model.getFileIdsType(), model.getSystemWide());
        }
        map.delete();
        mapNull.delete();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updRemarksById(SysOperationFileModel model) {
        if (ObjectUtil.isNull((Object)model.getId())) {
            throw new ServiceException("\u672a\u6307\u5b9a\u8def\u5f84");
        }
        SysOperationFile byId = (SysOperationFile)this.getById(model.getId());
        if (ObjectUtil.isNull((Object)byId) || byId.getIsValid().equals(false)) {
            throw new ServiceException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u8def\u5f84");
        }
        model.setRemarks(model.getRemarks().trim());
        Integer count = this.sysOperationFileMapper.selectRemarksCountExcludeId(model);
        if (count > 0) {
            throw new ServiceException("\u9875\u9762\u540d\u79f0\u552f\u4e00\uff0c\u4e0d\u80fd\u91cd\u590d");
        }
        byId.setRemarks(model.getRemarks());
        byId.setUpdateBy(model.getLoginUserId());
        byId.setUpdateDate(new Date());
        this.sysOperationFileMapper.updateByPrimaryKey(byId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delOperationFilesById(SysOperationFileModel model) {
        if (ObjectUtil.isNull((Object)model.getId())) {
            throw new ServiceException("\u672a\u6307\u5b9a\u8def\u5f84");
        }
        SysOperationFile byId = (SysOperationFile)this.getById(model.getId());
        if (ObjectUtil.isNotNull((Object)byId) && byId.getIsValid().equals(true)) {
            RMap map = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + SYSOPERATIONFILEURL + byId.getUrl());
            map.delete();
            RMap mapNull = this.redissonClient.getMap(SYSTEMWIDE + byId.getSystemWide() + "-sysOperationFileUrl:null");
            mapNull.delete();
            byId.setUpdateBy(model.getLoginUserId());
            byId.setUpdateDate(new Date());
            byId.setIsValid(false);
            this.sysOperationFileMapper.updatebyId(byId);
            this.operationFileSlicingMapper.initializationByOperationFileId(byId.getId(), byId.getUpdateBy());
            map.delete();
            mapNull.delete();
        }
    }

    @Override
    public SysOperationFileVo getFilesByUrlAndType(SysOperationFileModel model) {
        if (ObjectUtil.isNull((Object)model.getSystemType())) {
            return new SysOperationFileVo();
        }
        String parameter = model.getParameter();
        if (ObjectUtil.isNull((Object)parameter)) {
            parameter = "";
        }
        if (StringUtils.isNotEmpty((String)parameter)) {
            parameter = parameter.trim().replaceAll("\\s+", "");
        }
        SysOperationFileVo sysOperationFileVoLast = null;
        SysOperationFileVo sysOperationFileVoNull1 = null;
        RMap map = this.redissonClient.getMap(SYSTEMWIDE + model.getSystemType() + SYSOPERATIONFILEURL + model.getUrl());
        Set parameters = map.keySet();
        if (ObjectUtil.isNull((Object)model.getUrl())) {
            if (parameters.size() > 0) {
                Collection values = map.getAll(parameters).values();
                sysOperationFileVoNull1 = new SysOperationFileVo();
                List<Object> videoList = new ArrayList();
                List<Object> fileList = new ArrayList();
                if (ObjectUtil.isNotNull((Object)model.getPermissions())) {
                    String permissions = model.getPermissions();
                    for (SysOperationFileVo value : values) {
                        for (OperationFileVo operationFileVo : value.getVideoList()) {
                            if (!ObjectUtil.isNotNull((Object)operationFileVo.getSystemWide()) || !permissions.contains(operationFileVo.getSystemWide().toString())) continue;
                            videoList.add(operationFileVo);
                        }
                        for (OperationFileVo operationFileVo : value.getFileList()) {
                            if (!ObjectUtil.isNotNull((Object)operationFileVo.getSystemWide()) || !permissions.contains(operationFileVo.getSystemWide().toString())) continue;
                            fileList.add(operationFileVo);
                        }
                    }
                } else {
                    for (SysOperationFileVo value : values) {
                        videoList.addAll(value.getVideoList());
                        fileList.addAll(value.getFileList());
                    }
                }
                videoList = videoList.stream().sorted(Comparator.comparing(OperationFileVo::getUpdateDate)).collect(Collectors.toList());
                fileList = fileList.stream().sorted(Comparator.comparing(OperationFileVo::getUpdateDate)).collect(Collectors.toList());
                sysOperationFileVoNull1.setVideoList(videoList);
                sysOperationFileVoNull1.setFileList(fileList);
                return sysOperationFileVoNull1;
            }
        } else if (parameters.size() > 0) {
            for (String s : parameters) {
                if ("".equals(s)) {
                    sysOperationFileVoNull1 = (SysOperationFileVo)map.get((Object)s);
                }
                if (parameter.equals("")) {
                    if (!"".equals(s)) continue;
                    sysOperationFileVoLast = (SysOperationFileVo)map.get((Object)s);
                    continue;
                }
                if ("".equals(s)) continue;
                List<String> strings = Arrays.asList(s.split("&"));
                List<String> strings1 = Arrays.asList(parameter.split("&"));
                if (!strings1.containsAll(strings)) continue;
                sysOperationFileVoLast = (SysOperationFileVo)map.get((Object)s);
            }
            if (ObjectUtil.isNull(sysOperationFileVoLast)) {
                if (ObjectUtil.isNotNull((Object)sysOperationFileVoNull1)) {
                    return sysOperationFileVoNull1;
                }
            } else {
                return sysOperationFileVoLast;
            }
        }
        SysOperationFileVo sysOperationFileVoNull = new SysOperationFileVo();
        List<SysOperationFile> sysOperationFiles = this.sysOperationFileMapper.getAllListByUrlAndType(model.getSystemType(), model.getUrl());
        List<Object> videoListVo = new ArrayList();
        List<Object> fileListVo = new ArrayList();
        for (SysOperationFile sysOperationFile : sysOperationFiles) {
            SysOperationFileVo sysOperationFileVo = new SysOperationFileVo();
            sysOperationFileVo.setId(sysOperationFile.getId());
            sysOperationFileVo.setUrl(sysOperationFile.getUrl());
            sysOperationFileVo.setParameter(sysOperationFile.getParameter());
            sysOperationFileVo.setSystemWide(sysOperationFile.getSystemWide());
            Long id = sysOperationFile.getId();
            List<OperationFileVo> fileList = this.operationFileSlicingMapper.getFileListBySysOperationId(id, 2);
            if (CollectionUtils.isNotEmpty(fileList)) {
                for (OperationFileVo operationFileVo : fileList) {
                    int i;
                    operationFileVo.setDestPath(operationFileVo.getOssUrl());
                    operationFileVo.setFullOssurl(this.ossClientBean.getUrl(operationFileVo.getOssUrl()));
                    operationFileVo.setOssUrl(operationFileVo.getFullOssurl());
                    String fileName = operationFileVo.getFileName();
                    String fileExt = operationFileVo.getFileExt();
                    if (!StringUtils.isNotEmpty((String)fileName) || !StringUtils.isNotEmpty((String)fileExt) || (i = fileName.lastIndexOf("." + fileExt)) == -1) continue;
                    operationFileVo.setFileName(fileName.substring(0, i));
                }
            }
            sysOperationFileVo.setFileList(fileList);
            fileListVo.addAll(fileList);
            List<OperationFileVo> list = this.operationFileSlicingMapper.getOperationSlicingBySysOperationId(id);
            if (CollectionUtils.isNotEmpty(list)) {
                for (OperationFileVo fileModel2 : list) {
                    int i;
                    fileModel2.setDestPath(fileModel2.getOssUrl());
                    fileModel2.setFullOssurl(this.ossClientBean.getUrl(fileModel2.getOssUrl()));
                    String remarks = model.getRemarks();
                    fileModel2.setPlayPath(remarks);
                    if (StringUtils.isNotEmpty((String)remarks)) {
                        if (remarks.equals("smarthse.51vip.biz")) {
                            fileModel2.setPlayPath("http://smarthse.51vip.biz:19903/static/play.html?vodId=" + fileModel2.getId());
                        }
                        if (remarks.equals("ohonline.wsjkw.zj.gov.cn")) {
                            fileModel2.setPlayPath("https://ohonline.wsjkw.zj.gov.cn:8184/static/play.html?vodId=" + fileModel2.getId());
                        }
                    }
                    fileModel2.setOssUrl(fileModel2.getFullOssurl());
                    String fileName = fileModel2.getFileName();
                    String fileExt = fileModel2.getFileExt();
                    if (!StringUtils.isNotEmpty((String)fileName) || !StringUtils.isNotEmpty((String)fileExt) || (i = fileName.lastIndexOf("." + fileExt)) == -1) continue;
                    fileModel2.setFileName(fileName.substring(0, i));
                }
            }
            videoListVo.addAll(list);
            sysOperationFileVo.setVideoList(list);
            if ("".equals(sysOperationFile.getParameter())) {
                sysOperationFileVoNull = sysOperationFileVo;
            }
            if (parameter.equals("")) {
                if ("".equals(sysOperationFile.getParameter())) {
                    sysOperationFileVoLast = sysOperationFileVo;
                }
            } else if (!"".equals(sysOperationFile.getParameter())) {
                List<String> list2 = Arrays.asList(sysOperationFile.getParameter().split("&"));
                List<String> strings1 = Arrays.asList(parameter.split("&"));
                if (strings1.containsAll(list2)) {
                    sysOperationFileVoLast = sysOperationFileVo;
                }
            }
            map.put((Object)sysOperationFile.getParameter(), (Object)sysOperationFileVo);
        }
        map.expire(60L, TimeUnit.MINUTES);
        if (ObjectUtil.isNull((Object)model.getUrl())) {
            SysOperationFileVo sysOperationFileVo = new SysOperationFileVo();
            ArrayList<Object> videoList = new ArrayList<Object>();
            ArrayList<Object> fileList = new ArrayList<Object>();
            videoListVo = videoListVo.stream().sorted(Comparator.comparing(OperationFileVo::getUpdateDate)).collect(Collectors.toList());
            fileListVo = fileListVo.stream().sorted(Comparator.comparing(OperationFileVo::getUpdateDate)).collect(Collectors.toList());
            if (ObjectUtil.isNotNull((Object)model.getPermissions())) {
                String permissions = model.getPermissions();
                for (OperationFileVo operationFileVo : videoListVo) {
                    if (!ObjectUtil.isNotNull((Object)operationFileVo.getSystemWide()) || !permissions.contains(operationFileVo.getSystemWide().toString())) continue;
                    videoList.add(operationFileVo);
                }
                for (OperationFileVo operationFileVo : fileListVo) {
                    if (!ObjectUtil.isNotNull((Object)operationFileVo.getSystemWide()) || !permissions.contains(operationFileVo.getSystemWide().toString())) continue;
                    fileList.add(operationFileVo);
                }
            } else {
                videoList.addAll(videoListVo);
                fileList.addAll(fileListVo);
            }
            sysOperationFileVo.setVideoList(videoList);
            sysOperationFileVo.setFileList(fileList);
            return sysOperationFileVo;
        }
        return ObjectUtil.isNull((Object)sysOperationFileVoLast) ? sysOperationFileVoNull : sysOperationFileVoLast;
    }

    @Override
    public SysOperationFileVo getFilesByPageLogoType(SysOperationFileModel model) {
        SysOperationFileVo sysOperationFileVo = new SysOperationFileVo();
        Long id = model.getId();
        Integer fileIdsType = model.getFileIdsType();
        String pageLogotype = model.getPageLogotype();
        if (ObjectUtil.isNull((Object)fileIdsType)) {
            return sysOperationFileVo;
        }
        if (fileIdsType == 1) {
            List<OperationFileVo> fileVos = this.operationFileSlicingMapper.getOperationSlicingBySysOperationId(id);
            for (OperationFileVo fileModel : fileVos) {
                fileModel.setDestPath(fileModel.getOssUrl());
                fileModel.setFullOssurl(this.ossClientBean.getUrl(fileModel.getOssUrl()));
                if (fileIdsType == 1) {
                    if (StringUtils.isNotEmpty((String)pageLogotype)) {
                        if (pageLogotype.equals("smarthse.51vip.biz")) {
                            fileModel.setPlayPath("http://smarthse.51vip.biz:19903/static/play.html?vodId=" + fileModel.getId());
                        }
                        if (pageLogotype.equals("ohonline.wsjkw.zj.gov.cn")) {
                            fileModel.setPlayPath("https://ohonline.wsjkw.zj.gov.cn:8184/static/play.html?vodId=" + fileModel.getId());
                        }
                    } else {
                        fileModel.setPlayPath("https://ohonline.wsjkw.zj.gov.cn:8184/static/play.html?vodId=" + fileModel.getId());
                    }
                }
                fileModel.setOssUrl(fileModel.getFullOssurl());
            }
            sysOperationFileVo.setVideoList(fileVos);
        } else if (fileIdsType == 2) {
            List<OperationFileVo> fileList = this.operationFileSlicingMapper.getFileListBySysOperationId(id, 2);
            for (OperationFileVo fileModel : fileList) {
                fileModel.setFullOssurl(this.ossClientBean.getUrl(fileModel.getOssUrl()));
            }
            sysOperationFileVo.setFileList(fileList);
        }
        return sysOperationFileVo;
    }

    private SysOperationFile getSysOperationFile(SysOperationFileModel model) {
        if (ObjectUtil.isNull((Object)model.getId())) {
            throw new ServiceException("\u672a\u6307\u5b9a\u8def\u5f84");
        }
        if (ObjectUtil.isNull((Object)model.getFileIdsType()) || CollectionUtils.isEmpty((Collection)model.getFileIds())) {
            throw new ServiceException("\u6ca1\u6709\u6587\u4ef6\u6216\u8005\u672a\u6307\u5b9a\u6587\u4ef6\u7c7b\u578b");
        }
        SysOperationFile byId = (SysOperationFile)this.getById(model.getId());
        if (ObjectUtil.isNull((Object)byId) || byId.getIsValid().equals(false)) {
            throw new ServiceException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u8def\u5f84");
        }
        return byId;
    }
}

