/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.modules.datacentre.dao.system.SysFileMapper;
import cn.smarthse.modules.datacentre.entity.system.SysFile;
import cn.smarthse.modules.datacentre.enums.sysfile.SysFileConvertEnum;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysFileService;
import cn.smarthse.modules.datacentre.util.StringUtils;
import com.github.pagehelper.PageHelper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class SysFileServiceImpl
extends ZYJBaseServiceImpl<SysFileMapper, SysFile>
implements ISysFileService {
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    @Transactional(readOnly=false)
    public SysFile add(SysFile entity, Long createBy) {
        entity.setCreateBy(createBy);
        entity.setCreateDate(new Date());
        entity.setUpdateBy(createBy);
        entity.setUpdateDate(new Date());
        entity.setIsValid(true);
        ((SysFileMapper)this.dao).insert(entity);
        return entity;
    }

    @Override
    public SysFile getFileByUserId(Long loginUserId, String filehash) {
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("createBy", (Object)loginUserId).andEqualTo("fileHash", (Object)filehash).andEqualTo("isValid", (Object)true);
        return (SysFile)this.getOneByExample(example);
    }

    @Override
    public String getFileUrlByfid(Long fileId) {
        SysFile file = this.getById(fileId);
        if (file != null) {
            return this.ossClientBean.getUrl(file.getOssUrl());
        }
        return null;
    }

    @Override
    public SysFile getFileByHash(String filehash) {
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("fileHash", (Object)filehash).andEqualTo("isValid", (Object)true);
        example.orderBy("createDate").desc();
        List sysFiles = ((SysFileMapper)this.dao).selectByExample(example);
        return CollectionUtils.isEmpty((Collection)sysFiles) ? null : (SysFile)sysFiles.get(0);
    }

    @Override
    public SysFile getFileByHash(String uploadId, String fileHash) {
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("uploadId", (Object)uploadId).andEqualTo("fileHash", (Object)fileHash).andEqualTo("isValid", (Object)true);
        example.orderBy("createDate").desc();
        List sysFiles = ((SysFileMapper)this.dao).selectByExample(example);
        return CollectionUtils.isEmpty((Collection)sysFiles) ? null : (SysFile)sysFiles.get(0);
    }

    @Override
    public SysFile getFileByCid(Long cid, String filehash) {
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("fileHash", (Object)filehash).andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(listByExample)) {
            return (SysFile)listByExample.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(readOnly=false)
    public SysFile addFile(Long cid, String fileName, File file, String ossUrl) {
        SysFile sysFile;
        TransactionStatus status = null;
        if (this.transactionManager != null) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            status = this.transactionManager.getTransaction((TransactionDefinition)def);
        }
        try {
            SysFile sysfile = new SysFile();
            sysfile.setCid(cid);
            sysfile.setCreateDate(new Date());
            sysfile.setFileExt(FilenameUtils.getExtension((String)file.getName()));
            sysfile.setFileName(fileName);
            sysfile.setFileSize(String.valueOf(file.length()));
            sysfile.setIsValid(true);
            sysfile.setOssUrl(ossUrl);
            sysfile.setUpdateDate(new Date());
            this.add(sysfile);
            sysFile = sysfile;
            if (status == null) return sysFile;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (status != null) {
                    this.transactionManager.rollback(status);
                }
                if (status == null) return null;
            }
            catch (Throwable throwable) {
                if (status == null) throw throwable;
                this.transactionManager.commit(status);
                throw throwable;
            }
            this.transactionManager.commit(status);
            return null;
        }
        this.transactionManager.commit(status);
        return sysFile;
    }

    @Override
    public Long sumSpaceByCid(Long cid) {
        return ((SysFileMapper)this.dao).selectSumSpaceByCid(cid);
    }

    @Override
    public SysFile getById(Long id) {
        SysFile file = (SysFile)super.getById(id);
        if (file != null && StringUtils.isNotEmpty(file.getOssUrl())) {
            file.setFullPath(this.ossClientBean.getUrl(file.getOssUrl()));
        }
        return file;
    }

    @Override
    public List<SysFile> getListByIds(String ids) {
        List<Long> idList = StringUtils.parseToLongList(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Example example = new Example(SysFile.class);
        example.createCriteria().andIn("id", idList);
        List<SysFile> files = super.getListByExample(example);
        if (files != null && !files.isEmpty()) {
            for (SysFile file : files) {
                file.setFullPath(this.ossClientBean.getUrl(file.getOssUrl()));
            }
        }
        return files;
    }

    @Override
    public SysFile getFileByUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        Example e = new Example(SysFile.class);
        e.createCriteria().andEqualTo("ossUrl", (Object)url).andEqualTo("isValid", (Object)true);
        return (SysFile)this.getOneByExample(e);
    }

    @Override
    public List<SysFile> listFileByArea(Long areaId, Byte areaLevel) {
        return ((SysFileMapper)this.dao).listFileByArea(areaId, areaLevel);
    }

    @Override
    public List<SysFile> getNeedConvertFile(int pageSize) {
        PageHelper.startPage((int)1, (int)pageSize, (boolean)false);
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("convertFlag", (Object)SysFileConvertEnum.NEED.getCode());
        example.selectProperties(new String[]{"id", "outOssUrl"});
        List sysFiles = ((SysFileMapper)this.dao).selectByExample(example);
        return sysFiles;
    }

    @Override
    @Transactional(readOnly=false)
    public void updateConvertState(List<SysFile> fileList) {
        if (CollectionUtils.isNotEmpty(fileList)) {
            ListUtil.partition(fileList, (int)1000).forEach(list -> ((SysFileMapper)this.dao).updateConvertState((List<SysFile>)list));
        }
    }

    @Override
    public List<SysFile> pageFileByRecycle(Integer recycleFlag, int pageSize) {
        if (recycleFlag == null) {
            return Collections.emptyList();
        }
        PageHelper.startPage((int)1, (int)pageSize, (boolean)false);
        Example example = new Example(SysFile.class);
        example.createCriteria().andEqualTo("recycleFlag", (Object)recycleFlag);
        example.selectProperties(new String[]{"id", "ossUrl"});
        List sysFiles = ((SysFileMapper)this.dao).selectByExample(example);
        return sysFiles;
    }

    @Override
    @Transactional(readOnly=false)
    public void updateRecycleFlag(Integer recycleFlag, List<Long> fileIds) {
        if (CollectionUtils.isEmpty(fileIds)) {
            return;
        }
        Example example = new Example(SysFile.class);
        Example.Criteria criteria = example.createCriteria().andIn("id", fileIds);
        if (Objects.equals(recycleFlag, 3)) {
            criteria.andEqualTo("fileExt", (Object)"doc");
        }
        SysFile result = new SysFile();
        result.setRecycleFlag(recycleFlag);
        result.setUpdateDate(new Date());
        result.setUpdateBy(7780L);
        ((SysFileMapper)this.dao).updateByExampleSelective(result, example);
    }
}

