/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import cn.smarthse.modules.datacentre.dao.system.SysAreaMapper;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.platform.core.framework.cache.ehcache.EhCacheUtils;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3ListVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3Param;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class SysAreaServiceImpl
extends ZYJBaseServiceImpl<SysAreaMapper, SysArea>
implements ISysAreaService {
    @Autowired
    private CacheProperties cacheProperties;

    @Override
    public PageInfo<SysArea> getAllProvince(JqGridParam param) {
        if (param != null) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        }
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)"0").andEqualTo("isValid", (Object)true);
        example.orderBy("id");
        PageInfo page = new PageInfo(((SysAreaMapper)this.dao).selectByExample(example));
        return page;
    }

    @Override
    public List<SysArea> getCityList(Long provinceId) {
        return this.getCityList(provinceId, "");
    }

    @Override
    public List<SysArea> getAreaList(Long cityId) {
        return this.getAreaList(cityId, "");
    }

    @Override
    public List<SysArea> getStreetList(Long areaId) {
        return this.getStreetList(areaId, "");
    }

    @Override
    public PageInfo<SysArea> getChildList(JqGridParam param, Long pid) {
        if (param != null) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        }
        List<SysArea> list = this.getChildByPid(pid);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Override
    public List<AreaModel> getAreaListByIds(String areaIds) {
        if (StringUtils.isEmpty((CharSequence)areaIds)) {
            return Collections.emptyList();
        }
        Example e = new Example(SysArea.class);
        List<String> list = Arrays.asList(areaIds.split(","));
        e.createCriteria().andEqualTo("isValid", (Object)1).andIn("id", list);
        List<SysArea> areaList = this.selectByExample(e);
        ArrayList<AreaModel> result = new ArrayList<AreaModel>();
        areaList.stream().forEach(record -> {
            AreaModel areaModel = new AreaModel();
            if (record != null) {
                BeanUtils.copyProperties((Object)record, (Object)areaModel);
            }
            result.add(areaModel);
        });
        return result;
    }

    @Override
    public List<SysArea> getAllProvinceList() {
        return this.getAllProvinceList("");
    }

    @Override
    public List<SysArea> getAllProvinceList(String areaIds) {
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("parentId", (Object)"0").andEqualTo("isValid", (Object)true);
        this.addCondition2Criteria(1, 0L, areaIds, criteria);
        example.orderBy("id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getCityList(Long provinceId, String areaIds) {
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("parentId", (Object)provinceId).andEqualTo("isValid", (Object)true);
        this.addCondition2Criteria(2, provinceId, areaIds, criteria);
        example.orderBy("id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getProvCityAreaList(SuperviseAreaModel areaModel) {
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true).andIn("level", Arrays.asList(1, 2, 3));
        if (areaModel != null) {
            // empty if block
        }
        example.orderBy("id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getAreaList(Long cityId, String areaIds) {
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("parentId", (Object)cityId).andEqualTo("isValid", (Object)true);
        this.addCondition2Criteria(3, cityId, areaIds, criteria);
        example.orderBy("id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getStreetList(Long areaId, String areaIds) {
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("parentId", (Object)areaId).andEqualTo("isValid", (Object)true);
        this.addCondition2Criteria(4, areaId, areaIds, criteria);
        example.orderBy(" id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    private void addCondition2Criteria(int level, Long areaId, String areaIds, Example.Criteria criteria) {
        if (StringUtils.isBlank((CharSequence)areaIds)) {
            return;
        }
        List listByIds = this.getListByIds(areaIds);
        if (CollectionUtils.isNotEmpty(listByIds)) {
            StringBuffer sql = new StringBuffer("");
            HashSet<Long> provIdSet = new HashSet<Long>();
            HashSet<Long> cityIdSet = new HashSet<Long>();
            HashSet<Long> areaIdSet = new HashSet<Long>();
            HashSet<Long> streIdSet = new HashSet<Long>();
            for (SysArea sysArea : listByIds) {
                if (sysArea.getProvinceId() != null) {
                    provIdSet.add(sysArea.getProvinceId());
                }
                if (sysArea.getCityId() != null) {
                    cityIdSet.add(sysArea.getCityId());
                }
                if (sysArea.getAreaId() != null) {
                    areaIdSet.add(sysArea.getAreaId());
                }
                if (sysArea.getStreetId() == null) continue;
                streIdSet.add(sysArea.getStreetId());
            }
            if (level == 1) {
                for (Long aLong : provIdSet) {
                    sql.append(" or province_id=").append(aLong);
                }
            } else if (level == 2 && provIdSet.contains(areaId)) {
                for (Long aLong : cityIdSet) {
                    if (!this.containAuthArea(aLong, areaId)) continue;
                    sql.append(" or city_id=").append(aLong);
                }
            } else if (level == 3 && cityIdSet.contains(areaId)) {
                for (Long aLong : areaIdSet) {
                    if (!this.containAuthArea(aLong, areaId)) continue;
                    sql.append(" or area_id=").append(aLong);
                }
            } else if (level == 4 && areaIdSet.contains(areaId)) {
                for (Long aLong : streIdSet) {
                    if (!this.containAuthArea(aLong, areaId)) continue;
                    sql.append(" or street_id=").append(aLong);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
                sql.delete(0, 3);
                criteria.andCondition("(" + sql.toString() + ")");
            }
        }
    }

    public boolean containAuthAreaList(Long areaId, Set<Long> orgAreaIds) {
        if (CollectionUtils.isEmpty(orgAreaIds) || areaId == null) {
            return false;
        }
        for (Long orgAreaId : orgAreaIds) {
            boolean b = this.containAuthArea(areaId, orgAreaId);
            if (!b) continue;
            return true;
        }
        return false;
    }

    public boolean containAuthArea(Long areaId, Long orgAreaId) {
        if (orgAreaId == null || areaId == null) {
            return false;
        }
        if (Objects.equals(orgAreaId, 0L)) {
            return true;
        }
        String areaIdStr = areaId.toString();
        String orgAreaIdStr = orgAreaId.toString();
        areaIdStr = areaIdStr.replaceAll("(0+)$", "");
        orgAreaIdStr = orgAreaIdStr.replaceAll("(0+)$", "");
        return areaIdStr.startsWith(orgAreaIdStr);
    }

    @Override
    public List<SysArea> getChildByPid(Long pid) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)pid).andEqualTo("isValid", (Object)true);
        example.orderBy("id");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    @Transactional
    public void deleteByIds(List<Long> ids) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        cri.andEqualTo("isValid", (Object)true).andIn("id", ids);
        SysArea record = new SysArea();
        record.setIsValid(false);
        ((SysAreaMapper)this.dao).updateByExampleSelective(record, example);
    }

    @Override
    public SysArea getAreaById(Long id) {
        if (id == null) {
            return null;
        }
        String cacheName = String.valueOf(id);
        Object cacheObj = null;
        try {
            cacheObj = EhCacheUtils.get(this.cacheProperties.getSysareaCache(), cacheName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cacheObj != null) {
            return (SysArea)cacheObj;
        }
        SysArea area = (SysArea)((SysAreaMapper)this.dao).selectByPrimaryKey(id);
        if (area != null) {
            EhCacheUtils.put(this.cacheProperties.getSysareaCache(), cacheName, area);
        }
        return area;
    }

    @Override
    public void clearAreaCacheById(Long id) {
        String cacheName = String.valueOf(id);
        EhCacheUtils.remove(this.cacheProperties.getSysareaCache(), cacheName);
    }

    @Override
    public int getCountChildByPid(Long pid) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)pid).andEqualTo("isValid", (Object)true);
        return ((SysAreaMapper)this.dao).selectCountByExample(example);
    }

    @Override
    public Map<Long, Map<String, Long>> getCountChildByPids(List<Long> pids) {
        return ((SysAreaMapper)this.dao).getCountChildByPids(pids);
    }

    @Override
    @Transactional(readOnly=false)
    public SysArea add(SysArea sysArea, Long adminId) {
        if (sysArea.getParentId() != 0L) {
            SysArea psysArea = (SysArea)this.getById(sysArea.getParentId());
            sysArea.setProvinceId(psysArea.getProvinceId());
            sysArea.setProvinceName(psysArea.getProvinceName());
            sysArea.setCityId(psysArea.getCityId());
            sysArea.setCityName(psysArea.getCityName());
            sysArea.setAreaId(psysArea.getAreaId());
            sysArea.setAreaName(psysArea.getAreaName());
            sysArea.setStreetId(psysArea.getStreetId());
            sysArea.setStreetName(psysArea.getStreetName());
        }
        sysArea.setCreateBy(adminId);
        sysArea.setCreateDate(new Date());
        sysArea.setUpdateBy(adminId);
        sysArea.setUpdateDate(new Date());
        sysArea.setIsValid(true);
        sysArea = this.add(sysArea);
        if (sysArea.getLevel() == 1) {
            sysArea.setProvinceId(sysArea.getId());
            sysArea.setProvinceName(sysArea.getName());
        } else if (sysArea.getLevel() == 2) {
            sysArea.setCityId(sysArea.getId());
            sysArea.setCityName(sysArea.getName());
        } else if (sysArea.getLevel() == 3) {
            sysArea.setAreaId(sysArea.getId());
            sysArea.setAreaName(sysArea.getName());
        } else if (sysArea.getLevel() == 4) {
            sysArea.setStreetId(sysArea.getId());
            sysArea.setStreetName(sysArea.getName());
        }
        this.update(sysArea);
        return sysArea;
    }

    @Override
    @Transactional(readOnly=false)
    public void del(SysArea sysArea, Long adminId) {
        this.delete(sysArea, adminId);
        Example example = new Example(SysArea.class);
        Example.Criteria c = example.createCriteria();
        if (sysArea.getLevel() == 1) {
            c.andEqualTo("isValid", (Object)true).andEqualTo("provinceId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(false);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        } else if (sysArea.getLevel() == 2) {
            c.andEqualTo("isValid", (Object)true).andEqualTo("cityId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(false);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        } else if (sysArea.getLevel() == 3) {
            c.andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(false);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        }
    }

    @Override
    public String getAreaDetailNameById(Long id) {
        SysArea area = this.getAreaById(id);
        if (area != null) {
            return area.getAreaDetailName();
        }
        return null;
    }

    @Override
    public String getNameById(Long Id2) {
        SysArea area = this.getAreaById(Id2);
        if (area != null) {
            return area.getName();
        }
        return null;
    }

    @Override
    public Integer getChildCount(Long id) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)id).andEqualTo("isValid", (Object)true);
        return this.getCountByExample(example);
    }

    @Override
    public List<SysArea> getChildByPrefix(String prefix) {
        Example example = new Example(SysArea.class);
        if (prefix.equals("0")) {
            example.createCriteria().andEqualTo("isValid", (Object)true);
        } else {
            example.createCriteria().andLike("id", prefix + "%").andEqualTo("isValid", (Object)true);
        }
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getChildByParentId(Long parentId, String name) {
        if (parentId == null) {
            parentId = 0L;
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            parentId = null;
        }
        SysArea area = new SysArea();
        area.setIsValid(true);
        area.setParentId(parentId);
        area.setName(name);
        return ((SysAreaMapper)this.dao).listArea(area);
    }

    @Override
    public List<SysArea> getProvinceAllById(Long provinceId) {
        if (provinceId == null) {
            return Collections.emptyList();
        }
        SysArea area = new SysArea();
        area.setIsValid(true);
        area.setProvinceId(provinceId);
        return ((SysAreaMapper)this.dao).listProvinceArea(area);
    }

    @Override
    public List<SysArea> listAllArea(SuperviseAreaModel area) {
        return ((SysAreaMapper)this.dao).listAllArea(area);
    }

    @Override
    public List<SysArea> listAllAreaExcludeDeleteOrHide(SuperviseAreaModel area) {
        return ((SysAreaMapper)this.dao).listAllAreaExcludeDeleteOrHide(area);
    }

    @Override
    public List<SysArea> selectByExample(Example example) {
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public int updateByExampleSelective(SysArea result, Example example) {
        return ((SysAreaMapper)this.dao).updateByExampleSelective(result, example);
    }

    @Override
    public SysArea getLastArea(Long id) {
        SysArea area = (SysArea)this.getById(id);
        if (area == null) {
            return null;
        }
        List<SysArea> list = this.getChildByPid(area.getParentId());
        if (list == null || list.isEmpty()) {
            return null;
        }
        list = list.stream().sorted(Comparator.comparing(SysArea::getSort).reversed()).collect(Collectors.toList());
        for (SysArea sysArea : list) {
            if (sysArea.getSort() >= area.getSort()) continue;
            return sysArea;
        }
        return null;
    }

    @Override
    public SysArea getNextArea(Long id) {
        SysArea area = (SysArea)this.getById(id);
        if (area == null) {
            return null;
        }
        List<SysArea> list = this.getChildByPid(area.getParentId());
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (SysArea sysArea : list) {
            if (sysArea.getSort() <= area.getSort()) continue;
            return sysArea;
        }
        return null;
    }

    @Override
    public List<SysArea> getAreaListData(String keyword) {
        SysArea sysArea = new SysArea();
        sysArea.setName(keyword);
        List<SysArea> list = ((SysAreaMapper)this.dao).listArea(sysArea);
        return list;
    }

    @Override
    public List<SysArea> getAreaListData(SysArea param) {
        if (param == null) {
            return Collections.emptyList();
        }
        return ((SysAreaMapper)this.dao).select(param);
    }

    @Override
    public String getNewAreaId(Long pid) {
        SysArea area = this.getAreaById(pid);
        return ((SysAreaMapper)this.dao).getNewAreaId(pid, area.getLevel());
    }

    @Override
    public Long getIdByAddress(String address) {
        return ((SysAreaMapper)this.dao).getIdByAddress(address);
    }

    @Override
    public List<SysArea> getAreaListDataGtLevel(String keyword, Byte level, AreaModel areaModel) {
        SysArea sysArea = new SysArea();
        sysArea.setName(keyword);
        sysArea.setLevel(level);
        List<SysArea> list = ((SysAreaMapper)this.dao).getAreaListDataGtLevel(sysArea, areaModel);
        return list;
    }

    @Override
    public String resetAreaSortByPid(Long pid) {
        return ((SysAreaMapper)this.dao).resetAreaSortByPid(pid);
    }

    @Override
    public String getNewSort(Long pid) {
        return ((SysAreaMapper)this.dao).getNewSort(pid);
    }

    @Override
    public List<SysArea> getAllAreaIdByParentAndLevel(Long areaId, Integer level) {
        return ((SysAreaMapper)this.dao).getAllAreaIdByParentAndLevel(areaId, level);
    }

    @Override
    public String getFullAreaName(Long areaId, String connector) {
        if (areaId == null) {
            return null;
        }
        SysArea sysArea = (SysArea)this.getById(areaId);
        if (sysArea == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (sysArea.getLevel() >= 1) {
            result.append(sysArea.getProvinceName());
        }
        if (sysArea.getLevel() >= 2) {
            result.append(connector).append(sysArea.getCityName());
        }
        if (sysArea.getLevel() >= 3) {
            result.append(connector).append(sysArea.getAreaName());
        }
        if (sysArea.getLevel() >= 4) {
            result.append(connector).append(sysArea.getStreetName());
        }
        return result.toString();
    }

    @Override
    public String getFullName(Long areaId, String separation) {
        if (areaId == null) {
            return "";
        }
        SysArea area = (SysArea)this.getById(areaId);
        if (area != null) {
            StringBuffer areaName = new StringBuffer();
            areaName.append(area.getProvinceName());
            if (StringUtils.isNotBlank((CharSequence)area.getCityName())) {
                areaName.append(separation + area.getCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
                areaName.append(separation + area.getAreaName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getStreetName())) {
                areaName.append(separation + area.getStreetName());
            }
            return areaName.toString();
        }
        return "";
    }

    @Override
    public List<SysAreaV3ListVo> getAllAreaV3() {
        return ((SysAreaMapper)this.dao).getAllAreaV3(null);
    }

    @Override
    public List<SysAreaV3ListVo> getNextLevelAreaListByParentIdV3(SysAreaV3Param param) {
        if (param.getId() == null) {
            param.setId(Long.valueOf(0L));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getName())) {
            param.setId(null);
        }
        return ((SysAreaMapper)this.dao).getAllAreaV3(param);
    }

    @Override
    public SysAreaV3OneVo getAreaByIdV3(Long id) {
        if (id == null) {
            return null;
        }
        return ((SysAreaMapper)this.dao).getAreaByIdV3(id);
    }

    @Override
    public List<SysArea> getAreaListByParentId(Long parentId, Boolean isCity, Boolean isCountry) {
        return ((SysAreaMapper)this.dao).getAreaListByParentId(parentId, isCity, isCountry);
    }
}

