/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.modules.datacentre.dao.system.OperationFileSlicingMapper;
import cn.smarthse.modules.datacentre.entity.system.OperationFileSlicing;
import cn.smarthse.modules.datacentre.model.system.OperationFileVo;
import cn.smarthse.modules.datacentre.model.system.SysOperationFileModel;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.IOperationFileSlicingService;
import cn.smarthse.util.common.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperationFileSlicingServiceImpl
extends ZYJBaseServiceImpl<OperationFileSlicingMapper, OperationFileSlicing>
implements IOperationFileSlicingService {
    @Autowired
    OssClientBean ossClientBean;

    @Override
    @Transactional(readOnly=false)
    public Boolean updateSlicingStatus(Long id, Integer videoSlicingStatus, Long videoSlicingFileId, Long userId, Date updateDate) {
        OperationFileSlicing entity = new OperationFileSlicing();
        entity.setId(id);
        entity.setVideoSlicingStatus(videoSlicingStatus);
        entity.setUpdateBy(userId);
        entity.setUpdateDate(updateDate);
        if (Objects.nonNull(videoSlicingFileId)) {
            entity.setVideoSlicingFileId(videoSlicingFileId);
        }
        return ((OperationFileSlicingMapper)this.dao).updateByPrimaryKeySelective(entity) > 0;
    }

    @Override
    public Boolean decideOperationFileId(Long id) {
        if (ObjectUtil.isNull((Object)id)) {
            return false;
        }
        Integer count = ((OperationFileSlicingMapper)this.dao).decideOperationFileId(id);
        if (ObjectUtil.isNotNull((Object)count)) {
            return count > 0;
        }
        return false;
    }

    @Override
    public List<OperationFileVo> getFilesByPageName(SysOperationFileModel model) {
        ArrayList<OperationFileVo> fileVos = new ArrayList<OperationFileVo>();
        Integer fileIdsType = model.getFileIdsType();
        String remarks = model.getRemarks();
        String pageLogotype = model.getPageLogotype();
        if (StringUtils.isEmpty((CharSequence)remarks)) {
            return fileVos;
        }
        if (ObjectUtil.isNotNull((Object)fileIdsType)) {
            fileVos.addAll(((OperationFileSlicingMapper)this.dao).getFilesByPageName(model));
        } else {
            model.setFileIdsType(Integer.valueOf(1));
            fileVos.addAll(((OperationFileSlicingMapper)this.dao).getFilesByPageName(model));
            model.setFileIdsType(Integer.valueOf(2));
            fileVos.addAll(((OperationFileSlicingMapper)this.dao).getFilesByPageName(model));
        }
        for (OperationFileVo fileModel : fileVos) {
            fileModel.setDestPath(fileModel.getOssUrl());
            fileModel.setFullOssurl(this.ossClientBean.getUrl(fileModel.getOssUrl()));
            if (fileModel.getFileIdsType() == 1) {
                if ("smarthse.51vip.biz".equals(pageLogotype)) {
                    fileModel.setPlayPath("http://smarthse.51vip.biz:19903/static/play.html?vodId=" + fileModel.getId());
                } else {
                    fileModel.setPlayPath("https://ohonline.wsjkw.zj.gov.cn:8184/static/play.html?vodId=" + fileModel.getId());
                }
            }
            fileModel.setOssUrl(fileModel.getFullOssurl());
        }
        return fileVos;
    }
}

