/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.smarthse.modules.datacentre.dao.system.IndustryMapper;
import cn.smarthse.modules.datacentre.entity.system.Industry;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.IIndustryService;
import cn.smarthse.util.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class IndustryServiceImpl
extends ZYJBaseServiceImpl<IndustryMapper, Industry>
implements IIndustryService {
    @Override
    public List<IndustryModel> getIndustryList(IndustryModel industryModel) {
        Example e = new Example(Industry.class);
        e.setOrderByClause("sort asc");
        Example.Criteria criteria = e.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        if (industryModel != null) {
            if (industryModel.getId() != null) {
                criteria.andEqualTo("id", (Object)industryModel.getId());
            }
            if (industryModel.getPid() != null) {
                criteria.andEqualTo("pid", (Object)industryModel.getPid());
            }
            if (industryModel.getPcode() != null) {
                criteria.andEqualTo("pcode", (Object)industryModel.getPcode());
            }
            if (industryModel.getName() != null) {
                criteria.andLike("name", industryModel.getName());
            }
            if (industryModel.getCode() != null) {
                criteria.andEqualTo("code", (Object)industryModel.getCode());
            }
            if (industryModel.getSubCode() != null) {
                criteria.andEqualTo("subCode", (Object)industryModel.getSubCode());
            }
        }
        List list = ((IndustryMapper)this.dao).selectByExample(e);
        ArrayList<IndustryModel> result = new ArrayList<IndustryModel>();
        list.forEach(record -> {
            IndustryModel model = new IndustryModel();
            BeanUtils.copyProperties((Object)record, (Object)model);
            result.add(model);
        });
        return result;
    }

    @Override
    public List<IndustryModel> getIndustryList4(String keyword) {
        List list;
        Example e = new Example(Industry.class);
        e.setOrderByClause("sort asc");
        e.selectProperties(new String[]{"id", "code", "name"});
        Example.Criteria criteria = e.createCriteria();
        criteria.andEqualTo("level", (Object)4);
        criteria.andEqualTo("isValid", (Object)true);
        if (keyword != null) {
            e.and(e.createCriteria().orLike("name", String.format("%s%s%s", "%", keyword, "%")).orLike("code", String.format("%s%s%s", "%", keyword, "%")));
        }
        if (CollectionUtils.isNotEmpty(list = this.getListByExample(e))) {
            List<IndustryModel> modelList = list.stream().map(record -> {
                IndustryModel model = new IndustryModel();
                BeanUtils.copyProperties((Object)record, (Object)model);
                return model;
            }).collect(Collectors.toList());
            return modelList;
        }
        return null;
    }

    @Override
    public List<IndustryModel> getIndustryChildList(Long parentId, String keyword) {
        Industry parentIndu;
        Example e = new Example(Industry.class);
        e.setOrderByClause("sort asc");
        Example.Criteria criteria = e.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        if (parentId != null && (parentIndu = (Industry)this.getById(parentId)) != null) {
            String code = parentIndu.getCode();
            criteria.andLike("code", code + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            criteria.andLike("name", "%" + keyword + "%");
        }
        List list = ((IndustryMapper)this.dao).selectByExample(e);
        List<IndustryModel> modelList = list.stream().map(record -> {
            IndustryModel model = new IndustryModel();
            BeanUtils.copyProperties((Object)record, (Object)model);
            return model;
        }).collect(Collectors.toList());
        return modelList;
    }

    @Override
    public List<IndustryModel> getIndustryList(String keyword, String code) {
        List<IndustryModel> list = ((IndustryMapper)this.dao).selectIndustryList(keyword, code);
        return list;
    }

    @Override
    public List<IndustryModel> getIndustryModelByIds(String ids) {
        List industryList = ((IndustryMapper)this.dao).selectByIds(ids);
        ArrayList<IndustryModel> industryModelList = new ArrayList<IndustryModel>();
        if (CollectionUtils.isNotEmpty((Collection)industryList)) {
            for (Industry industry : industryList) {
                IndustryModel model = new IndustryModel();
                BeanUtils.copyProperties((Object)industry, (Object)model);
                industryModelList.add(model);
            }
        }
        return industryModelList;
    }

    @Override
    public IndustryModel getIndustryModelByName(String induName) {
        List industries;
        Example e = new Example(Industry.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)induName)) {
            criteria.andEqualTo("name", (Object)induName);
        }
        if (CollectionUtils.isNotEmpty((Collection)(industries = ((IndustryMapper)this.dao).selectByExample(e))) && industries.size() > 0) {
            IndustryModel rst = new IndustryModel();
            BeanUtils.copyProperties(industries.get(0), (Object)rst);
            return rst;
        }
        return null;
    }

    @Override
    public List<IndustryModel> getIndustryListByPid(Long parentId) {
        IndustryModel industryModel = new IndustryModel();
        industryModel.setPid(parentId);
        List<IndustryModel> list = this.getIndustryList(industryModel);
        return list;
    }

    @Override
    public List<IndustryModel> getIndustryListByPcode(String pcode) {
        IndustryModel industryModel = new IndustryModel();
        industryModel.setPcode(pcode);
        List<IndustryModel> list = this.getIndustryList(industryModel);
        return list;
    }

    @Override
    public IndustryModel getIndustryByCode(String code) {
        IndustryModel industryModel = new IndustryModel();
        industryModel.setCode(code);
        List<IndustryModel> list = this.getIndustryList(industryModel);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Override
    public IndustryModel getIndustryBySubCode(String code) {
        IndustryModel industryModel = new IndustryModel();
        industryModel.setSubCode(code);
        List<IndustryModel> list = this.getIndustryList(industryModel);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Override
    public IndustryModel getParentIndustry(String code) {
        IndustryModel industryModel = new IndustryModel();
        industryModel.setCode(code);
        List<IndustryModel> list = this.getIndustryList(industryModel);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Override
    public IndustryModel getLastIndustry(String code) {
        IndustryModel industryModel = this.getIndustryBySubCode(code);
        if (industryModel == null) {
            return null;
        }
        List<Object> list = this.getIndustryListByPcode(industryModel.getPcode());
        if (list == null || list.isEmpty()) {
            return null;
        }
        list = list.stream().sorted(Comparator.comparing(IndustryModel::getSort).reversed()).collect(Collectors.toList());
        for (IndustryModel industryModel2 : list) {
            if (industryModel2.getSort() >= industryModel.getSort()) continue;
            return industryModel2;
        }
        return null;
    }

    @Override
    public IndustryModel getNextIndustry(String code) {
        IndustryModel industryModel = this.getIndustryBySubCode(code);
        if (industryModel == null) {
            return null;
        }
        List<Object> list = this.getIndustryListByPcode(industryModel.getPcode());
        if (list == null || list.isEmpty()) {
            return null;
        }
        list = list.stream().sorted(Comparator.comparing(IndustryModel::getSort)).collect(Collectors.toList());
        for (IndustryModel industryModel2 : list) {
            if (industryModel2.getSort() <= industryModel.getSort()) continue;
            return industryModel2;
        }
        return null;
    }

    @Override
    public void sortIndustry(String code, Integer upOrDwon, Long adminId) {
        if (code == null) {
            throw new ServiceException("\u884c\u4e1a\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (upOrDwon == null) {
            throw new ServiceException("\u4e0a\u4e0b\u79fb\u52a8\u6807\u5fd7\u4f4d\u4e3a\u7a7a\uff01");
        }
        IndustryModel industryModel = this.getIndustryBySubCode(code);
        if (industryModel == null) {
            throw new ServiceException("\u6ca1\u6709\u8be5\u7f16\u7801\u7684\u884c\u4e1a\uff01");
        }
        IndustryModel lastIndustryModel = null;
        lastIndustryModel = upOrDwon <= 0 ? this.getLastIndustry(code) : this.getNextIndustry(code);
        if (lastIndustryModel == null) {
            return;
        }
        Long lastSort = lastIndustryModel.getSort();
        Long sort = industryModel.getSort();
        Industry lastIndustry = new Industry();
        lastIndustry.setId(lastIndustryModel.getId());
        lastIndustry.setSort(sort);
        lastIndustry.setUpdateBy(adminId);
        lastIndustry.setUpdateDate(new Date());
        this.update(lastIndustry);
        Industry industry = new Industry();
        industry.setId(industryModel.getId());
        industry.setSort(lastSort);
        industry.setUpdateBy(adminId);
        industry.setUpdateDate(new Date());
        this.update(industry);
    }

    @Override
    public boolean hasIndustryCode(String code) {
        IndustryModel record = this.getIndustryBySubCode(code);
        return record != null;
    }

    @Override
    @Transactional(readOnly=false)
    public void addIndustry(IndustryModel paramModel, Long adminId) {
        if (paramModel.getCode() == null) {
            throw new ServiceException("\u884c\u4e1a\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (paramModel.getName() == null) {
            throw new ServiceException("\u884c\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (this.hasIndustryCode(paramModel.getCode())) {
            throw new ServiceException("\u8be5\u884c\u4e1a\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (paramModel.getPid() != null && paramModel.getPid() == 0L && StringUtils.isEmpty((CharSequence)paramModel.getPcode())) {
            paramModel.setPid(Long.valueOf(2478L));
        }
        Industry parentIndustry = null;
        if (paramModel.getPid() != null) {
            parentIndustry = (Industry)this.getById(paramModel.getPid());
        } else if (!StringUtils.isEmpty((CharSequence)paramModel.getCode())) {
            parentIndustry = this.getByCode(paramModel.getPcode());
        }
        if (parentIndustry == null) {
            parentIndustry = (Industry)this.getById(2478L);
        }
        Industry industry = new Industry();
        industry.setCode(paramModel.getCode());
        industry.setName(paramModel.getName());
        industry.setDescription(paramModel.getDescription());
        industry.setPid(parentIndustry.getId());
        industry.setPcode(parentIndustry.getCode());
        Integer level = parentIndustry.getLevel() + 1;
        industry.setLevel(level);
        if (level == 1) {
            industry.setIndustryCode1(paramModel.getCode());
            industry.setIndustryName1(paramModel.getName());
        }
        if (level >= 2) {
            industry.setIndustryCode1(parentIndustry.getIndustryCode1());
            industry.setIndustryName1(parentIndustry.getIndustryName1());
            industry.setIndustryCode2(paramModel.getCode());
            industry.setIndustryName2(paramModel.getName());
        }
        if (level >= 3) {
            industry.setIndustryCode2(parentIndustry.getIndustryCode2());
            industry.setIndustryName2(parentIndustry.getIndustryCode2());
            industry.setIndustryCode3(paramModel.getCode());
            industry.setIndustryName3(paramModel.getName());
        }
        if (level >= 4) {
            industry.setIndustryCode3(parentIndustry.getIndustryCode3());
            industry.setIndustryName3(parentIndustry.getIndustryCode3());
            industry.setIndustryCode4(paramModel.getCode());
            industry.setIndustryName4(paramModel.getName());
        }
        industry.setCreateBy(adminId);
        industry.setCreateDate(new Date());
        Industry addIndustry = this.add(industry, adminId);
        Industry sortIndustry = new Industry();
        sortIndustry.setId(addIndustry.getId());
        sortIndustry.setSort(addIndustry.getId());
        this.update(sortIndustry);
        if (parentIndustry.getIsLeaf() == 1) {
            parentIndustry.setIsLeaf(0);
            this.update(parentIndustry);
        }
    }

    private Industry getByCode(String code) {
        Example e = new Example(Industry.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("code", (Object)code);
        List list = ((IndustryMapper)this.dao).selectByExample(e);
        return list == null || list.isEmpty() ? null : (Industry)list.get(0);
    }

    @Override
    public void saveIndustry(IndustryModel paramModel, Long adminId) {
        if (paramModel == null || paramModel.getId() == null) {
            throw new ServiceException("id\u4e3a\u7a7a\uff01");
        }
        Industry industry = new Industry();
        industry.setId(paramModel.getId());
        industry.setName(paramModel.getName());
        industry.setDescription(paramModel.getDescription());
        industry.setUpdateBy(adminId);
        industry.setUpdateDate(new Date());
        this.update(industry);
        Industry childIndustry = new Industry();
        Industry currentIndustry = (Industry)this.getById(paramModel.getId());
        Example e = new Example(Industry.class);
        Integer level = currentIndustry.getLevel();
        if (level == 1) {
            e.createCriteria().andEqualTo("industryCode1", (Object)currentIndustry.getIndustryCode2());
            childIndustry.setIndustryName1(paramModel.getName());
        } else if (level == 2) {
            e.createCriteria().andEqualTo("industryCode2", (Object)currentIndustry.getIndustryCode2());
            childIndustry.setIndustryName2(paramModel.getName());
        } else if (level == 3) {
            e.createCriteria().andEqualTo("industryCode3", (Object)currentIndustry.getIndustryCode3());
            childIndustry.setIndustryName3(paramModel.getName());
        } else if (level == 4) {
            e.createCriteria().andEqualTo("industryCode4", (Object)currentIndustry.getIndustryCode4());
            childIndustry.setIndustryName4(paramModel.getName());
        }
        ((IndustryMapper)this.dao).updateByExampleSelective(childIndustry, e);
    }

    @Override
    @Transactional(readOnly=false)
    public void delIndustry(Long industryId, Long adminId) {
        if (industryId == null) {
            throw new ServiceException("\u56db\u7ea7\u884c\u4e1aid\u4e3a\u7a7a\uff01");
        }
        Industry currentIndustry = (Industry)this.getById(industryId);
        this.deleteById(industryId, adminId);
        Industry parentIndustry = (Industry)this.getById(currentIndustry.getPid());
        if (parentIndustry != null) {
            this.updateIsLeaf(parentIndustry.getId());
        }
        Industry childIndustry = new Industry();
        childIndustry.setIsValid(false);
        Example e = new Example(Industry.class);
        Integer level = currentIndustry.getLevel();
        if (level == 1) {
            e.createCriteria().andEqualTo("industryCode1", (Object)currentIndustry.getIndustryCode2());
        } else if (level == 2) {
            e.createCriteria().andEqualTo("industryCode2", (Object)currentIndustry.getIndustryCode2());
        } else if (level == 3) {
            e.createCriteria().andEqualTo("industryCode3", (Object)currentIndustry.getIndustryCode3());
        } else if (level == 4) {
            e.createCriteria().andEqualTo("industryCode4", (Object)currentIndustry.getIndustryCode4());
        }
    }

    private void updateIsLeaf(Long industryId) {
        List<IndustryModel> childIndustryList = this.getIndustryListByPid(industryId);
        if (childIndustryList != null && !childIndustryList.isEmpty()) {
            return;
        }
        Industry industry = new Industry();
        industry.setId(industryId);
        industry.setIsLeaf(1);
        this.update(industry);
    }

    @Override
    public void importIndustryList(List<IndustryModel> industryList) {
        ((IndustryMapper)this.dao).importIndustryList(industryList);
    }
}

