/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.modules.datacentre.dao.MicrocomCompanyYcqMapper;
import cn.smarthse.modules.datacentre.entity.MicrocomCompanyYcq;
import cn.smarthse.modules.datacentre.model.micro.CompanyChangeScaleInfo;
import cn.smarthse.modules.datacentre.model.micro.CompanyFormOdpsMicroModel;
import cn.smarthse.modules.datacentre.model.micro.MicrocomCompanyYcqModel;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.IMicrocomCompanyYcqService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class MicrocomCompanyYcqServiceImpl
extends ZYJBaseServiceImpl<MicrocomCompanyYcqMapper, MicrocomCompanyYcq>
implements IMicrocomCompanyYcqService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrocomCompanyYcqServiceImpl.class);
    @Autowired
    private MicrocomCompanyYcqMapper microcomCompanyYcqMapper;
    @Autowired
    private ICompanyService companyService;

    @Override
    public Byte getMicrocomCompanyYcqScaleByCid(Long cid) {
        if (ObjectUtil.isNotNull((Object)cid)) {
            Example example = new Example(MicrocomCompanyYcq.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            List microcomCompanyYcqs = this.microcomCompanyYcqMapper.selectByExample(example);
            if (CollUtil.isNotEmpty((Collection)microcomCompanyYcqs)) {
                return ((MicrocomCompanyYcq)microcomCompanyYcqs.get(0)).getScale();
            }
        }
        return null;
    }

    @Override
    public List<MicrocomCompanyYcqModel> getMicroYcqList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        List<MicrocomCompanyYcqModel> ycqList = this.microcomCompanyYcqMapper.selectMicroYcqList(cidList);
        return ycqList;
    }

    @Override
    @Transactional
    public void setScaleByCid(Byte scale, Long cid, Boolean isValid, Long userId) {
        this.microcomCompanyYcqMapper.updateScaleByCid(scale, cid, isValid, userId);
    }

    @Override
    @Transactional
    public void microYcqSync(String cids) {
        List<Long> cidList = MicrocomCompanyYcqServiceImpl.extractCidList(cids);
        StopWatch sw = new StopWatch("\u8d8a\u57ce\u533a\uff0c\u5c0f\u5fae\u4f01\u4e1a\u4fe1\u606f\u540c\u6b65\u3002");
        this.insert(cidList, sw);
        this.update(cidList, sw);
        this.change(cidList, sw);
        DebugUtils.error((String)sw.prettyPrint(), (Object[])new Object[0]);
        DebugUtils.error((String)"[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getId(), sw.getTotalTimeMillis()});
        XxlJobHelper.log((String)sw.prettyPrint(), (Object[])new Object[0]);
        XxlJobHelper.log((String)"[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getId(), sw.getTotalTimeMillis()});
    }

    private static List<Long> extractCidList(String cids) {
        if (CharSequenceUtil.isBlank((CharSequence)cids)) {
            return new ArrayList<Long>();
        }
        return CharSequenceUtil.split((CharSequence)cids, (char)',').stream().map(String::trim).filter(CharSequenceUtil::isNotBlank).map(cid -> {
            try {
                return Long.valueOf(cid);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private void insert(List<Long> cidList, StopWatch sw) {
        try {
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u65b0\u589e\u540c\u6b65::\u6536\u96c6\u9700\u8981\u65b0\u589e\u7684\u4f01\u4e1a");
            List<String> pidList = ((MicrocomCompanyYcqMapper)this.dao).selectNeedInsertPidList(cidList);
            sw.stop();
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u65b0\u589e\u540c\u6b65::\u6267\u884c\u9700\u8981\u65b0\u589e\u7684\u4f01\u4e1a");
            if (CollUtil.isNotEmpty(pidList)) {
                List<MicrocomCompanyYcq> ycqCollection = ((MicrocomCompanyYcqMapper)this.dao).selectNeedInsertYcqList(pidList);
                List ycqLists = ListUtil.partition(ycqCollection, (int)10000);
                int total = ycqCollection.size();
                int insertCount = 0;
                for (List ycqList : ycqLists) {
                    ((MicrocomCompanyYcqMapper)this.dao).insertList2(ycqList);
                    DebugUtils.error((String)"\u540c\u6b65\u65b0\u589e\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{insertCount += ycqList.size(), total, String.format("%.2f", (double)insertCount * 100.0 / (double)total)});
                    XxlJobHelper.log((String)"\u540c\u6b65\u65b0\u589e\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{insertCount, total, String.format("%.2f", (double)insertCount * 100.0 / (double)total)});
                }
                sw.stop();
                DebugUtils.error((String)"[{}]::\u540c\u6b65\u65b0\u589e[{}]\u6761::\u8017\u65f6[{}]ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), total, sw.getLastTaskTimeMillis()});
            } else {
                sw.stop();
                DebugUtils.error((String)"[{}]::\u65e0\u9700\u8981\u540c\u6b65\u65b0\u589e\u7684\u6570\u636e::\u8017\u65f6[{}]ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
            }
        }
        catch (Exception e) {
            sw.stop();
            DebugUtils.error((String)"[{}]::\u540c\u6b65\u65b0\u589e\u5931\u8d25::\u8017\u65f6[{}]ms::\u9519\u8bef::{}", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis(), e.getMessage()});
            throw e;
        }
    }

    private void update(List<Long> cidList, StopWatch sw) {
        try {
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u66f4\u65b0\u540c\u6b65::\u6536\u96c6\u9700\u8981\u66f4\u65b0\u7684\u4f01\u4e1a");
            List<CompanyFormOdpsMicroModel> odpsList = ((MicrocomCompanyYcqMapper)this.dao).selectNeedUpdateOdpsList(cidList);
            sw.stop();
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u66f4\u65b0\u540c\u6b65::\u6267\u884c\u9700\u8981\u66f4\u65b0\u7684\u4f01\u4e1a");
            List<Object> ycqCollection = new ArrayList();
            if (CollUtil.isNotEmpty(odpsList) && CollUtil.isNotEmpty(ycqCollection = odpsList.stream().map(odps -> {
                MicrocomCompanyYcq y = new MicrocomCompanyYcq();
                y.setCid(odps.getCid());
                y.setScale(odps.getScale());
                y.setIsValid(Boolean.TRUE);
                return y;
            }).toList())) {
                List ycqLists = ListUtils.partition(ycqCollection, (int)10000);
                int total = ycqCollection.size();
                int updateCount = 0;
                for (List ycqList : ycqLists) {
                    ((MicrocomCompanyYcqMapper)this.dao).updateYcqList(ycqList);
                    DebugUtils.error((String)"\u540c\u6b65\u66f4\u65b0\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{updateCount += ycqList.size(), total, String.format("%.2f", (double)updateCount * 100.0 / (double)total)});
                    XxlJobHelper.log((String)"\u540c\u6b65\u66f4\u65b0\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{updateCount, total, String.format("%.2f", (double)updateCount * 100.0 / (double)total)});
                }
            }
            sw.stop();
            DebugUtils.error((String)"[{}]::\u540c\u6b65\u66f4\u65b0[{}]\u6761::\u8017\u65f6[{}]ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), ycqCollection.size(), sw.getLastTaskTimeMillis()});
        }
        catch (Exception e) {
            sw.stop();
            DebugUtils.error((String)"[{}]::\u540c\u6b65\u66f4\u65b0\u5931\u8d25::\u8017\u65f6[{}]ms::\u9519\u8bef::{}", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis(), e.getMessage()});
            throw e;
        }
    }

    private void change(List<Long> cidList, StopWatch sw) {
        try {
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u6536\u96c6\u9700\u8981\u6821\u51c6\u5904\u7406\u7684\u4f01\u4e1a");
            List<CompanyChangeScaleInfo> changeList = ((MicrocomCompanyYcqMapper)this.dao).selectNeedChangeScaleList(cidList);
            sw.stop();
            sw.start("\u5c0f\u5fae\u4f01\u4e1a::\u6267\u884c\u9700\u8981\u6821\u51c6\u5904\u7406\u7684\u4f01\u4e1a");
            List<Object> ycqCollection = new ArrayList();
            if (CollUtil.isNotEmpty(changeList)) {
                List dbYcqList;
                Map<Long, Byte> changeScaleMap = changeList.stream().collect(Collectors.groupingBy(CompanyChangeScaleInfo::getCid, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(CompanyChangeScaleInfo::getUpdateDate)), o -> ((CompanyChangeScaleInfo)o.get()).getAfterScale())));
                Example example = new Example(MicrocomCompanyYcq.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("isValid", (Object)Boolean.TRUE);
                if (CollUtil.isNotEmpty(cidList)) {
                    criteria.andIn("cid", cidList);
                }
                if (CollUtil.isNotEmpty(ycqCollection = (dbYcqList = this.getListByExample(example)).stream().filter(ycq -> {
                    Byte changeScale = (Byte)changeScaleMap.get(ycq.getCid());
                    return changeScale != null && !Objects.equals(ycq.getScale(), changeScale);
                }).map(ycq -> {
                    Byte changeScale = (Byte)changeScaleMap.get(ycq.getCid());
                    MicrocomCompanyYcq y = new MicrocomCompanyYcq();
                    y.setCid(ycq.getCid());
                    y.setScale(changeScale);
                    boolean changeToMicro = Objects.equals(changeScale, (byte)3) || Objects.equals(changeScale, (byte)4);
                    y.setIsValid(changeToMicro);
                    return y;
                }).toList())) {
                    List ycqLists = ListUtils.partition(ycqCollection, (int)10000);
                    int total = ycqCollection.size();
                    int changeCount = 0;
                    for (List ycqList : ycqLists) {
                        ((MicrocomCompanyYcqMapper)this.dao).updateYcqList(ycqList);
                        DebugUtils.error((String)"\u6821\u51c6\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{changeCount += ycqList.size(), total, String.format("%.2f", (double)changeCount * 100.0 / (double)total)});
                        XxlJobHelper.log((String)"\u6821\u51c6\u8fdb\u5ea6::[{}/{}({}%)]", (Object[])new Object[]{changeCount, total, String.format("%.2f", (double)changeCount * 100.0 / (double)total)});
                    }
                }
            }
            sw.stop();
            DebugUtils.error((String)"[{}]::\u6821\u51c6[{}]\u6761::\u8017\u65f6[{}]ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), ycqCollection.size(), sw.getLastTaskTimeMillis()});
        }
        catch (Exception e) {
            sw.stop();
            DebugUtils.error((String)"[{}]::\u6821\u51c6\u5931\u8d25::\u8017\u65f6[{}]ms::\u9519\u8bef::{}", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis(), e.getMessage()});
            throw e;
        }
    }
}

