/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.smarthse.modules.datacentre.dao.ExportLogMapper;
import cn.smarthse.modules.datacentre.model.log.ExportOperLog;
import cn.smarthse.modules.datacentre.service.IExportLogService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class ExportLogServiceImpl
extends ZYJBaseServiceImpl<ExportLogMapper, ExportOperLog>
implements IExportLogService {
    @Autowired
    private IdWorker idworker;

    @Override
    @Transactional
    public void addExportLog(ExportOperLog operLog) {
        operLog.setId(Long.valueOf(this.idworker.nextId()));
        ((ExportLogMapper)this.dao).insert(operLog);
    }

    @Override
    public PageInfo<ExportOperLog> getExportLogPage(int page, int rows, List<Byte> businessTypes) {
        PageHelper.startPage((int)page, (int)rows);
        List<ExportOperLog> list = this.getExportLogList(businessTypes);
        return new PageInfo(list);
    }

    @Override
    public List<ExportOperLog> getExportLogList(List<Byte> businessTypes) {
        if (CollectionUtils.isEmpty(businessTypes)) {
            return Collections.emptyList();
        }
        Example example = new Example(ExportOperLog.class);
        if (businessTypes.size() == 1) {
            example.createCriteria().andEqualTo("businessType", (Object)businessTypes.get(0));
        } else {
            example.createCriteria().andIn("businessType", businessTypes);
        }
        example.setOrderByClause("create_date desc");
        return ((ExportLogMapper)this.dao).selectByExample(example);
    }
}

