/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.modules.datacentre.dao.CompanyVictimsInfoMapper;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfo;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfoModel;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanyVictimsInfoService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class CompanyVictimsInfoServiceImpl
extends ZYJBaseServiceImpl<CompanyVictimsInfoMapper, CompanyVictimsInfo>
implements ICompanyVictimsInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyVictimsInfoServiceImpl.class);
    @Autowired
    RedissonClient redissonClient;
    @Autowired
    ICompanyService companyService;
    private final String CACHE_NAME = "DC:CompanyVictimsInfoServiceImpl:";
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }

    @Override
    public CompanyVictimsInfo getCompanyVictimsInfo(Long cid) {
        return ((CompanyVictimsInfoMapper)this.dao).getCompanyVictimsInfo(cid);
    }

    @Override
    public Map<Long, CompanyVictimsInfo> getCompanyVictimsInfoMap(List<Long> cidList) {
        Map<Long, CompanyVictimsInfo> companyVictimsInfoMap = ((CompanyVictimsInfoMapper)this.dao).getCompanyVictimsInfoMap(cidList);
        if (MapUtil.isEmpty(companyVictimsInfoMap)) {
            return null;
        }
        return companyVictimsInfoMap;
    }

    @Override
    public List<CompanyVictimsInfo> listCompanyVictimsInfo(List<Long> cidList) {
        List<CompanyVictimsInfo> companyVictimsInfos = ((CompanyVictimsInfoMapper)this.dao).listCompanyVictimsInfo(cidList);
        if (CollUtil.isEmpty(companyVictimsInfos)) {
            return null;
        }
        return companyVictimsInfos;
    }

    @Override
    public void saveCompanyVictimsInfo(CompanyVictimsInfo victimsInfos) {
        this.saveCompanyVictimsInfoList(CollUtil.newArrayList((Object[])new CompanyVictimsInfo[]{victimsInfos}));
    }

    @Override
    public void saveCompanyVictimsInfoList(List<CompanyVictimsInfo> victimsInfos) {
        if (CollUtil.isEmpty(victimsInfos)) {
            return;
        }
        List<CompanyVictimsInfo> validDataList = victimsInfos.stream().filter(item -> item.getCid() != null).collect(Collectors.toList());
        if (CollUtil.isEmpty(validDataList)) {
            return;
        }
        List<Long> cidList = validDataList.stream().map(CompanyVictimsInfo::getCid).collect(Collectors.toList());
        Map<Long, CompanyVictimsInfo> companyVictimsInfoMap = this.getCompanyVictimsInfoMap(cidList);
        if (MapUtil.isNotEmpty(companyVictimsInfoMap)) {
            validDataList.forEach(item -> {
                CompanyVictimsInfo companyVictimsInfo = (CompanyVictimsInfo)companyVictimsInfoMap.get(item.getCid());
                item.setId(companyVictimsInfo == null ? null : companyVictimsInfo.getId());
            });
        }
        for (List companyVictimsInfos : ListUtil.partition(validDataList, (int)1000)) {
            ((ICompanyVictimsInfoService)SpringContextHolder.getBean(ICompanyVictimsInfoService.class)).batchCompanyVictimsInfo(companyVictimsInfos);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void batchCompanyVictimsInfo(List<CompanyVictimsInfo> victimsInfos) {
        List<CompanyVictimsInfo> updateList;
        if (CollUtil.isEmpty(victimsInfos)) {
            return;
        }
        List<CompanyVictimsInfo> addList = victimsInfos.stream().filter(f -> f.getId() == null).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(addList)) {
            addList.forEach(i -> {
                i.setId(Long.valueOf(IdWorker.getId()));
                i.setIsValid(Boolean.valueOf(true));
                i.setCreateDate(new Date());
            });
            ((CompanyVictimsInfoMapper)this.dao).insertList2(addList);
        }
        if (CollUtil.isNotEmpty(updateList = victimsInfos.stream().filter(f -> f.getId() != null).collect(Collectors.toList()))) {
            ((CompanyVictimsInfoMapper)this.dao).updateVictimsIdentifyNum(updateList);
        }
    }

    @Override
    @Transactional
    public void updateIdentifyRealNumSetNull(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        List<CompanyVictimsInfoModel> companyVictimsInfoList = this.companyService.getCompanyVictimsInfoByCid(cidList);
        if (CollUtil.isEmpty(companyVictimsInfoList)) {
            return;
        }
        ArrayList<Long> list = new ArrayList<Long>(companyVictimsInfoList.size());
        for (CompanyVictimsInfoModel model : companyVictimsInfoList) {
            if (!Objects.nonNull(model.getVictimsIdentify()) || !Objects.nonNull(model.getIdentifyRealNum())) continue;
            if (model.getVictimsIdentify() == 2 && model.getIdentifyRealNum() < 3) {
                list.add(model.getCid());
                continue;
            }
            if (model.getVictimsIdentify() != 1 || model.getIdentifyRealNum() < 3) continue;
            list.add(model.getCid());
        }
        if (CollUtil.isNotEmpty(list)) {
            ((CompanyVictimsInfoMapper)this.dao).updateIdentifyRealNumSetNull(list);
        }
    }

    @Override
    public List<CompanyVictimsInfo> getIdentifyRealNumListByCids(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        List<CompanyVictimsInfo> companyVictimsInfos = ((CompanyVictimsInfoMapper)this.dao).selectIdentifyRealNumListByCids(cidList);
        if (CollUtil.isEmpty(companyVictimsInfos)) {
            return null;
        }
        return companyVictimsInfos;
    }
}

