/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.dao.CompanyMapper;
import cn.smarthse.modules.datacentre.dao.CompanySuperviseMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanySupervise;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.CompanyBaseChangeInfoAddParam;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyAndOutpackModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseVerifyVo;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseResultModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyBaseChangeInfoService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.childtable.IAddData2ChildTableService;
import cn.smarthse.modules.datacentre.service.childtable.ICommonChildTableAddDataService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.util.CompanySuperviseModelUtil;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanySuperviseServiceImpl
extends ZYJBaseServiceImpl<CompanySuperviseMapper, CompanySupervise>
implements ICompanySuperviseService,
IAddData2ChildTableService {
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private CompanySuperviseMapper companySuperviseMapper;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private CompanySuperviseModelUtil superviseModelUtil;
    @Autowired
    private ICommonChildTableAddDataService commonChildTableAddDataService;
    @Autowired
    private ICompanyBaseChangeInfoService companyBaseChangeInfoService;
    private static final int BATCH_SIZE = 1000;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }

    @Override
    public PageInfo<CompanySuperviseModel> getAllOptionalEnterprisesBySystemDeploymentSourceEnum(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize, Boolean count) {
        if (Objects.isNull(count)) {
            count = true;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)count);
        List<CompanySuperviseModel> list = ((CompanySuperviseMapper)this.dao).getAllOptionalEnterprisesBySystemDeploymentSourceEnum(companySearchVo);
        return new PageInfo(list);
    }

    @Override
    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo, Boolean isOwnLevel) {
        AreaModel areaModel;
        SysParamModel sysParamIndustryCategory;
        Page localPage = PageHelper.getLocalPage();
        int pageNum = 0;
        int pageSize = 0;
        if (localPage != null) {
            pageNum = localPage.getPageNum();
            pageSize = localPage.getPageSize();
            localPage.clear();
        }
        if (companySearchVo == null) {
            companySearchVo = new CompanySuperviseSearchModel();
        }
        if (companySearchVo.getAreaId() == null) {
            companySearchVo.setAreaId(companySearchVo.getOrgAreaId());
        }
        if (companySearchVo.getIndustryCategory() != null && (sysParamIndustryCategory = this.sysParamProvideService.getById(companySearchVo.getIndustryCategory())) != null) {
            companySearchVo.setIndustryCategoryCode(sysParamIndustryCategory.getParamCode());
            companySearchVo.setIndustryCategory(null);
        }
        if (companySearchVo.getAreaId() != null && companySearchVo.getAreaLevel() == null && (areaModel = this.sysAreaProvideService.getAreaById(companySearchVo.getAreaId())) != null) {
            companySearchVo.setAreaLevel(areaModel.getLevel());
        }
        if (localPage != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<CompanySuperviseModel> companyList = ((CompanySuperviseMapper)this.dao).listCompanyInfo(companySearchVo, isOwnLevel);
        if (getBaseInfo && companyList != null && !companyList.isEmpty()) {
            Map paramMap = this.sysParamProvideService.getParamMap();
            for (CompanySuperviseModel c : companyList) {
                SysParamModel paramRegisterType;
                SysParamModel paramIndustryCategory;
                Long areaId = c.getAreaId();
                this.superviseModelUtil.settingDetailName(c, ">");
                if (c.getIndustryCategory() != null && paramMap.containsKey(c.getIndustryCategory()) && (paramIndustryCategory = (SysParamModel)paramMap.get(c.getIndustryCategory())) != null) {
                    c.setIndustryCategoryName(paramIndustryCategory.getParamValue());
                }
                if (c.getRegisterType() != null && paramMap.containsKey(c.getRegisterType()) && (paramRegisterType = (SysParamModel)paramMap.get(c.getRegisterType())) != null) {
                    c.setRegisterTypeName(paramRegisterType.getParamValue());
                }
                if (c.getScale() == null || !StringUtils.isNumeric((CharSequence)c.getScale()) || Long.parseLong(c.getScale()) >= 5L) continue;
                String scaleName = CompanySizeEnum.getName((Integer)Integer.parseInt(c.getScale()));
                c.setScaleName(scaleName);
            }
        }
        return companyList;
    }

    @Override
    @Transactional
    public int updateSuperViseByCid(CompanySupervise result, Long cid) {
        if (cid != null) {
            result.setId(null);
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            return ((CompanySuperviseMapper)this.dao).updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    @Transactional
    public Integer updateSuperViseById(CompanySupervise entity, Long updateBy) {
        return this.update(entity, updateBy);
    }

    @Override
    public CompanySupervise getCompanySuperviseByCid(Long cid) {
        Example e = new Example(CompanySupervise.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        CompanySupervise companySupervise = (CompanySupervise)((CompanySuperviseMapper)this.dao).selectOneByExample(e);
        return companySupervise;
    }

    @Override
    @Transactional
    public int delCompanySuperviseByIds(String ids, Integer delReasonItem, String delReason) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(org.apache.commons.lang3.StringUtils::isNumeric).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Date date = new Date();
            Example es = new Example(CompanySupervise.class);
            es.createCriteria().andIn("cid", idList);
            CompanySupervise sresult = new CompanySupervise();
            sresult.setSuperviseIsDel(Boolean.valueOf(true));
            sresult.setSuperviseDelTime(date);
            sresult.setDelReasonItem(delReasonItem);
            sresult.setDelReason(delReason);
            sresult.setIsValid(Boolean.valueOf(false));
            sresult.setUpdateDate(date);
            ((CompanySuperviseMapper)this.dao).updateByExampleSelective(sresult, es);
            Example e = new Example(Company.class);
            e.createCriteria().andIn("id", idList);
            Company result = new Company();
            result.setIsValid(Boolean.valueOf(false));
            result.setUpdateDate(date);
            return this.companyMapper.updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    @Transactional
    public int undoDelCompanySuperviseByIds(String ids) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(org.apache.commons.lang3.StringUtils::isNumeric).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example es = new Example(CompanySupervise.class);
            es.createCriteria().andIn("cid", idList).andEqualTo("isValid", (Object)true);
            List companySupervises = ((CompanySuperviseMapper)this.dao).selectByExample(es);
            if (CollectionUtils.isNotEmpty((Collection)companySupervises)) {
                for (CompanySupervise companySupervise : companySupervises) {
                    if (companySupervise.getIsBest() == null) {
                        companySupervise.setIsBest(Boolean.valueOf(false));
                    }
                    companySupervise.setSuperviseIsDel(Boolean.valueOf(false));
                    companySupervise.setRecoverTime(new Date());
                    companySupervise.setUpdateDate(new Date());
                    ((CompanySuperviseMapper)this.dao).updateByPrimaryKeySelective(companySupervise);
                }
            }
            Example e = new Example(Company.class);
            e.createCriteria().andIn("id", idList);
            Company result = new Company();
            result.setIsValid(Boolean.valueOf(true));
            result.setUpdateDate(new Date());
            return this.companyMapper.updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    @Transactional
    public int bestCompanyByIds(String ids, Long loginUser) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(s -> StringUtils.isNumeric((CharSequence)s)).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andIn("cid", idList).andEqualTo("isValid", (Object)true);
            CompanySupervise result = new CompanySupervise();
            result.setIsBest(Boolean.valueOf(true));
            result.setUpdateDate(new Date());
            result.setBestUpdateTime(new Date());
            result.setUpdateBy(loginUser);
            return ((CompanySuperviseMapper)this.dao).updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    @Transactional
    public int businessStateByIds(String ids, Byte flag, Long loginUser) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(org.apache.commons.lang3.StringUtils::isNumeric).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andIn("cid", idList).andEqualTo("isValid", (Object)true);
            CompanySupervise result = new CompanySupervise();
            result.setBusinessState(flag);
            result.setBusinessUpdateTime(new Date());
            result.setUpdateDate(new Date());
            result.setBestUpdateTime(new Date());
            result.setUpdateBy(loginUser);
            return ((CompanySuperviseMapper)this.dao).updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    public List<CompanySuperviseModel> listSuperviseCompanyData() {
        return ((CompanySuperviseMapper)this.dao).listSuperviseCompanyData();
    }

    @Override
    @Transactional(readOnly=false)
    public void batchUpdateOccType(List<CompanySuperviseModel> superviseModelList) {
        if (CollectionUtils.isNotEmpty(superviseModelList)) {
            ((CompanySuperviseMapper)this.dao).batchUpdateOccType(superviseModelList);
        }
    }

    @Override
    @Transactional
    public void batchUpdatePickupCount(List<CompanySuperviseModel> superviseModelList, List<CompanySuperviseModel> oldDbCompanySuperviseModels) {
        if (CollectionUtils.isNotEmpty(superviseModelList)) {
            HashMap<Long, Integer> oldDbPickupCountMap = new HashMap<Long, Integer>();
            for (CompanySuperviseModel companySuperviseModel : oldDbCompanySuperviseModels) {
                oldDbPickupCountMap.put(companySuperviseModel.getId(), companySuperviseModel.getPickupCount());
            }
            HashMap<Long, Integer> newPickupCountMap = new HashMap<Long, Integer>();
            for (CompanySuperviseModel companySuperviseModel : superviseModelList) {
                newPickupCountMap.put(companySuperviseModel.getId(), companySuperviseModel.getPickupCount());
            }
            Set set = newPickupCountMap.keySet();
            Date date = new Date();
            ArrayList<CompanyBaseChangeInfoAddParam> changeInfoList = new ArrayList<CompanyBaseChangeInfoAddParam>(set.size());
            for (Long cidItem : set) {
                Integer oldDbPickupCount;
                Integer newPickupCount = (Integer)newPickupCountMap.get(cidItem);
                if (Objects.equals(newPickupCount, oldDbPickupCount = (Integer)oldDbPickupCountMap.get(cidItem))) continue;
                CompanyBaseChangeInfoAddParam cbc = new CompanyBaseChangeInfoAddParam();
                cbc.setCid(cidItem);
                cbc.setBeforeValue(oldDbPickupCount == null ? "" : String.valueOf(oldDbPickupCount));
                cbc.setAfterValue(newPickupCount == null ? "" : String.valueOf(newPickupCount));
                cbc.setChangeType(CompanyBaseChangeTypeEnum.PICKUPCOUNT.getValue());
                cbc.setChangeTime(date);
                changeInfoList.add(cbc);
            }
            this.companyBaseChangeInfoService.batchAddChangeInfo(changeInfoList);
            RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
            ((CompanySuperviseMapper)this.dao).batchUpdatePickupCount(superviseModelList);
        }
    }

    @Override
    @Transactional
    public void batchUpdateSupervise(Set<Long> cidIdSet) {
        if (CollectionUtils.isNotEmpty(cidIdSet)) {
            ((CompanySuperviseMapper)this.dao).batchUpdateSupervise(cidIdSet);
        }
    }

    @Override
    public Integer countSuperviseCompanyData() {
        return ((CompanySuperviseMapper)this.dao).countSuperviseCompanyData();
    }

    @Override
    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize) {
        int pageStart = (page - 1) * pageSize;
        return ((CompanySuperviseMapper)this.dao).listSuperviseCompanyDataPage(pageStart, pageSize);
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    @Transactional
    public void addData(Map<String, String> companyObj, Long loginStaffId) {
        Long cid = MapUtils.getLong(companyObj, (Object)"id");
        Integer belongType = MapUtils.getInteger(companyObj, (Object)"belongType");
        Byte businessState = MapUtils.getByte(companyObj, (Object)"businessState");
        Integer gradeReason = MapUtils.getInteger(companyObj, (Object)"gradeReason");
        Example e = new Example(CompanySupervise.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        int count = ((CompanySuperviseMapper)this.dao).selectCountByExample(e);
        if (count <= 0) {
            CompanySupervise supervise = new CompanySupervise();
            if (ObjectUtil.isNotNull((Object)gradeReason)) {
                supervise.setGradeReason(gradeReason);
                supervise.setGradeCreateDate(new Date());
            }
            supervise.setCid(cid);
            supervise.setBelongType(belongType);
            supervise.setBusinessState(businessState);
            this.add(supervise, loginStaffId);
        }
    }

    @Override
    @Transactional
    public Company addCompanyInfo(CompanySuperviseModel company, Long loginStaffId) {
        Company c = new Company();
        org.springframework.beans.BeanUtils.copyProperties((Object)company, (Object)c);
        CompanySearchModel searchModel = new CompanySearchModel();
        if (StringUtils.isNotBlank((CharSequence)c.getName())) {
            searchModel.setEqualsName(c.getName());
            List<Company> companyList = this.companyService.getCompanyList(searchModel);
            if (CollectionUtils.isNotEmpty(companyList)) {
                throw new RuntimeException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)company.getUnifiedSocialCc())) {
            searchModel.setEqualsName("");
            searchModel.setUnifiedSocialCc(company.getUnifiedSocialCc());
            List<Company> dbcompanyListByCC = this.companyService.getCompanyList(searchModel);
            if (CollectionUtils.isNotEmpty(dbcompanyListByCC)) {
                Integer maxSeq = dbcompanyListByCC.stream().map(Company::getSeq).max(Integer::compare).orElse(0);
                c.setSeq(Integer.valueOf(maxSeq + 1));
            }
            c.setUnifiedSocialCc(company.getUnifiedSocialCc().toUpperCase());
        }
        if (Objects.isNull(c.getPickupCount())) {
            c.setPickupCount(null);
        }
        if (Objects.isNull(c.getDataSource())) {
            c.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
        }
        Company add = null;
        try {
            add = this.companyService.add(c, loginStaffId);
            company.setId(add.getId());
            Map stringMap = BeanUtils.describe((Object)company);
            this.commonChildTableAddDataService.addChildTableData(stringMap, loginStaffId);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u4f01\u4e1a\u5931\u8d25\uff1a", (Throwable)e);
        }
        return add;
    }

    @Override
    @Transactional(readOnly=false)
    public ImportCompanySuperviseResultModel batchAddCompany(List<CompanySuperviseModel> companyList, Boolean hasErrorAbort) {
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        ImportCompanySuperviseResultModel resultModel = new ImportCompanySuperviseResultModel();
        List<ImportCompanySuperviseModel> importCompanySuperviseModels = this.checkbatchAddCompany(companyList);
        if (CollectionUtils.isEmpty(importCompanySuperviseModels)) {
            return null;
        }
        List errDataList = importCompanySuperviseModels.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorInfo())).collect(Collectors.toList());
        resultModel.setErrorList(errDataList);
        if (Objects.equals(hasErrorAbort, true) && CollectionUtils.isNotEmpty(errDataList)) {
            return resultModel;
        }
        List validDataList = importCompanySuperviseModels.stream().filter(f -> StringUtils.isBlank((CharSequence)f.getErrorInfo())).collect(Collectors.toList());
        ArrayList<Company> newCompanyList = new ArrayList<Company>();
        ArrayList<CompanySupervise> newCompanySuperviseList = new ArrayList<CompanySupervise>();
        for (CompanySuperviseModel company : validDataList) {
            Company c2 = new Company();
            org.springframework.beans.BeanUtils.copyProperties((Object)company, (Object)c2);
            CompanySupervise s2 = new CompanySupervise();
            org.springframework.beans.BeanUtils.copyProperties((Object)company, (Object)s2);
            c2.setId(Long.valueOf(IdWorker.getId()));
            company.setId(c2.getId());
            c2.setCreateDate(new Date());
            c2.setIsValid(Boolean.valueOf(true));
            if (company.getIsTest() == null) {
                c2.setIsTest(Boolean.valueOf(false));
            }
            if (company.getIsReport() == null) {
                c2.setIsReport(Boolean.valueOf(false));
            }
            if (company.getIsSupervise() == null) {
                c2.setIsSupervise(Boolean.valueOf(false));
            }
            if (company.getIsDec() == null) {
                c2.setIsDec(Boolean.valueOf(false));
            }
            if (company.getIsDecOld() == null) {
                c2.setIsDecOld(Boolean.valueOf(false));
            }
            if (company.getIsDecCurrentYear() == null) {
                c2.setIsDecCurrentYear(Boolean.valueOf(false));
            }
            if (c2.getCompanyType() == null) {
                c2.setCompanyType(Integer.valueOf(1));
            }
            if (Objects.isNull(c2.getDataSource())) {
                c2.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
            }
            newCompanyList.add(c2);
            s2.setId(Long.valueOf(IdWorker.getId()));
            company.setSuperviseId(s2.getId());
            s2.setCid(c2.getId());
            if (s2.getBelongType() == null) {
                // empty if block
            }
            if (s2.getBusinessState() == null) {
                // empty if block
            }
            s2.setIsValid(Boolean.valueOf(true));
            newCompanySuperviseList.add(s2);
        }
        resultModel.setSuccList(validDataList);
        this.companyService.batchUpdateOrInsert(newCompanyList, CompanyMapper.class, (c, mapper) -> mapper.insertSelective(c));
        this.batchUpdateOrInsert(newCompanySuperviseList, CompanySuperviseMapper.class, (s, mapper) -> mapper.insertSelective(s));
        return resultModel;
    }

    public List<ImportCompanySuperviseModel> checkbatchAddCompany(List<CompanySuperviseModel> companyList) {
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        List<String> nameList = companyList.stream().map(CompanyBaseInfoModel::getName).distinct().collect(Collectors.toList());
        List<String> codeList = companyList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).distinct().collect(Collectors.toList());
        List<ImportCompanySuperviseModel> dbCompanyList = this.companyService.listImportCompanySuperviseModel(nameList, codeList);
        Map<Object, Object> dbCodeGroupMap = new HashMap();
        Map<Object, Object> dbNameGroupMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbCompanyList)) {
            dbCodeGroupMap = dbCompanyList.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
            dbNameGroupMap = dbCompanyList.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getName));
        }
        ArrayList<ImportCompanySuperviseModel> resultList = new ArrayList<ImportCompanySuperviseModel>();
        for (CompanySuperviseModel c : companyList) {
            ImportCompanySuperviseModel importCompanySuperviseModel;
            List importCompanySuperviseModels;
            ImportCompanySuperviseModel importResult = new ImportCompanySuperviseModel();
            org.springframework.beans.BeanUtils.copyProperties((Object)c, (Object)importResult);
            resultList.add(importResult);
            String name = c.getName();
            String unifiedSocialCc = c.getUnifiedSocialCc();
            if (dbNameGroupMap.containsKey(name)) {
                importCompanySuperviseModels = (List)dbNameGroupMap.get(name);
                if (!CollectionUtils.isNotEmpty((Collection)importCompanySuperviseModels)) continue;
                importCompanySuperviseModel = (ImportCompanySuperviseModel)importCompanySuperviseModels.get(0);
                Boolean isValid = importCompanySuperviseModel.getIsValid();
                String errorInfo = "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0";
                if (Objects.equals(isValid, false)) {
                    errorInfo = "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0\uff08\u5220\u9664\u72b6\u6001\uff09";
                }
                importResult.setId(importCompanySuperviseModel.getId());
                importResult.setSuperviseId(importCompanySuperviseModel.getSuperviseId());
                importResult.setErrorInfo(errorInfo);
                continue;
            }
            if (dbCodeGroupMap.containsKey(unifiedSocialCc)) {
                importCompanySuperviseModels = (List)dbCodeGroupMap.get(unifiedSocialCc);
                importResult.setSeq(Integer.valueOf(importCompanySuperviseModels.size() + 1));
                if (CollectionUtils.isNotEmpty((Collection)importCompanySuperviseModels)) {
                    importCompanySuperviseModel = (ImportCompanySuperviseModel)importCompanySuperviseModels.get(0);
                    importResult.setId(importCompanySuperviseModel.getId());
                    importResult.setSuperviseId(importCompanySuperviseModel.getSuperviseId());
                    importResult.setErrorInfo("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801");
                }
            } else {
                importResult.setSeq(Integer.valueOf(1));
            }
            c.setSeq(importResult.getSeq());
        }
        return resultList;
    }

    @Override
    @Transactional
    public void addSuperviseData(CompanySupervise supervise, Long loginUser) {
        if (supervise == null || supervise.getCid() == null) {
            return;
        }
        Example e = new Example(CompanySupervise.class);
        e.createCriteria().andEqualTo("cid", (Object)supervise.getCid()).andEqualTo("isValid", (Object)true).andEqualTo("superviseIsHide", (Object)false).andEqualTo("superviseIsDel", (Object)false);
        int count = ((CompanySuperviseMapper)this.dao).selectCountByExample(e);
        if (count <= 0) {
            this.add(supervise, loginUser);
        }
    }

    @Override
    public List<CompanyAndOutpackModel> listCompanyAndOutpack(CompanySuperviseSearchModel searchVo) {
        SysArea sysArea;
        if (searchVo != null && searchVo.getAreaLevel() == null && searchVo.getAreaId() != null && (sysArea = this.sysAreaService.getAreaById(searchVo.getAreaId())) != null) {
            searchVo.setAreaLevel(sysArea.getLevel());
        }
        return ((CompanySuperviseMapper)this.dao).listCompanyAndOutpack(searchVo);
    }

    @Override
    public PageInfo<CompanyAndOutpackModel> pageCompanyAndOutpack(JqGridParam param, CompanySuperviseSearchModel companySearchVo) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyAndOutpackModel> companyList = this.listCompanyAndOutpack(companySearchVo);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    @Override
    public List<CompanySuperviseModel> allCompanyId(CompanySuperviseSearchModel searchVo) {
        return ((CompanySuperviseMapper)this.dao).allCompanyId(searchVo);
    }

    @Override
    public List<CompanySuperviseModel> getNameCodeByCodes(List<String> codes) {
        return ((CompanySuperviseMapper)this.dao).getNameCodeByCodes(codes);
    }

    @Override
    @Transactional
    public void saveCompanySuperviseList(List<CompanySupervise> list) {
        if (CollUtil.isNotEmpty(list)) {
            this.batchUpdateOrInsert(list, CompanySuperviseMapper.class, (s, mapper) -> mapper.insertSelective(s));
        }
    }

    @Override
    @Transactional
    public void updateCompanySuperviseByCidList(List<CompanySupervise> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        if (CollUtil.isEmpty(list = list.stream().filter(i -> Objects.nonNull(i.getCid())).collect(Collectors.toList()))) {
            return;
        }
        this.batchUpdateOrInsert(list, CompanySuperviseMapper.class, (s, mapper) -> {
            Example example2 = new Example(CompanySupervise.class);
            example2.createCriteria().andEqualTo("cid", (Object)s.getCid()).andEqualTo("isValid", (Object)Boolean.TRUE);
            s.setId(null);
            s.setCid(null);
            return mapper.updateByExampleSelective(s, example2);
        });
    }

    @Override
    @Transactional
    public void deleteCompanyCompletely(List<Long> cidList) {
        if (CollUtil.isNotEmpty(cidList)) {
            ((CompanySuperviseMapper)this.dao).deleteCompanyCompletely(cidList);
        }
    }

    @Override
    public String getCompanySupervisionUnitNameById(Long supervisionUnit) {
        if (supervisionUnit == null) {
            return null;
        }
        return ((CompanySuperviseMapper)this.dao).getCompanySupervisionUnitNameById(supervisionUnit);
    }

    @Override
    public PageInfo<CompanySuperviseVerifyVo> getVerify2025Company(CompanySuperviseSearchModel model, int page, int rows) {
        AreaModel areaModel;
        Long areaId = model.getAreaId();
        if (ObjectUtil.isNotNull((Object)areaId) && ObjectUtil.isNotNull((Object)(areaModel = this.sysAreaProvideService.getAreaById(areaId))) && ObjectUtil.isNotNull((Object)areaModel.getLevel())) {
            model.setAreaLevel(areaModel.getLevel());
        }
        PageHelper.startPage((int)page, (int)rows);
        List<CompanySuperviseVerifyVo> list = ((CompanySuperviseMapper)this.dao).getVerify2025Company(model);
        for (CompanySuperviseVerifyVo companySuperviseVerifyVo : list) {
            Byte businessState;
            String changeResult = companySuperviseVerifyVo.getChangeResult();
            if (StringUtils.isNotEmpty((String)changeResult)) {
                companySuperviseVerifyVo.setChangeResult(changeResult.replace("\u5df2\u5173\u505c", "\u5173\u505c"));
            }
            if (!ObjectUtil.isNotNull((Object)(businessState = companySuperviseVerifyVo.getBusinessState()))) continue;
            if (businessState == 1) {
                companySuperviseVerifyVo.setBusinessStateName("\u6b63\u5e38\u8425\u4e1a");
                continue;
            }
            if (businessState == 2) {
                companySuperviseVerifyVo.setBusinessStateName("\u6682\u505c\u8425\u4e1a");
                continue;
            }
            if (businessState == 0) {
                companySuperviseVerifyVo.setBusinessStateName("\u5173\u505c");
                continue;
            }
            companySuperviseVerifyVo.setBusinessStateName("/");
        }
        return new PageInfo(list);
    }

    @Override
    public void updateCompanyGradeReason(Long cid, Integer gradeReason, Date gradeCreateDate, Long userId) {
        if (ObjectUtil.isNull((Object)cid)) {
            return;
        }
        ((CompanySuperviseMapper)this.dao).updateCompanyGradeReason(cid, gradeReason, gradeCreateDate, userId);
        if (CompanyGradeReasonEnum.REPORTCOMPLAINTS.getValue().equals(gradeReason) || CompanyGradeReasonEnum.STATUTORYREPORTING.getValue().equals(gradeReason) || CompanyGradeReasonEnum.OTHERCASESINVOLVED.getValue().equals(gradeReason)) {
            ((CompanySuperviseMapper)this.dao).updateCompanyDec(cid, null, 1, 1, userId);
        }
    }
}

