/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.dao.CompanyMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyRefUpdateVo;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.SysSuperviseOrgLogAddParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.model.supervise.CompanySelfReportModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseModel;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanyServiceImpl
extends ZYJBaseServiceImpl<CompanyMapper, Company>
implements ICompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyServiceImpl.class);
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private RedisClient redisClient;
    private static final String COMPANY_TRAINING_BASE_CACHE = "CompanyTrainingBaseCache";
    private static final Long COMPANY_TRAINING_BASE_CACHE_TIME = 86400L;
    private static final int BATCH_SIZE = 1000;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private static CloseableHttpClient httpClient = HttpClients.custom().setMaxConnPerRoute(10).setMaxConnTotal(20).evictIdleConnections(60L, TimeUnit.SECONDS).build();

    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }

    @Override
    public Company getCompanyByName(String name) {
        return this.getByCases(null, null, name, null);
    }

    @Override
    public Company getByCases(String unifiedSocialCc, Long cid, String fullname, String email) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotEmpty((String)fullname)) {
            c.andEqualTo("name", (Object)fullname);
        }
        if (StringUtils.isNotEmpty((String)unifiedSocialCc)) {
            c.andEqualTo("unifiedSocialCc", (Object)unifiedSocialCc);
        }
        if (StringUtils.isNotEmpty((String)email)) {
            c.andEqualTo("companyContactEmail", (Object)email);
        }
        if (cid != null && cid > 0L) {
            c.andNotEqualTo("id", (Object)cid);
        }
        example.setOrderByClause("update_date desc");
        return (Company)this.getOneByExample(example);
    }

    @Override
    public List<Company> getByUnifiedSocialCc(String unifiedSocialCc) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotEmpty((String)unifiedSocialCc)) {
            c.andEqualTo("unifiedSocialCc", (Object)unifiedSocialCc);
        }
        example.setOrderByClause("update_date desc");
        return this.getListByExample(example);
    }

    @Override
    public Company getCompanyByName(String name, Integer companyType) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotEmpty((String)name)) {
            c.andEqualTo("name", (Object)name);
        }
        if (companyType != null) {
            c.andEqualTo("companyType", (Object)companyType);
        }
        return (Company)this.getOneByExample(example);
    }

    @Override
    public Company getByCompanyNameOrUnifiedSocialCode(String name, String unifiedSocialCode, Integer companyType) {
        if (StrUtil.isBlank((CharSequence)name) || StrUtil.isBlank((CharSequence)unifiedSocialCode)) {
            return null;
        }
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        Example.Criteria c1 = example.createCriteria();
        c.andEqualTo("isValid", (Object)true).andEqualTo("name", (Object)name);
        c1.andEqualTo("isValid", (Object)true).andEqualTo("unifiedSocialCc", (Object)unifiedSocialCode);
        if (Objects.nonNull(companyType)) {
            c.andEqualTo("companyType", (Object)companyType);
            c1.andEqualTo("companyType", (Object)companyType);
        }
        example.or(c1);
        return (Company)this.getOneByExample(example);
    }

    @Override
    public String getCorpCcExtend(String unifiedSocialCc) {
        StringBuffer ccExtend = new StringBuffer();
        if (StringUtils.isNotEmpty((String)unifiedSocialCc)) {
            Integer maxCcExtend = ((CompanyMapper)this.dao).queryMaxCcExtend(unifiedSocialCc);
            if (maxCcExtend != null && maxCcExtend.toString().length() == 1) {
                ccExtend.append("00").append(maxCcExtend);
            } else if (maxCcExtend != null && maxCcExtend.toString().length() == 2) {
                ccExtend.append("0").append(maxCcExtend);
            } else if (maxCcExtend != null) {
                ccExtend.append(maxCcExtend);
            }
        }
        return ccExtend.toString();
    }

    @Override
    public List<Company> getCompanyList(CompanySearchModel searchModel) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        if (searchModel.getAllIsValid() == null || !searchModel.getAllIsValid().booleanValue()) {
            c.andEqualTo("isValid", (Object)true);
        }
        if (StringUtils.isNotEmpty((String)searchModel.getFullname())) {
            c.andLike("name", "%" + searchModel.getFullname() + "%");
        }
        if (StringUtils.isNotEmpty((String)searchModel.getEqualsName())) {
            c.andEqualTo("name", (Object)searchModel.getEqualsName());
        }
        if (searchModel.getExcludeId() != null) {
            c.andNotEqualTo("id", (Object)searchModel.getExcludeId());
        }
        if (StringUtils.isNotEmpty((String)searchModel.getUnifiedSocialCc())) {
            c.andEqualTo("unifiedSocialCc", (Object)searchModel.getUnifiedSocialCc());
        }
        if (searchModel.getRegType() != null && searchModel.getRegType() > 0) {
            c.andEqualTo("regType", (Object)searchModel.getRegType());
        }
        if (searchModel.getAreaIds() != null && searchModel.getAreaIds().size() > 0) {
            c.andIn("areaId", (Iterable)searchModel.getAreaIds());
        }
        if (searchModel.getCompanyType() != null) {
            c.andEqualTo("companyType", (Object)searchModel.getCompanyType());
        }
        example.setOrderByClause("update_date desc");
        return this.getListByExample(example);
    }

    @Override
    public List<CompanySuperviseModel> listCompanyPickCount(Set<Long> ids) {
        return ((CompanyMapper)this.dao).listCompanyPickCount(ids);
    }

    @Override
    public List<Company> getByUnifiedSocialCc(List<String> unifiedSocialCodes) {
        if (unifiedSocialCodes == null || unifiedSocialCodes.isEmpty()) {
            return Collections.emptyList();
        }
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("unifiedSocialCc", unifiedSocialCodes);
        return this.getListByExample(example);
    }

    @Override
    public List<CompanyGradeModel> listComapnyGradeInfo(List<Long> cidList) {
        return ((CompanyMapper)this.dao).listComapnyGradeInfo(cidList);
    }

    @Override
    public List<CompanyGradeModel> listComapnyGradeInfo2() {
        return ((CompanyMapper)this.dao).listComapnyGradeInfo2();
    }

    @Override
    public List<CompanyGradeModelV3> listComapnyGradeInfoV3(List<Long> cids) {
        return ((CompanyMapper)this.dao).listComapnyGradeInfov3(cids);
    }

    @Override
    public List<CompanySelfReportModel> listSelfReportCompany() {
        return ((CompanyMapper)this.dao).listSelfReportCompany();
    }

    @Override
    @Transactional
    public void updateIndustryCategory(Long indusId, Long cid) {
        Company company = new Company();
        company.setId(cid);
        company.setIndustryCategory(indusId);
        this.update(company);
    }

    @Override
    public List<CompanySuperviseModel> allCompanyIdName(CompanySuperviseSearchModel searchVo) {
        Example e = new Example(Company.class);
        e.selectProperties(new String[]{"id", "name"});
        List companySupervises = ((CompanyMapper)this.dao).selectByExample(e);
        List<CompanySuperviseModel> collect = companySupervises.stream().map(m -> {
            CompanySuperviseModel model = new CompanySuperviseModel();
            model.setId(m.getId());
            model.setName(m.getName());
            return model;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<CompanySuperviseModel> selectIdName(CompanySuperviseSearchModel searchVo) {
        return ((CompanyMapper)this.dao).selectIdName(searchVo);
    }

    @Override
    public List<CompanySuperviseModel> listInvalidCid() {
        return ((CompanyMapper)this.dao).listInvalidCid();
    }

    @Override
    public List<Long> listCityLevelCid(Long areaId, Byte areaLevel) {
        return ((CompanyMapper)this.dao).listCityLevelCid(areaId, areaLevel);
    }

    @Override
    public Long getCidByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return ((CompanyMapper)this.dao).getCidByCode(code);
    }

    @Override
    @Transactional
    public void updateComsIsExistRadioactivity(List<Long> cidList, Boolean isExistRadioactivity, Long userId) {
        ((CompanyMapper)this.dao).updateComsIsExistRadioactivity(cidList, isExistRadioactivity, userId);
    }

    @Override
    @Transactional
    public void updateComMsg(Company company) {
        ((CompanyMapper)this.dao).updateComMsg(company);
    }

    @Override
    public int countBelongCityCompanyNum(Long areaId) {
        return ((CompanyMapper)this.dao).countBelongCityCompanyNum(areaId);
    }

    @Override
    @Transactional
    public Integer updateCompanySuperviseUnit(Long organizationId, Long organizationAreaId, List<Long> companyIdList) {
        return ((CompanyMapper)this.dao).updateCompanySuperviseUnit(organizationId, organizationAreaId, companyIdList);
    }

    @Override
    @Transactional
    public void updateVictimsIdentifyIds(List<Long> cidList, Integer victimsIdentify) {
        if (CollectionUtils.isNotEmpty(cidList)) {
            Example e = new Example(Company.class);
            e.createCriteria().andIn("id", cidList);
            Company result = new Company();
            result.setVictimsIdentify(victimsIdentify);
            ((CompanyMapper)this.dao).updateByExampleSelective(result, e);
        }
    }

    @Override
    @Transactional
    public int batchUpdateCompanyRef(List<CompanyRefUpdateVo> updateVoList) {
        return ((CompanyMapper)this.dao).batchUpdateCompanyRef(updateVoList);
    }

    @Override
    @Transactional
    public void updateAreaIdBycid(Long cid, Long locationAddAreaId, Long updateBy) {
        Company company = new Company();
        company.setId(cid);
        company.setAreaId(locationAddAreaId);
        this.update(company, updateBy);
    }

    @Override
    public List<Long> getAllDecCompanyIds() {
        Example example = new Example(Company.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isTest", (Object)0).andEqualTo("isDec", (Object)1);
        List companies = ((CompanyMapper)this.dao).selectByExample(example);
        if (CollUtil.isEmpty((Collection)companies)) {
            return Collections.emptyList();
        }
        return companies.stream().map(Company::getId).collect(Collectors.toList());
    }

    @Override
    public Long getCompanyNumsByAreaId(Long areaId) {
        SysAreaV3OneVo area = this.sysAreaService.getAreaByIdV3(areaId);
        return Objects.isNull(area) ? 0L : ((CompanyMapper)this.dao).getCompanyNumsByAreaId(areaId, area.getLevel());
    }

    @Override
    public List<Company> getOnlyCompanyByCid(List<Long> cidList) {
        if (CollectionUtils.isNotEmpty(cidList)) {
            Example e = new Example(Company.class);
            e.createCriteria().andIn("id", cidList);
            return ((CompanyMapper)this.dao).selectByExample(e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Company> getOnlyCompanyByCidExcludeDelete(List<Long> idList) {
        return ((CompanyMapper)this.dao).getOnlyCompanyByCidExcludeDelete(idList);
    }

    @Override
    public List<Company> getOnlyCompanyByName(List<String> nameList) {
        if (CollectionUtils.isNotEmpty(nameList)) {
            Example e = new Example(Company.class);
            e.createCriteria().andIn("name", nameList);
            return ((CompanyMapper)this.dao).selectByExample(e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Company> getOnlyCompanyByNameExcludeDelete(List<String> nameList) {
        return ((CompanyMapper)this.dao).getOnlyCompanyByNameExcludeDelete(nameList);
    }

    @Override
    public List<Company> getOnlyCompanyByUnitCode(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            Example e = new Example(Company.class);
            e.createCriteria().andIn("unifiedSocialCc", codeList);
            return ((CompanyMapper)this.dao).selectByExample(e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Company> getOnlyCompanyByUnitCodeExcludeDelete(List<String> codeList) {
        return ((CompanyMapper)this.dao).getOnlyCompanyByUnitCodeExcludeDelete(codeList);
    }

    @Override
    public List<Company> getOnlyCompanyByDataSourceIdExcludeDelete(List<String> dataSourceIdList, Integer dataSource) {
        return ((CompanyMapper)this.dao).getOnlyCompanyByDataSourceIdExcludeDelete(dataSourceIdList, dataSource);
    }

    @Override
    public List<CompanySuperviseModel> getOnlyCompanySuperviseByCidExcludeDelete(List<Long> cidList) {
        return ((CompanyMapper)this.dao).getOnlyCompanySuperviseByCid(cidList);
    }

    @Override
    @Transactional
    public void saveCompanyByIdList(List<Company> list) {
        if (CollUtil.isNotEmpty(list)) {
            this.batchUpdateOrInsert(list, CompanyMapper.class, (s, mapper) -> mapper.insertSelective(s));
        }
    }

    @Override
    @Transactional
    public void updateCompanyByIdList(List<Company> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        if (CollUtil.isEmpty(list = list.stream().filter(i -> Objects.nonNull(i.getId())).collect(Collectors.toList()))) {
            return;
        }
        Map<Long, Company> companyMap = list.stream().collect(Collectors.toMap(Company::getId, item -> item, (v1, v2) -> v2));
        List companies = ((CompanyMapper)this.dao).selectByIds(list.stream().map(i -> String.valueOf(i.getId())).collect(Collectors.joining(",")));
        if (CollUtil.isNotEmpty((Collection)companies)) {
            Date date = new Date();
            ArrayList<SysSuperviseOrgLogAddParam> sysSuperviseOrgLogList = new ArrayList<SysSuperviseOrgLogAddParam>(companies.size());
            companies.forEach(i -> {
                if (companyMap.containsKey(i.getId())) {
                    Company newCompany = (Company)companyMap.get(i.getId());
                    if (!Objects.equals(((Company)companyMap.get(i.getId())).getSupervisionUnit(), newCompany.getSupervisionUnit())) {
                        SysSuperviseOrgLogAddParam sysSuperviseOrgLog = new SysSuperviseOrgLogAddParam();
                        sysSuperviseOrgLog.setId(Long.valueOf(IdWorker.getId()));
                        sysSuperviseOrgLog.setCid(i.getId());
                        sysSuperviseOrgLog.setChangeBefore(((Company)companyMap.get(i.getId())).getSupervisionUnit());
                        sysSuperviseOrgLog.setChangeAfter(newCompany.getSupervisionUnit());
                        sysSuperviseOrgLog.setChangeTime(date);
                        sysSuperviseOrgLog.setCreateBy(newCompany.getUpdateBy());
                        sysSuperviseOrgLog.setCreateBy(newCompany.getUpdateBy());
                        sysSuperviseOrgLog.setCreateDate(date);
                        sysSuperviseOrgLog.setUpdateDate(date);
                        sysSuperviseOrgLogList.add(sysSuperviseOrgLog);
                    }
                }
            });
            if (CollUtil.isNotEmpty(sysSuperviseOrgLogList)) {
                this.addSuperviseOrgLog(sysSuperviseOrgLogList);
            }
        }
        this.batchUpdateOrInsert(list, CompanyMapper.class, (s, mapper) -> mapper.updateByPrimaryKeySelective(s));
    }

    @Override
    @Transactional
    public Integer addSuperviseOrgLog(List<SysSuperviseOrgLogAddParam> orgLogList) {
        if (CollUtil.isNotEmpty(orgLogList)) {
            return ((CompanyMapper)this.dao).addSuperviseOrgLog(orgLogList);
        }
        return orgLogList.size();
    }

    @Override
    @Transactional
    public void deleteCompanyCompletely(List<Long> idList) {
        if (CollUtil.isNotEmpty(idList)) {
            ((CompanyMapper)this.dao).deleteCompanyCompletely(idList);
        }
    }

    @Override
    public Boolean isHaveThisName(String name, Long excludeId, Boolean isValid) {
        if (StrUtil.isBlank((CharSequence)name)) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((CompanyMapper)this.dao).isHaveThisName(name, excludeId, isValid) > 0;
    }

    @Override
    public Boolean isHaveThisCreditCode(String creditCode, Long excludeId, Boolean isValid) {
        if (StrUtil.isBlank((CharSequence)creditCode)) {
            throw new ServiceException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((CompanyMapper)this.dao).isHaveThisCreditCode(creditCode, excludeId, isValid) > 0;
    }

    @Override
    public List<CompanyBaseInfoModel> getCompanyBaseInfoList(List<Long> cidList, Map<String, Object> param) {
        Object obj;
        ArrayList<CompanyBaseInfoModel> list = new ArrayList<CompanyBaseInfoModel>();
        Example e = new Example(Company.class);
        Example.Criteria criteria = e.createCriteria();
        if (CollectionUtils.isNotEmpty(cidList)) {
            criteria.andIn("id", cidList);
        }
        if (MapUtils.isNotEmpty(param) && param.get("getProductionTime") != null) {
            criteria.andIsNotNull("productionTime");
            e.selectProperties(new String[]{"id", "productionTime"});
        }
        if (MapUtils.isNotEmpty(param) && param.get("newCompanyGuide") != null) {
            criteria.andEqualTo("dataSource", (Object)CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue()).andEqualTo("isDec", (Object)false);
        }
        if (MapUtils.isNotEmpty(param) && param.get("companyNameList") != null && (obj = param.get("companyNameList")) instanceof List) {
            ArrayList<String> companyNameList = new ArrayList<String>();
            for (Object o : (List)obj) {
                companyNameList.add((String)o);
            }
            if (CollectionUtils.isNotEmpty(companyNameList)) {
                criteria.andIn("name", companyNameList);
            }
        }
        if (MapUtils.isNotEmpty(param) && param.get("unifiedSocialCcList") != null && (obj = param.get("unifiedSocialCcList")) instanceof List) {
            ArrayList<String> unifiedSocialCcList = new ArrayList<String>();
            for (Object o : (List)obj) {
                unifiedSocialCcList.add((String)o);
            }
            if (CollectionUtils.isNotEmpty(unifiedSocialCcList)) {
                criteria.andIn("unifiedSocialCc", unifiedSocialCcList);
            }
        }
        List companyList = ((CompanyMapper)this.dao).selectByExample(e);
        for (Company company : companyList) {
            if (company == null) continue;
            CompanyBaseInfoModel model = new CompanyBaseInfoModel();
            BeanUtils.copyProperties((Object)company, (Object)model);
            list.add(model);
        }
        return list;
    }

    @Override
    public List<ImportCompanySuperviseModel> listImportCompanySuperviseModel(List<String> nameList, List<String> codeList) {
        if (CollectionUtils.isEmpty(nameList) && CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).listImportCompanySuperviseModel(nameList, codeList);
    }

    @Override
    public List<String> getAllImportBatchNo() {
        Example e = new Example(Company.class);
        Example.Criteria criteria = e.createCriteria();
        e.selectProperties(new String[]{"importBatchNo"});
        e.setDistinct(true);
        List companyList = ((CompanyMapper)this.dao).selectByExample(e);
        if (CollectionUtils.isNotEmpty((Collection)companyList)) {
            return companyList.stream().filter(f -> f != null && f.getImportBatchNo() != null).map(Company::getImportBatchNo).distinct().collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<CompanyVictimsInfoModel> getCompanyVictimsInfoByCid(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).getCompanyVictimsInfoByCid(cidList);
    }

    @Override
    @Transactional
    public List<Long> updateCompanyCase(List<Long> cidList, Integer type) {
        if (CollUtil.isEmpty(cidList) || type == null) {
            return Collections.emptyList();
        }
        Example e = new Example(Company.class);
        Example.Criteria criteria = e.createCriteria();
        criteria.andIn("id", cidList);
        criteria.andNotLike("companyCase", "%" + type + "%");
        e.selectProperties(new String[]{"id", "companyCase"});
        List companyList = ((CompanyMapper)this.dao).selectByExample(e);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        companyList.forEach(f -> {
            idList.add(f.getId());
            List collect = cn.smarthse.common.util.StringUtils.parseToIntegerList((String)f.getCompanyCase(), (String)",").stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                f.setCompanyCase("0," + type);
            } else {
                collect.add(type);
                collect = collect.stream().distinct().sorted().collect(Collectors.toList());
                f.setCompanyCase(cn.smarthse.common.util.StringUtils.join(collect, (String)","));
            }
        });
        this.batchUpdateOrInsert(companyList, CompanyMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        return idList;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }
}

