/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.dao.CompanyProposedChangeMapper;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeClueLastParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaDTO;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForCidParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForIdParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeVo;
import cn.smarthse.modules.datacentre.service.ICompanyProposedChangeService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanyProposedChangeServiceImpl
extends ZYJBaseServiceImpl<CompanyProposedChangeMapper, CompanyProposedChange>
implements ICompanyProposedChangeService {
    @Override
    public CompanyProposedChange getClueLast(CompanyProposedChangeClueLastParam param) {
        return ((CompanyProposedChangeMapper)this.dao).getClueLast(param);
    }

    @Override
    public List<CompanyProposedChange> getClueList(CompanyProposedChangeClueLastParam param) {
        return ((CompanyProposedChangeMapper)this.dao).getClueList(param);
    }

    @Override
    @Transactional
    public Boolean removeChangeEnterprise(List<Long> cidList, Integer stopType) {
        Example example = new Example(CompanyProposedChange.class);
        example.createCriteria().andIn("cid", cidList).andEqualTo("isValid", (Object)true).andEqualTo("stopType", (Object)stopType);
        CompanyProposedChange companyProposedChange = new CompanyProposedChange();
        companyProposedChange.setIsValid(Boolean.FALSE);
        return ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(companyProposedChange, example) > 0;
    }

    @Override
    public List<CompanyProposedChangeVo> getChangeEnterpriseList(List<Long> cidList, Integer stopType) {
        return ((CompanyProposedChangeMapper)this.dao).getChangeEnterpriseList(cidList, stopType);
    }

    @Override
    @Transactional
    public boolean updateStatusForId(CompanyProposedChangeStatusForIdParam param) {
        Long userId = param.getUserId();
        List targetIdList = param.getIdList();
        Integer status = param.getStatus();
        LocalDateTime confirmTime = param.getConfirmTime();
        if (Objects.isNull(userId) || CollUtil.isEmpty((Collection)targetIdList) || Objects.isNull(status) || Objects.isNull(confirmTime)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyProposedChange.class);
        example.createCriteria().andIn("id", (Iterable)targetIdList).andEqualTo("isValid", (Object)true);
        List targetChanges = ((CompanyProposedChangeMapper)this.dao).selectByExample(example);
        if (CollUtil.isEmpty((Collection)targetChanges)) {
            return false;
        }
        if (Objects.equals(status, StopStatusEnums.CONFIRMED.getCode())) {
            Integer stopType = ((CompanyProposedChange)targetChanges.get(0)).getStopType();
            List cidList = targetChanges.stream().map(CompanyProposedChange::getCid).collect(Collectors.toList());
            if (StopTypeEnums.CLOSE.getCode().equals(stopType) || StopTypeEnums.NORMAL.getCode().equals(stopType)) {
                Example updateExample = new Example(CompanyProposedChange.class);
                updateExample.createCriteria().andIn("cid", cidList).andEqualTo("stopType", (Object)stopType).andIn("status", Arrays.asList(StopStatusEnums.PENDING_CONFIRMATION.getCode(), StopStatusEnums.PROCESS.getCode())).andEqualTo("isValid", (Object)true);
                CompanyProposedChange updateChange = new CompanyProposedChange();
                updateChange.setStatus(StopStatusEnums.CONFIRMED.getCode());
                updateChange.setConfirmTime(confirmTime);
                updateChange.setUpdateBy(userId);
                updateChange.setUpdateDate(LocalDateTime.now());
                return ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(updateChange, updateExample) > 0;
            }
            if (StopTypeEnums.CHANGECROSS.getCode().equals(stopType) || StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType) || StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType)) {
                Example selectExample = new Example(CompanyProposedChange.class);
                selectExample.createCriteria().andIn("cid", cidList).andIn("stopType", Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode())).andIn("status", Arrays.asList(StopStatusEnums.PENDING_CONFIRMATION.getCode(), StopStatusEnums.PROCESS.getCode())).andEqualTo("isValid", (Object)true);
                List pendingConfirmChanges = ((CompanyProposedChangeMapper)this.dao).selectByExample(selectExample);
                if (CollUtil.isEmpty((Collection)pendingConfirmChanges)) {
                    return false;
                }
                Set targetKeys = targetChanges.stream().map(change -> change.getCid() + "_" + change.getStopAreaId()).collect(Collectors.toSet());
                ArrayList<Long> autoApproveIds = new ArrayList<Long>();
                ArrayList<Long> rejectIds = new ArrayList<Long>();
                for (CompanyProposedChange change2 : pendingConfirmChanges) {
                    String key = change2.getCid() + "_" + change2.getStopAreaId();
                    if (targetKeys.contains(key)) {
                        autoApproveIds.add(change2.getId());
                        continue;
                    }
                    rejectIds.add(change2.getId());
                }
                boolean result = false;
                if (!autoApproveIds.isEmpty()) {
                    Example updateExample = new Example(CompanyProposedChange.class);
                    updateExample.createCriteria().andIn("id", autoApproveIds).andEqualTo("isValid", (Object)true);
                    CompanyProposedChange updateChange = new CompanyProposedChange();
                    updateChange.setStatus(StopStatusEnums.CONFIRMED.getCode());
                    updateChange.setConfirmTime(confirmTime);
                    updateChange.setUpdateBy(userId);
                    updateChange.setUpdateDate(LocalDateTime.now());
                    boolean bl = result = ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(updateChange, updateExample) > 0;
                }
                if (!rejectIds.isEmpty()) {
                    Example rejectExample = new Example(CompanyProposedChange.class);
                    rejectExample.createCriteria().andIn("id", rejectIds).andEqualTo("isValid", (Object)true);
                    CompanyProposedChange rejectChange = new CompanyProposedChange();
                    rejectChange.setStatus(StopStatusEnums.RETURNED.getCode());
                    rejectChange.setConfirmTime(confirmTime);
                    rejectChange.setUpdateBy(userId);
                    rejectChange.setUpdateDate(LocalDateTime.now());
                    boolean rejectResult = ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(rejectChange, rejectExample) > 0;
                    result = result || rejectResult;
                }
                return result;
            }
        } else {
            Example updateExample = new Example(CompanyProposedChange.class);
            updateExample.createCriteria().andIn("id", (Iterable)targetIdList).andEqualTo("isValid", (Object)true);
            CompanyProposedChange updateChange = new CompanyProposedChange();
            updateChange.setStatus(status);
            updateChange.setConfirmTime(confirmTime);
            updateChange.setUpdateBy(userId);
            updateChange.setUpdateDate(LocalDateTime.now());
            return ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(updateChange, updateExample) > 0;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateStatusForCid(CompanyProposedChangeStatusForCidParam param) {
        Long userId = param.getUserId();
        List targetCidList = param.getCidList();
        Integer stopType = param.getStopType();
        Integer status = param.getStatus();
        LocalDateTime confirmTime = param.getConfirmTime();
        if (Objects.isNull(userId) || CollUtil.isEmpty((Collection)targetCidList) || Objects.isNull(status) || Objects.isNull(stopType) || Objects.isNull(confirmTime)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        if (!StopTypeEnums.CLOSE.getCode().equals(stopType) && !StopTypeEnums.NORMAL.getCode().equals(stopType)) {
            throw new HealthException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        Example updateExample = new Example(CompanyProposedChange.class);
        updateExample.createCriteria().andIn("cid", (Iterable)targetCidList).andEqualTo("stopType", (Object)stopType).andIn("status", Arrays.asList(StopStatusEnums.PENDING_CONFIRMATION.getCode(), StopStatusEnums.PROCESS.getCode())).andEqualTo("isValid", (Object)true);
        CompanyProposedChange updateChange = new CompanyProposedChange();
        updateChange.setStatus(status);
        updateChange.setConfirmTime(confirmTime);
        updateChange.setUpdateBy(userId);
        updateChange.setUpdateDate(LocalDateTime.now());
        return ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(updateChange, updateExample) > 0;
    }

    @Override
    @Transactional
    public boolean updateStatusForArea(CompanyProposedChangeStatusForAreaParam param) {
        Boolean ifSubmit = param.getIfSubmit();
        Long userId = param.getUserId();
        Integer stopType = param.getStopType();
        Integer status = param.getStatus();
        LocalDateTime confirmTime = param.getConfirmTime();
        List targetChanges = param.getDtoList();
        if (Objects.isNull(userId) || Objects.isNull(stopType) || Objects.isNull(status) || Objects.isNull(confirmTime) || CollUtil.isEmpty((Collection)targetChanges)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        if (!(StopTypeEnums.CHANGECROSS.getCode().equals(stopType) || StopTypeEnums.CHANGEWITHIN.getCode().equals(stopType) || StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(stopType))) {
            throw new HealthException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        List targetCidList = targetChanges.stream().map(CompanyProposedChangeStatusForAreaDTO::getCid).collect(Collectors.toList());
        Example selectExample = new Example(CompanyProposedChange.class);
        selectExample.createCriteria().andIn("cid", targetCidList).andIn("stopType", Arrays.asList(StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode())).andIn("status", Arrays.asList(StopStatusEnums.PENDING_CONFIRMATION.getCode(), StopStatusEnums.PROCESS.getCode())).andEqualTo("isValid", (Object)true);
        List pendingConfirmChanges = ((CompanyProposedChangeMapper)this.dao).selectByExample(selectExample);
        if (CollUtil.isEmpty((Collection)pendingConfirmChanges)) {
            return false;
        }
        Map<Long, CompanyProposedChangeStatusForAreaDTO> targetChangeMap = targetChanges.stream().collect(Collectors.toMap(CompanyProposedChangeStatusForAreaDTO::getCid, dto -> dto, (existing, replacement) -> existing));
        ArrayList<Long> autoApproveIds = new ArrayList<Long>();
        ArrayList<Long> rejectIds = new ArrayList<Long>();
        for (CompanyProposedChange change : pendingConfirmChanges) {
            CompanyProposedChangeStatusForAreaDTO targetDto = targetChangeMap.get(change.getCid());
            if (!Objects.nonNull(targetDto)) continue;
            if (Objects.equals(change.getStopAreaId(), targetDto.getStopAreaId())) {
                autoApproveIds.add(change.getId());
                continue;
            }
            rejectIds.add(change.getId());
        }
        boolean result = false;
        if (!autoApproveIds.isEmpty()) {
            Example updateExample = new Example(CompanyProposedChange.class);
            updateExample.createCriteria().andIn("id", autoApproveIds).andEqualTo("isValid", (Object)true);
            CompanyProposedChange updateChange = new CompanyProposedChange();
            updateChange.setStatus(status);
            updateChange.setConfirmTime(confirmTime);
            updateChange.setUpdateBy(userId);
            updateChange.setUpdateDate(LocalDateTime.now());
            boolean bl = result = ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(updateChange, updateExample) > 0;
        }
        if (!rejectIds.isEmpty()) {
            Example rejectExample = new Example(CompanyProposedChange.class);
            Example.Criteria criteria = rejectExample.createCriteria().andIn("id", rejectIds).andEqualTo("isValid", (Object)true);
            if (Boolean.TRUE.equals(ifSubmit)) {
                criteria.andNotEqualTo("status", (Object)StopStatusEnums.PENDING_CONFIRMATION.getCode());
            }
            CompanyProposedChange rejectChange = new CompanyProposedChange();
            rejectChange.setStatus(StopStatusEnums.RETURNED.getCode());
            rejectChange.setConfirmTime(confirmTime);
            rejectChange.setUpdateBy(userId);
            rejectChange.setUpdateDate(LocalDateTime.now());
            boolean rejectResult = ((CompanyProposedChangeMapper)this.dao).updateByExampleSelective(rejectChange, rejectExample) > 0;
            result = result || rejectResult;
        }
        return result;
    }

    @Override
    public List<CompanyProposedChange> selectAllPendingConfirmationListDataByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        return ((CompanyProposedChangeMapper)this.dao).selectAllPendingConfirmationListDataByIdList(idList);
    }
}

