/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.dao.CompanyDyMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanyDy;
import cn.smarthse.modules.datacentre.service.ICompanyDyService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanyDyServiceImpl
extends ZYJBaseServiceImpl<CompanyDyMapper, CompanyDy>
implements ICompanyDyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyDyServiceImpl.class);
    private static final int BATCH_SIZE = 1000;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }

    @Override
    public List<Company> getOnlyCompanyByDataSourceIdExcludeDelete(List<String> dataSourceDyIdList) {
        return ((CompanyDyMapper)this.dao).getOnlyCompanyByDataSourceIdExcludeDelete(dataSourceDyIdList);
    }

    @Override
    @Transactional
    public void saveCompanyDyByIdList(List<CompanyDy> list) {
        if (CollUtil.isNotEmpty(list)) {
            this.batchUpdateOrInsert(list, CompanyDyMapper.class, (s, mapper) -> mapper.insertSelective(s));
        }
    }

    @Override
    public List<CompanyDy> getListByIdList(List<Long> cidList) {
        if (CollUtil.isNotEmpty(cidList)) {
            Example example = new Example(CompanyDy.class);
            example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("cid", cidList);
            return ((CompanyDyMapper)this.dao).selectByExample(example);
        }
        return Collections.emptyList();
    }
}

