/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.dao.CompanyBaseChangeInfoMapper;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.CompanyBaseChangeInfoAddParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseChangeInfo;
import cn.smarthse.modules.datacentre.service.ICompanyBaseChangeInfoService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
@Transactional(readOnly=true)
public class CompanyBaseChangeInfoServiceImpl
extends ZYJBaseServiceImpl<CompanyBaseChangeInfoMapper, CompanyBaseChangeInfo>
implements ICompanyBaseChangeInfoService {
    private static final int BATCH_SIZE = 2000;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Override
    @Transactional
    public void batchAddChangeInfo(List<CompanyBaseChangeInfoAddParam> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        Date date = new Date();
        int year = LocalDate.now().getYear();
        ArrayList<CompanyBaseChangeInfo> rst = new ArrayList<CompanyBaseChangeInfo>(list.size());
        for (CompanyBaseChangeInfoAddParam param : list) {
            CompanyBaseChangeInfo entity = new CompanyBaseChangeInfo();
            entity.setId(Long.valueOf(IdWorker.getId()));
            entity.setCid(param.getCid());
            entity.setBeforeValue(param.getBeforeValue());
            entity.setBeforeValue2(param.getBeforeValue2());
            entity.setAfterValue(param.getAfterValue());
            entity.setAfterValue2(param.getAfterValue2());
            entity.setChangeType(param.getChangeType());
            entity.setChangeTime(param.getChangeTime());
            entity.setChangeYear(param.getChangeYear());
            entity.setCreateBy(param.getCreateBy());
            entity.setUpdateBy(param.getUpdateBy());
            if (entity.getChangeTime() == null) {
                entity.setChangeTime(date);
            }
            if (entity.getChangeYear() == null) {
                entity.setChangeYear(Integer.valueOf(year));
            }
            if (param.getCreateDate() == null) {
                entity.setCreateDate(date);
            }
            if (param.getUpdateDate() == null) {
                entity.setUpdateDate(date);
            }
            rst.add(entity);
        }
        this.batchUpdateOrInsert(rst, CompanyBaseChangeInfoMapper.class, (s, mapper) -> mapper.insertSelective(s));
    }

    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        return this.batchUpdateOrInsert(data, mapperClass, function, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function, int batchSize) {
        int i = 1;
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                R r = function.apply(element, mapper);
                if (i % batchSize == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }
}

