/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.dao.DesensitizationFieldMapper;
import cn.smarthse.modules.sys.entity.DesensitizationField;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DesensitizationFieldService {
    @Value(value="${desensitization_show_online_or_offline_env:dev}")
    private String desensitizationShowOnlineOrOfflineEnv;
    private final DesensitizationFieldMapper desensitizationFieldMapper;
    private final DataSource dataSource;

    public String executeSafeQuery(String code, Long id, UserSystemWideEnum wideEnum) {
        if (StrUtil.isBlank((CharSequence)code)) {
            throw new HealthException("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(id)) {
            throw new HealthException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(wideEnum)) {
            throw new HealthException("UserSystemWideEnum\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DesensitizationField field = this.desensitizationFieldMapper.getByCodeAndSystemWide(code, wideEnum.getCode());
        if (Objects.isNull(field)) {
            throw new HealthException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f: " + code);
        }
        String sqlTemplate = "pro".equalsIgnoreCase(this.desensitizationShowOnlineOrOfflineEnv) ? field.getSqlOnline() : field.getSqlOffline();
        try {
            this.validateSqlTemplate(sqlTemplate, field);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            List<Map<String, Object>> rstList = this.executeParameterizedQuery(sqlTemplate, params);
            if (CollUtil.isEmpty(rstList)) {
                return null;
            }
            if (rstList.size() != 1) {
                throw new HealthException("\u6839\u636e\u6a21\u677f\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38");
            }
            Object o = rstList.get(0).get(field.getOriginalFieldName());
            if (Objects.isNull(o)) {
                return null;
            }
            return SpringEncryptUtils.decrypt((String)o.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateSqlTemplate(String sqlTemplate, DesensitizationField field) {
        String lowerCaseSql = sqlTemplate.toLowerCase();
        String dangerousKeywords = "\\b(drop|truncate|delete|update|insert|create|alter|execute)\\b";
        if (Pattern.compile(dangerousKeywords).matcher(lowerCaseSql).find()) {
            throw new HealthException("\u6a21\u677f\u5305\u542b\u5371\u9669\u64cd\u4f5c");
        }
        if (!lowerCaseSql.contains(":id")) {
            throw new HealthException("\u53ea\u652f\u6301\u6839\u636eid\u67e5\u8be2\uff08:id\uff09");
        }
        if (!lowerCaseSql.contains("." + field.getOriginalTableName().toLowerCase() + " ")) {
            throw new HealthException("\u6a21\u677f\u672a\u67e5\u8be2\u6307\u5b9a\u7684\u539f\u59cb\u8868\u540d");
        }
        if (!lowerCaseSql.contains(" " + field.getOriginalFieldName().toLowerCase() + " ")) {
            throw new HealthException("\u6a21\u677f\u672a\u67e5\u8be2\u6307\u5b9a\u7684\u539f\u59cb\u5b57\u6bb5\u540d");
        }
        if (this.countOccurrences(sqlTemplate, "'") % 2 != 0) {
            throw new SecurityException("\u6a21\u677f\u5305\u542b\u672a\u95ed\u5408\u7684\u5f15\u53f7");
        }
    }

    private List<Map<String, Object>> executeParameterizedQuery(String sqlTemplate, Map<String, Object> params) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<String> paramNames = this.parseParameterNames(sqlTemplate);
        if (params != null && !params.isEmpty() && params.size() != paramNames.size()) {
            throw new IllegalArgumentException("\u53c2\u6570\u6570\u91cf\u4e0d\u5339\u914d\uff0cSQL\u9700\u8981 " + paramNames.size() + " \u4e2a\u53c2\u6570\uff0c\u4f46\u63d0\u4f9b\u4e86 " + params.size() + " \u4e2a");
        }
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = this.prepareStatement(conn, sqlTemplate, params, paramNames);
             ResultSet rs = pstmt.executeQuery();){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    row.put(metaData.getColumnName(i), rs.getObject(i));
                }
                result.add(row);
            }
        }
        return result;
    }

    private PreparedStatement prepareStatement(Connection conn, String sqlTemplate, Map<String, Object> params, List<String> paramNames) throws SQLException {
        String preparedSql = sqlTemplate;
        for (String paramName : paramNames) {
            preparedSql = preparedSql.replace(":" + paramName, "?");
        }
        PreparedStatement pstmt = conn.prepareStatement(preparedSql);
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < paramNames.size(); ++i) {
                String paramName = paramNames.get(i);
                Object value = params.get(paramName);
                if (value == null) {
                    pstmt.setNull(i + 1, 0);
                    continue;
                }
                if (value instanceof String) {
                    pstmt.setString(i + 1, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    pstmt.setLong(i + 1, (Long)value);
                    continue;
                }
                if (value instanceof Date) {
                    pstmt.setTimestamp(i + 1, new Timestamp(((Date)value).getTime()));
                    continue;
                }
                pstmt.setObject(i + 1, value);
            }
        }
        return pstmt;
    }

    private List<String> parseParameterNames(String sql) {
        ArrayList<String> paramNames = new ArrayList<String>();
        int pos = 0;
        while ((pos = sql.indexOf(58, pos)) >= 0) {
            int end;
            if (pos > 0 && sql.charAt(pos - 1) == '\\') {
                ++pos;
                continue;
            }
            for (end = pos + 1; end < sql.length() && Character.isJavaIdentifierPart(sql.charAt(end)); ++end) {
            }
            if (end > pos + 1) {
                paramNames.add(sql.substring(pos + 1, end));
                pos = end;
                continue;
            }
            ++pos;
        }
        return paramNames;
    }

    private int countOccurrences(String str, String subStr) {
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(subStr, pos)) != -1) {
            ++count;
            pos += subStr.length();
        }
        return count;
    }

    @Generated
    public DesensitizationFieldService(DesensitizationFieldMapper desensitizationFieldMapper, DataSource dataSource) {
        this.desensitizationFieldMapper = desensitizationFieldMapper;
        this.dataSource = dataSource;
    }
}

