/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.zlb;

import cn.smarthse.modules.datacentre.model.zlb.LegalPersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.PersonInfo;
import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;
import cn.smarthse.modules.datacentre.provider.zlb.IZlbUserInfoProviderService;
import cn.smarthse.modules.datacentre.service.zlb.IZlbLegalPersonInfoService;
import cn.smarthse.modules.datacentre.service.zlb.IZlbPersonInfoService;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class ZlbUserInfoProviderServiceImpl
implements IZlbUserInfoProviderService {
    private final IZlbPersonInfoService zlbPersonInfoService;
    private final IZlbLegalPersonInfoService legalPersonInfoService;
    private static final String PERSON = "PERSON";
    private static final String LEGAL_PERSON = "LEGAL_PERSON";

    public ZlbUserInfo getUserInfo(String zlbUserId, String userType) {
        if (PERSON.equals(userType)) {
            ZlbUserInfo zlbUserInfo = this.getPersonInfo(zlbUserId);
            return zlbUserInfo != null ? zlbUserInfo : this.getLegalPersonInfo(zlbUserId);
        }
        if (LEGAL_PERSON.equals(userType)) {
            ZlbUserInfo zlbUserInfo = this.getLegalPersonInfo(zlbUserId);
            return zlbUserInfo != null ? zlbUserInfo : this.getPersonInfo(zlbUserId);
        }
        return null;
    }

    public void saveZlbUserInfo(ZlbUserInfo zlbUserInfo) {
        if (zlbUserInfo == null) {
            return;
        }
        if (!LEGAL_PERSON.equals(zlbUserInfo.getUserType()) && zlbUserInfo.getPersonInfo() != null) {
            this.zlbPersonInfoService.save(zlbUserInfo.getPersonInfo());
        } else if (zlbUserInfo.getLegalPersonInfo() != null) {
            this.legalPersonInfoService.save(zlbUserInfo.getLegalPersonInfo());
        }
    }

    private ZlbUserInfo getPersonInfo(String zlbUserId) {
        PersonInfo personInfo = this.zlbPersonInfoService.getByZlbUserId(zlbUserId);
        if (personInfo == null) {
            return null;
        }
        ZlbUserInfo zlbUserInfo = new ZlbUserInfo();
        zlbUserInfo.setUserType(PERSON);
        zlbUserInfo.setUserId(personInfo.getUserId());
        zlbUserInfo.setInnerUserId(personInfo.getUserId());
        zlbUserInfo.setPersonInfo(personInfo);
        return zlbUserInfo;
    }

    private ZlbUserInfo getLegalPersonInfo(String zlbUserId) {
        LegalPersonInfo legalPersonInfo = this.legalPersonInfoService.getByZlbUserId(zlbUserId);
        if (legalPersonInfo == null) {
            return null;
        }
        ZlbUserInfo zlbUserInfo = new ZlbUserInfo();
        zlbUserInfo.setUserType(LEGAL_PERSON);
        zlbUserInfo.setUserId(legalPersonInfo.getCorpId());
        zlbUserInfo.setInnerUserId(legalPersonInfo.getCorpId());
        zlbUserInfo.setLegalPersonInfo(legalPersonInfo);
        return zlbUserInfo;
    }

    @Generated
    public ZlbUserInfoProviderServiceImpl(IZlbPersonInfoService zlbPersonInfoService, IZlbLegalPersonInfoService legalPersonInfoService) {
        this.zlbPersonInfoService = zlbPersonInfoService;
        this.legalPersonInfoService = legalPersonInfoService;
    }
}

