/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.system.riskFactors;

import cn.smarthse.modules.datacentre.dao.system.riskFactors.OccupationalRiskFactorsByPlatformMapper;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmSeachModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoSeachModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class RiskFactorsProvideByPlatformServiceImpl
implements IRiskFactorsProvideByPlatformService {
    @Autowired
    private OccupationalRiskFactorsByPlatformMapper dao;

    public PageInfo<HarmModel> getHazardListByHXFC(HarmSeachModel seach) {
        PageHelper.startPage((int)seach.getPage(), (int)seach.getPageSize());
        List<HarmModel> list = this.dao.selectHazardListByHXFC(seach.getKeyword(), seach.getInitials());
        PageInfo info = new PageInfo(list);
        return info;
    }

    public List<HarmModel> getListByType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new ServiceException("\u7c7b\u578b\u4e3a\u7a7a!");
        }
        return this.dao.selectListByType(type);
    }

    public List<HarmModel> getListByInitials(String initials, String type, String keyword) {
        return this.dao.selectListByInitials(initials, type, keyword);
    }

    public HarmModel getModelById(Long id) {
        if (id == null) {
            throw new ServiceException("id\u4e3a\u7a7a!");
        }
        return this.dao.selectModelById(id);
    }

    public HarmInfoModel getHarmInfoById(HarmInfoSeachModel model) {
        if (model == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)model.getHxMac())) {
            model.setHxMac("null");
        }
        if (StringUtils.isEmpty((CharSequence)model.getHxTwa())) {
            model.setHxTwa("null");
        }
        if (StringUtils.isEmpty((CharSequence)model.getHxStel())) {
            model.setHxStel("null");
        }
        if (StringUtils.isEmpty((CharSequence)model.getFcTwaTotal())) {
            model.setFcTwaTotal("null");
        }
        if (StringUtils.isEmpty((CharSequence)model.getFcTwaRespirabel())) {
            model.setFcTwaRespirabel("null");
        }
        return this.dao.selectHarmInfoById(model);
    }

    public List<HarmModel> getListByGBZ(String type, String keyword) {
        return this.dao.selectListByGBZ(type, keyword);
    }
}

