/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.system.riskFactors;

import cn.smarthse.modules.datacentre.entity.system.riskFactors.OccupationalRiskFactors;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.RiskFactorSearchModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskFactorsModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformAdminService;
import cn.smarthse.modules.datacentre.service.system.riskFactors.IOccupationalRiskFactorsService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class RiskFactorsProvideByPlatformAdminServiceImpl
implements IRiskFactorsProvideByPlatformAdminService {
    @Autowired
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;

    public List<OccupationalRiskFactorsModel> getRiskFactorsList(RiskFactorSearchModel param) {
        List<OccupationalRiskFactorsModel> list = this.occupationalRiskFactorsService.getRiskFactorsList(param);
        return list;
    }

    public PageInfo<OccupationalRiskFactorsModel> getRiskFactorsListData(RiskFactorSearchModel param) {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<OccupationalRiskFactorsModel> list = this.getRiskFactorsList(param);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public OccupationalRiskFactorsModel getRiskFactors(Long id) {
        OccupationalRiskFactorsModel record = this.occupationalRiskFactorsService.getRiskFactors(id);
        return record;
    }

    @Transactional(readOnly=false)
    public void addRiskFactors(OccupationalRiskFactorsModel occupationalRiskFactorsModel, Long adminId) {
        if (occupationalRiskFactorsModel == null || StringUtils.isEmpty((CharSequence)occupationalRiskFactorsModel.getType())) {
            throw new ServiceException("\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)occupationalRiskFactorsModel.getNameCh())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)occupationalRiskFactorsModel.getParamCode())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (this.occupationalRiskFactorsService.isExistParamCode(occupationalRiskFactorsModel.getParamCode())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (occupationalRiskFactorsModel.getResource() == null) {
            throw new ServiceException("\u6765\u6e90\u4e3a\u7a7a\uff01");
        }
        OccupationalRiskFactors record = new OccupationalRiskFactors();
        record.setType(occupationalRiskFactorsModel.getType());
        record.setNameCh(occupationalRiskFactorsModel.getNameCh());
        record.setParamCode(occupationalRiskFactorsModel.getParamCode());
        record.setParamCode(occupationalRiskFactorsModel.getParamCode());
        record.setAlias(occupationalRiskFactorsModel.getAlias());
        record.setCasno(occupationalRiskFactorsModel.getCasno());
        record.setRemarks(occupationalRiskFactorsModel.getRemarks());
        record.setIsHt(occupationalRiskFactorsModel.getIsHt());
        record.setIsHasRespirableDust(occupationalRiskFactorsModel.getIsHasRespirableDust());
        record.setOccupationalHealthId(occupationalRiskFactorsModel.getOccupationalHealthId());
        record.setOccupationalContraindication(occupationalRiskFactorsModel.getOccupationalContraindication());
        record.setOccupationalDisease(occupationalRiskFactorsModel.getOccupationalDisease());
        record.setBasisOccupationalHealth(occupationalRiskFactorsModel.getBasisOccupationalHealth());
        record.setWarningSignsRecommend(occupationalRiskFactorsModel.getWarningSignsRecommend());
        record.setUpdateDate(occupationalRiskFactorsModel.getUpdateDate());
        record.setUpdateBy(occupationalRiskFactorsModel.getUpdateBy());
        record.setBlendName(occupationalRiskFactorsModel.getBlendName());
        record.setBlendRemark(occupationalRiskFactorsModel.getBlendRemark());
        record.setBelongCatalog(occupationalRiskFactorsModel.getBelongCatalog());
        record.setCatalogName(occupationalRiskFactorsModel.getCatalogName());
        record.setBelongGbz22007(occupationalRiskFactorsModel.getBelongGbz22007());
        record.setGbz22007Name(occupationalRiskFactorsModel.getGbz22007Name());
        record.setBelongGbz188(occupationalRiskFactorsModel.getBelongGbz188());
        record.setGbz1882014(occupationalRiskFactorsModel.getGbz1882014());
        record.setBelongGbz22019(occupationalRiskFactorsModel.getBelongGbz22019());
        record.setGbz22019Name(occupationalRiskFactorsModel.getGbz22019Name());
        this.occupationalRiskFactorsService.add(record, adminId);
    }

    @Transactional(readOnly=false)
    public void saveRiskFactors(OccupationalRiskFactorsModel occupationalRiskFactorsModel, Long adminId) {
        if (occupationalRiskFactorsModel == null || occupationalRiskFactorsModel.getId() == null) {
            throw new ServiceException("id\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)occupationalRiskFactorsModel.getNameCh())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)occupationalRiskFactorsModel.getParamCode())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        OccupationalRiskFactors exitRiskFactors = this.occupationalRiskFactorsService.getByParamCode(occupationalRiskFactorsModel.getParamCode());
        if (exitRiskFactors != null && !exitRiskFactors.getId().equals(occupationalRiskFactorsModel.getId())) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (occupationalRiskFactorsModel.getResource() == null) {
            throw new ServiceException("\u6765\u6e90\u4e3a\u7a7a\uff01");
        }
        OccupationalRiskFactors record = new OccupationalRiskFactors();
        record.setId(occupationalRiskFactorsModel.getId());
        record.setType(occupationalRiskFactorsModel.getType());
        record.setNameCh(occupationalRiskFactorsModel.getNameCh());
        record.setParamCode(occupationalRiskFactorsModel.getParamCode());
        record.setParamCode(occupationalRiskFactorsModel.getParamCode());
        record.setAlias(occupationalRiskFactorsModel.getAlias());
        record.setCasno(occupationalRiskFactorsModel.getCasno());
        record.setRemarks(occupationalRiskFactorsModel.getRemarks());
        record.setIsHt(occupationalRiskFactorsModel.getIsHt());
        record.setIsHasRespirableDust(occupationalRiskFactorsModel.getIsHasRespirableDust());
        record.setOccupationalHealthId(occupationalRiskFactorsModel.getOccupationalHealthId());
        record.setOccupationalContraindication(occupationalRiskFactorsModel.getOccupationalContraindication());
        record.setOccupationalDisease(occupationalRiskFactorsModel.getOccupationalDisease());
        record.setBasisOccupationalHealth(occupationalRiskFactorsModel.getBasisOccupationalHealth());
        record.setWarningSignsRecommend(occupationalRiskFactorsModel.getWarningSignsRecommend());
        record.setUpdateDate(occupationalRiskFactorsModel.getUpdateDate());
        record.setUpdateBy(occupationalRiskFactorsModel.getUpdateBy());
        record.setBlendName(occupationalRiskFactorsModel.getBlendName());
        record.setBlendRemark(occupationalRiskFactorsModel.getBlendRemark());
        record.setBelongCatalog(occupationalRiskFactorsModel.getBelongCatalog());
        record.setCatalogName(occupationalRiskFactorsModel.getCatalogName());
        record.setBelongGbz22007(occupationalRiskFactorsModel.getBelongGbz22007());
        record.setGbz22007Name(occupationalRiskFactorsModel.getGbz22007Name());
        record.setBelongGbz188(occupationalRiskFactorsModel.getBelongGbz188());
        record.setGbz1882014(occupationalRiskFactorsModel.getGbz1882014());
        record.setBelongGbz22019(occupationalRiskFactorsModel.getBelongGbz22019());
        record.setGbz22019Name(occupationalRiskFactorsModel.getGbz22019Name());
        this.occupationalRiskFactorsService.update(record, adminId);
    }

    @Transactional(readOnly=false)
    public void delRiskFactors(Long id, Long adminId) {
        if (id == null) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20id\u4e3a\u7a7a\uff01");
        }
        OccupationalRiskFactors record = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(id);
        if (record == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u5371\u5bb3\u56e0\u7d20\uff01");
        }
        record.setIsValid(false);
        this.occupationalRiskFactorsService.update(record, adminId);
    }

    @Transactional(readOnly=false)
    public void saveIsShowRiskFactors(Long id, Boolean isShow, Long adminId) {
        if (id == null) {
            throw new ServiceException("\u5371\u5bb3\u56e0\u7d20id\u4e3a\u7a7a\uff01");
        }
        OccupationalRiskFactors record = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(id);
        if (record == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u5371\u5bb3\u56e0\u7d20\uff01");
        }
        record.setIsShow(isShow);
        this.occupationalRiskFactorsService.update(record, adminId);
    }

    @Transactional(readOnly=false)
    public void updatePy(OccupationalRiskFactorsModel record) {
        OccupationalRiskFactors occupationalRiskFactors = new OccupationalRiskFactors();
        occupationalRiskFactors.setId(record.getId());
        occupationalRiskFactors.setFullPy(record.getFullPy());
        occupationalRiskFactors.setPy(record.getPy());
        this.occupationalRiskFactorsService.update(occupationalRiskFactors);
    }
}

