/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms.welink.httpclient;

import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpRequest;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpResponse;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.IHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ProxyHttpClient
implements IHttpClient {
    private HttpHost proxy;

    public ProxyHttpClient(String host) {
        this.proxy = new HttpHost(host);
    }

    public ProxyHttpClient(String host, int port) {
        this.proxy = new HttpHost(host, port);
    }

    public ProxyHttpClient(String host, int port, String scheme) {
        this.proxy = new HttpHost(host, port, scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse fetch(HttpRequest request) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(request.url);
        for (Map.Entry<String, String> entry : request.parameters.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(request.connectTimeout).setConnectionRequestTimeout(request.requestTimeout).setProxy(this.proxy).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.method.name()).setUri(uriBuilder.build()).setEntity((HttpEntity)new ByteArrayEntity(request.body.getBytes(request.bodyCharset))).setConfig(requestConfig);
        for (Map.Entry<String, String> entry : request.headers.entrySet()) {
            requestBuilder.setHeader(entry.getKey(), entry.getValue());
        }
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpResponse httpResponse;
            CloseableHttpResponse response = client.execute(requestBuilder.build());
            try {
                HttpResponse res = new HttpResponse().setRequest(request).setStatusCode(response.getStatusLine().getStatusCode()).setReason(response.getStatusLine().getReasonPhrase()).setBody(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
                for (Header header : response.getAllHeaders()) {
                    res.addHeader(header.getName(), header.getName());
                }
                httpResponse = res;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return httpResponse;
        }
    }

    @Override
    public void close() {
    }
}

