/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms.welink;

import cn.smarthse.common.util.date.TimeUtil;
import cn.smarthse.modules.datacentre.dao.system.DelayedSmsMapper;
import cn.smarthse.modules.datacentre.dao.system.MasSmsRecordMapper;
import cn.smarthse.modules.datacentre.model.sms.DelayedSms;
import cn.smarthse.modules.datacentre.model.sms.WelinkSMSContent;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.datacentre.provider.sms.welink.SendSmsResult;
import cn.smarthse.modules.datacentre.provider.sms.welink.SendSmsSender;
import cn.smarthse.modules.datacentre.util.StringUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class SmsProviderWelinkServiceImpl
implements ISMSProviderWelinkService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsProviderWelinkServiceImpl.class);
    @Autowired
    SendSmsSender sendSmsSender;
    @Autowired
    MasSmsRecordMapper smsRecordMapper;
    @Autowired
    private DelayedSmsMapper delayedSmsMapper;
    private static final Long MAX_SENDCOUNT = 50L;

    public void singleSendSms(String phoneNo, String content, Long bussId) {
        if (StringUtils.isEmpty((String)phoneNo)) {
            return;
        }
        WelinkSMSContent welinkSMSContent = new WelinkSMSContent();
        welinkSMSContent.setPhoneNos(Arrays.asList(phoneNo));
        welinkSMSContent.setMsgContent(content);
        welinkSMSContent.setBussId(bussId);
        Long sendCount = this.smsRecordMapper.countOnedaySmsByMobile(phoneNo, LocalDate.now());
        if (sendCount != null && sendCount >= MAX_SENDCOUNT) {
            SendSmsResult result = new SendSmsResult();
            result.setResult("error");
            result.setReason("\u5f53\u65e5\u77ed\u4fe1\u53d1\u9001\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236");
            result.setMsgId(0L);
            result.setBussId(bussId);
            this.sendSmsSender.addLogProcess(welinkSMSContent, null, result);
            return;
        }
        this.sendSmsSender.send(welinkSMSContent);
    }

    public void singleSendSms(String phoneNo, String content) {
        this.singleSendSms(phoneNo, content, null);
    }

    public void mutilSendSms(List<String> phoneNos, String content) {
        WelinkSMSContent welinkSMSContent = new WelinkSMSContent();
        welinkSMSContent.setPhoneNos(phoneNos);
        welinkSMSContent.setMsgContent(content);
        this.sendSmsSender.send(welinkSMSContent);
    }

    public void sendOrDelaySms(Map<String, String> contentMap, LocalTime start, LocalTime end, Byte workdayOnly) {
        for (Map.Entry<String, String> entry : contentMap.entrySet()) {
            String mobile = entry.getKey();
            String content = entry.getValue();
            try {
                if (TimeUtil.isWithinAllowedTime((LocalTime)start, (LocalTime)end)) {
                    log.info("\u77ed\u4fe1\u7acb\u5373\u53d1\u9001 -> \u624b\u673a\u53f7\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)mobile, (Object)content);
                    this.singleSendSms(mobile, content);
                    continue;
                }
                DelayedSms delayedSms = new DelayedSms();
                delayedSms.setMobile(mobile);
                delayedSms.setContent(content);
                delayedSms.setStatus(0);
                delayedSms.setCreateDate(LocalDateTime.now());
                delayedSms.setAllowedStartTime(start.toString());
                delayedSms.setAllowedEndTime(end.toString());
                delayedSms.setSmsType((byte)2);
                delayedSms.setWorkdayOnly(workdayOnly);
                this.delayedSmsMapper.insert(delayedSms);
                log.info("\u77ed\u4fe1\u5ef6\u8fdf\u5165\u5e93 -> \u624b\u673a\u53f7\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)mobile, (Object)content);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u5ef6\u8fdf\u77ed\u4fe1\u5931\u8d25, mobile={}, error={}", new Object[]{mobile, e.getMessage(), e});
            }
        }
    }

    public Byte getMessageStatus(Long bussId) {
        return this.smsRecordMapper.getByPhoneAndTemplate(bussId);
    }
}

