/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms.welink;

import cn.smarthse.modules.datacentre.dao.system.MasSmsRecordMapper;
import cn.smarthse.modules.datacentre.model.sms.MasSmsRecord;
import cn.smarthse.modules.datacentre.model.sms.WelinkSMSContent;
import cn.smarthse.modules.datacentre.provider.sms.welink.BaseSendSmsSender;
import cn.smarthse.modules.datacentre.provider.sms.welink.SendSmsResult;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpException;
import cn.smarthse.modules.datacentre.provider.sms.welink.utils.SmsSenderUtil;
import com.alibaba.fastjson2.JSONException;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendSmsSender
extends BaseSendSmsSender {
    @Autowired
    private MasSmsRecordMapper recordMapper;

    @Override
    public String smsUrlMethod() {
        return "EncryptionSubmit/SendSms.ashx";
    }

    @Override
    public Map<String, Object> requestBody(String ExtendNo, List<String> PhoneNos, String Content, String OutId) throws HttpException, JSONException, IOException {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        long Random2 = SmsSenderUtil.getRandom();
        long Timestamp2 = SmsSenderUtil.getCurrentTime();
        body.put("AccountId", this.welinkProperties.getAccountId());
        body.put("ExtendNo", SmsSenderUtil.isNotEmpty(ExtendNo) ? ExtendNo : "");
        if (PhoneNos.size() > 1) {
            body.put("ProductId", SmsSenderUtil.isNotEmpty(this.welinkProperties.getMutilProductId()) ? this.welinkProperties.getMutilProductId() : "");
        } else {
            body.put("ProductId", SmsSenderUtil.isNotEmpty(this.welinkProperties.getProductId()) ? this.welinkProperties.getProductId() : "");
        }
        body.put("PhoneNos", String.join((CharSequence)",", PhoneNos));
        body.put("Content", SmsSenderUtil.isNotEmpty(Content) ? Content : "");
        body.put("AccessKey", SmsSenderUtil.calcSendSmsSign(this.welinkProperties.getAccountId(), PhoneNos.get(0), this.welinkProperties.getAccessKey(), Random2, Timestamp2));
        body.put("Timestamp", Timestamp2);
        body.put("Random", Random2);
        body.put("OutId", SmsSenderUtil.isNotEmpty(OutId) ? OutId : "");
        body.put("SendTime", "");
        return body;
    }

    @Override
    public void addLogProcess(WelinkSMSContent welinkSMSContent, String OutId, SendSmsResult sendSmsResult) {
        List masSmsRecordStream = welinkSMSContent.getPhoneNos().stream().map(mobile -> {
            MasSmsRecord record = new MasSmsRecord();
            record.setCreateDate(new Date());
            record.setUpdateDate(new Date());
            record.setContent(welinkSMSContent.getMsgContent());
            record.setIsValid(true);
            record.setIsSucceed("succ".equals(sendSmsResult.getResult()));
            record.setRecords(sendSmsResult.getReason());
            record.setMobile((String)mobile);
            record.setId(this.idWorker.nextId());
            record.setSmsType(2);
            record.setOutId(OutId);
            record.setMsgId(sendSmsResult.getMsgId());
            record.setBussId(welinkSMSContent.getBussId());
            return record;
        }).collect(Collectors.toList());
        this.recordMapper.insertList2(masSmsRecordStream);
    }
}

