/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms.welink;

import cn.smarthse.modules.datacentre.dao.system.MasSmsRecordMapper;
import cn.smarthse.modules.datacentre.model.sms.MasSmsRecord;
import cn.smarthse.modules.datacentre.model.sms.WelinkSMSContent;
import cn.smarthse.modules.datacentre.provider.sms.welink.BaseSendSmsSender;
import cn.smarthse.modules.datacentre.provider.sms.welink.SendSmsResult;
import cn.smarthse.modules.datacentre.provider.sms.welink.WeLinkMutilSmsContent;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpException;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpMethod;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpRequest;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpResponse;
import cn.smarthse.modules.datacentre.provider.sms.welink.utils.SmsSenderUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONException;
import io.micrometer.common.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendMultiSmsSender
extends BaseSendSmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SendMultiSmsSender.class);
    @Autowired
    private MasSmsRecordMapper recordMapper;

    @Override
    protected String smsUrlMethod() {
        return "EncryptionSubmit/SendSpecialSms.ashx";
    }

    @Override
    protected Map<String, Object> requestBody(String ExtendNo, List<String> PhoneNos, String Content, String OutId) throws HttpException, JSONException, IOException {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        long random = SmsSenderUtil.getRandom();
        long timestamp = SmsSenderUtil.getCurrentTime();
        body.put("AccountId", this.welinkProperties.getAccountId());
        body.put("AccessKey", SmsSenderUtil.calcMutilSmsSign(this.welinkProperties.getAccountId(), this.welinkProperties.getAccessKey(), random, timestamp));
        body.put("Timestamp", timestamp);
        body.put("Random", random);
        body.put("ProductId", SmsSenderUtil.isNotEmpty(this.welinkProperties.getProductId()) ? this.welinkProperties.getProductId() : "");
        body.put("OutId", "");
        body.put("Content", Content);
        return body;
    }

    @Override
    public SendSmsResult send(WelinkSMSContent welinkSMSContent) {
        throw new ServiceException("\u6682\u4e0d\u652f\u6301\u64cd\u4f5c");
    }

    public SendSmsResult mutilSend(List<WelinkSMSContent> mutilContent1) {
        if (CollectionUtils.isEmpty(mutilContent1)) {
            return null;
        }
        if (mutilContent1.size() > 9999) {
            throw new ServiceException("\u77ed\u4fe1\u6761\u6570\u8d85\u9650");
        }
        List<WeLinkMutilSmsContent> mutilContent = mutilContent1.stream().filter(f -> StringUtils.isNotBlank((String)f.getMsgContent()) && CollectionUtils.isNotEmpty((Collection)f.getPhoneNos())).map(mobile -> {
            WeLinkMutilSmsContent content = new WeLinkMutilSmsContent();
            BeanUtils.copyProperties((Object)mobile, (Object)((Object)content));
            content.setOutId(String.valueOf(this.idWorker.nextId()));
            return content;
        }).collect(Collectors.toList());
        Map<String, Object> body = null;
        try {
            body = this.requestBody(null, null, JSON.toJSONString(mutilContent), null);
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u77ed\u4fe1\u5185\u5bb9\u51fa\u9519:", (Throwable)e);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.getUrl()).addHeader("Content-Type", "application/json").setConnectTimeout(60000).setRequestTimeout(60000).setBody(JSON.toJSONString(body));
        SendSmsResult sendSmsResult = null;
        try {
            HttpResponse response = this.httpClient.fetch(request);
            this.handleError(response);
            sendSmsResult = new SendSmsResult().parseFromHttpResponse(response);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u51fa\u9519:", (Throwable)e);
        }
        this.postSendProcess(mutilContent, sendSmsResult);
        return sendSmsResult;
    }

    public void postSendProcess(List<WeLinkMutilSmsContent> mutilContent, SendSmsResult sendSmsResult) {
        List masSmsRecordStream = mutilContent.stream().map(mobile -> {
            MasSmsRecord record = new MasSmsRecord();
            record.setCreateDate(new Date());
            record.setUpdateDate(new Date());
            record.setContent(mobile.getMsgContent());
            record.setIsValid(true);
            record.setIsSucceed("succ".equals(sendSmsResult.getResult()));
            record.setRecords(sendSmsResult.getReason());
            record.setMobile((String)mobile.getPhoneNos().get(0));
            record.setId(this.idWorker.nextId());
            record.setSmsType(2);
            record.setOutId(mobile.getOutId());
            record.setMsgId(sendSmsResult.getMsgId());
            return record;
        }).collect(Collectors.toList());
        this.recordMapper.insertList2(masSmsRecordStream);
    }
}

