/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms.welink;

import cn.smarthse.modules.datacentre.bootstrap.properties.sms.WelinkProperties;
import cn.smarthse.modules.datacentre.model.sms.WelinkSMSContent;
import cn.smarthse.modules.datacentre.provider.sms.welink.SendSmsResult;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.DefaultHttpClient;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpException;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpMethod;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpRequest;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.HttpResponse;
import cn.smarthse.modules.datacentre.provider.sms.welink.httpclient.IHttpClient;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseSendSmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseSendSmsSender.class);
    @Autowired
    protected WelinkProperties welinkProperties;
    @Autowired
    protected IdWorker idWorker;
    protected IHttpClient httpClient = new DefaultHttpClient();

    protected abstract String smsUrlMethod();

    protected abstract Map<String, Object> requestBody(String var1, List<String> var2, String var3, String var4) throws HttpException, JSONException, IOException;

    public HttpResponse handleError(HttpResponse response) throws HttpException {
        if (response.statusCode < 200 || response.statusCode >= 300) {
            throw new HttpException(response.statusCode, response.reason);
        }
        return response;
    }

    protected String getUrl() {
        Object baseNetAddrr = this.welinkProperties.getBaseNetAddrr();
        if (!((String)baseNetAddrr).endsWith("/")) {
            baseNetAddrr = (String)baseNetAddrr + "/";
        }
        String url = (String)baseNetAddrr + this.smsUrlMethod();
        return url;
    }

    public SendSmsResult send(WelinkSMSContent welinkSMSContent) {
        if (welinkSMSContent == null || CollectionUtils.isEmpty((Collection)welinkSMSContent.getPhoneNos())) {
            return null;
        }
        String OutId = String.valueOf(this.idWorker.nextId());
        Map<String, Object> body = null;
        try {
            body = this.requestBody("", welinkSMSContent.getPhoneNos(), welinkSMSContent.getMsgContent(), OutId);
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u77ed\u4fe1\u5185\u5bb9\u51fa\u9519:", (Throwable)e);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.getUrl()).addHeader("Content-Type", "application/json").setConnectTimeout(60000).setRequestTimeout(60000).setBody(JSON.toJSONString(body));
        SendSmsResult sendSmsResult = null;
        try {
            HttpResponse response = this.httpClient.fetch(request);
            this.handleError(response);
            sendSmsResult = new SendSmsResult().parseFromHttpResponse(response);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u51fa\u9519:", (Throwable)e);
        }
        this.addLogProcess(welinkSMSContent, OutId, sendSmsResult);
        return sendSmsResult;
    }

    public void addLogProcess(WelinkSMSContent welinkSMSContent, String OutId, SendSmsResult sendSmsResult) {
    }
}

