/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms;

import cn.smarthse.modules.datacentre.bootstrap.properties.SmtProperties;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class SmsProvideServiceImpl
implements ISMSProviderService {
    protected Logger logger = LogManager.getLogger(this.getClass());
    private final SmtProperties smtProperties;
    private final IAcsClient client;

    public String sendVcode(String vcode, String mobile) {
        return this.sendSms(mobile, vcode) ? "success" : "fail";
    }

    public String sendTextSms(String text, String mobile) {
        this.logger.debug("\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobile, (Object)text);
        String result = this.sendSingleSMS(mobile, text, null, null);
        this.logger.info("\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{},\u53d1\u9001\u7ed3\u679c:{}", (Object)mobile, (Object)text, (Object)result);
        return result;
    }

    public String batchSendTextSms(String text, String mobiles) {
        this.logger.debug("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobiles, (Object)text);
        String result = this.sendSingleSMS(mobiles.replace(",", ";"), text, null, null);
        this.logger.debug("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{},\u53d1\u9001\u7ed3\u679c:{}", (Object)mobiles, (Object)text, (Object)result);
        return result;
    }

    private boolean sendSms(String mobiles, String code) {
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mobiles);
        request.setSignName(this.smtProperties.getDysmsapi().getSignname());
        request.setTemplateCode(this.smtProperties.getDysmsapi().getTemplatecode());
        request.setTemplateParam(String.format("{\"code\": \"%s\"}", code));
        try {
            SendSmsResponse acsResponse = (SendSmsResponse)this.client.getAcsResponse((AcsRequest)request);
            boolean result = "OK".equalsIgnoreCase(acsResponse.getCode());
            if (!result) {
                this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1aRequestId\uff1a{}-ErrCode\uff1a{}- ErrMsg:{}", (Object)acsResponse.getRequestId(), (Object)acsResponse.getCode(), (Object)acsResponse.getMessage());
            }
            return result;
        }
        catch (ServerException e) {
            this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", (Throwable)e);
            return false;
        }
        catch (ClientException e) {
            this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1aRequestId\uff1a{}-ErrCode\uff1a{}- ErrMsg:{}", (Object)e.getRequestId(), (Object)e.getErrCode(), (Object)e.getErrMsg());
            return false;
        }
    }

    public String sendSingleSMS(String mobile, String text, String source_address, Long external_id) {
        String result = "";
        if (!((String)text).startsWith(this.smtProperties.getMSGSIGN())) {
            text = this.smtProperties.getMSGSIGN() + (String)text;
        }
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("un", this.smtProperties.getCORPID());
            paramMap.put("pw", this.smtProperties.getPWD());
            paramMap.put("da", mobile);
            paramMap.put("sm", URLEncoder.encode((String)text, "utf8"));
            paramMap.put("sa", source_address);
            paramMap.put("ex", external_id);
            paramMap.put("dc", 15);
            paramMap.put("rf", 2);
            paramMap.put("rd", 1);
            paramMap.put("tf", 3);
            result = SmsProvideServiceImpl.SendPOST(this.smtProperties.getURI_SEND_SMS(), paramMap);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String SendPOST(String url, Map<String, Object> paramMap) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            StringBuilder param = new StringBuilder();
            if (paramMap != null && paramMap.size() > 0) {
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                }
                param = new StringBuilder(param.substring(0, param.length() - 1));
            }
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    @Generated
    public SmsProvideServiceImpl(SmtProperties smtProperties, IAcsClient client) {
        this.smtProperties = smtProperties;
        this.client = client;
    }
}

