/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.util.date.TimeUtil;
import cn.smarthse.modules.datacentre.bootstrap.properties.MasSmsProperties;
import cn.smarthse.modules.datacentre.dao.system.DelayedSmsMapper;
import cn.smarthse.modules.datacentre.dao.system.MasSmsRecordMapper;
import cn.smarthse.modules.datacentre.model.sms.DelayedSms;
import cn.smarthse.modules.datacentre.model.sms.MasSmsRecord;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.util.QueueUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.gson.Gson;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SmsProvideMasServiceImpl
implements ISMSProvideMasService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsProvideMasServiceImpl.class);
    @Autowired
    private MasSmsProperties masSmsProperties;
    @Autowired
    private MasSmsRecordMapper recordMapper;
    @Autowired
    private DelayedSmsMapper delayedSmsMapper;
    private final Gson gson = new Gson();
    private final String queueName = "sendDelayedMoreSms";

    @Deprecated
    @PostConstruct
    public void processSmsTasks() {
        log.info("queueName: {} \u76d1\u542c\u4e2d......", (Object)"sendDelayedMoreSms");
        Executors.newSingleThreadExecutor().execute(() -> QueueUtils.subscribeBlockingQueue("sendDelayedMoreSms", consumer -> {
            log.info("queueName: {}, \u6536\u5230\u6570\u636e: {}", (Object)"sendDelayedMoreSms", consumer);
            CompletableFuture.runAsync(() -> {
                log.info("\u77ed\u4fe1\u53d1\u9001\u6570\u636e: {}", consumer);
                this.sendMoreSms((Map<String, String>)consumer);
            });
        }, true));
    }

    public String sendSms(String mobiles, String content) {
        if (StringUtils.isBlank((CharSequence)mobiles) || StringUtils.isBlank((CharSequence)content)) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("rspcod", "\u624b\u673a\u53f7\u6216\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a");
            response.put("success", false);
            return this.gson.toJson(response);
        }
        String netAddr = this.masSmsProperties.getNetAddr();
        String[] mobileArr = StringUtils.splitByWholeSeparator((String)mobiles, (String)",");
        if (mobileArr.length >= 5000) {
            throw new ServiceException("\u4e00\u6b21\u6027\u4e0d\u80fd\u8d85\u8fc75000\u4e2a");
        }
        String addSerial = "";
        String ecName = this.masSmsProperties.getEcName();
        String apId = this.masSmsProperties.getAppId();
        String appSecret = this.masSmsProperties.getAppSecret();
        String sign = this.masSmsProperties.getSign();
        StringBuilder sb = new StringBuilder("");
        sb.append(ecName);
        sb.append(apId);
        sb.append(appSecret);
        sb.append(mobiles);
        sb.append(content);
        sb.append(sign);
        sb.append(addSerial);
        String mac = MD5.create().digestHex(sb.toString(), "UTF-8");
        JSONObject params = new JSONObject();
        params.put("ecName", (Object)ecName);
        params.put("apId", (Object)apId);
        params.put("mobiles", (Object)mobiles);
        params.put("content", (Object)content);
        params.put("sign", (Object)sign);
        params.put("addSerial", (Object)addSerial);
        params.put("mac", (Object)mac);
        String jsonString = JSON.toJSONString((Object)params);
        String encode = Base64.encode((CharSequence)jsonString);
        String response = HttpUtil.post((String)(netAddr + "/norsubmit"), (String)encode);
        log.warn("\u77ed\u4fe1\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)response);
        this.record(mobiles, content, response);
        return response;
    }

    public void sendMoreSms(Map<String, String> contentMap) {
        if (MapUtil.isEmpty(contentMap)) {
            return;
        }
        String mobiles = StringUtils.join(new ArrayList<String>(contentMap.keySet()), (String)",");
        String content = JSON.toJSONString(contentMap);
        String netAddr = this.masSmsProperties.getNetAddr();
        String addSerial = "";
        String ecName = this.masSmsProperties.getEcName();
        String apId = this.masSmsProperties.getAppId();
        String appSecret = this.masSmsProperties.getAppSecret();
        String sign = this.masSmsProperties.getSign();
        StringBuilder sb = new StringBuilder("");
        sb.append(ecName);
        sb.append(apId);
        sb.append(appSecret);
        sb.append(mobiles);
        sb.append(content);
        sb.append(sign);
        sb.append(addSerial);
        String mac = MD5.create().digestHex(sb.toString(), "UTF-8");
        JSONObject params = new JSONObject();
        params.put("ecName", (Object)ecName);
        params.put("apId", (Object)apId);
        params.put("mobiles", (Object)mobiles);
        params.put("content", (Object)content);
        params.put("sign", (Object)sign);
        params.put("addSerial", (Object)addSerial);
        params.put("mac", (Object)mac);
        String jsonString = JSON.toJSONString((Object)params);
        String encode = Base64.encode((CharSequence)jsonString);
        String response = HttpUtil.post((String)(netAddr + "/norsubmit"), (String)encode);
        log.warn("\u591a\u5bf9\u591a\u77ed\u4fe1\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)response);
        this.record(mobiles, content, response);
    }

    @Transactional
    public void record(String mobiles, String content, String response) {
        try {
            String[] mobileArr = StringUtils.splitByWholeSeparator((String)mobiles, (String)",");
            Response responseData = (Response)this.gson.fromJson(response, Response.class);
            boolean success = responseData.isSuccess();
            Date now = new Date();
            HashSet uniqueRecords = new HashSet(Arrays.stream(mobileArr).map(mobile -> this.createMasSmsRecord((String)mobile, content, success, responseData.getRspcod(), now)).collect(Collectors.toSet()));
            this.recordMapper.insertList2(new ArrayList(uniqueRecords));
        }
        catch (Exception e) {
            log.error("\u624b\u673a\u53f7\u7801\uff1a{}, \u53d1\u9001\u65e5\u5fd7\uff1a{}", new Object[]{mobiles, response, e});
        }
    }

    private MasSmsRecord createMasSmsRecord(String mobile, String content, boolean success, String rspCod, Date now) {
        MasSmsRecord record = new MasSmsRecord();
        record.setCreateDate(now);
        record.setUpdateDate(now);
        record.setContent(content);
        record.setIsValid(true);
        record.setIsSucceed(success);
        record.setRecords(rspCod);
        record.setMobile(mobile);
        record.setId(IdWorker.getId());
        return record;
    }

    @Deprecated
    public void sendDelayedMoreSms(Map<String, String> contentMap, LocalTime start, LocalTime end) {
        if (MapUtil.isEmpty(contentMap)) {
            return;
        }
        long delay = this.calculateDelay(start, end);
        QueueUtils.addDelayedQueueObject("sendDelayedMoreSms", contentMap, delay);
    }

    public void sendOrDelaySms(Map<String, String> contentMap, LocalTime start, LocalTime end, Byte workdayOnly) {
        for (Map.Entry<String, String> entry : contentMap.entrySet()) {
            String mobile = entry.getKey();
            String content = entry.getValue();
            try {
                if (TimeUtil.isWithinAllowedTime((LocalTime)start, (LocalTime)end)) {
                    log.info("\u77ed\u4fe1\u7acb\u5373\u53d1\u9001 -> \u624b\u673a\u53f7\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)mobile, (Object)content);
                    this.sendSms(mobile, content);
                    continue;
                }
                DelayedSms delayedSms = new DelayedSms();
                delayedSms.setMobile(mobile);
                delayedSms.setContent(content);
                delayedSms.setStatus(0);
                delayedSms.setCreateDate(LocalDateTime.now());
                delayedSms.setAllowedStartTime(start.toString());
                delayedSms.setAllowedEndTime(end.toString());
                delayedSms.setSmsType((byte)1);
                delayedSms.setWorkdayOnly(workdayOnly);
                this.delayedSmsMapper.insert(delayedSms);
                log.info("\u77ed\u4fe1\u5ef6\u8fdf\u5165\u5e93 -> \u624b\u673a\u53f7\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)mobile, (Object)content);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u5ef6\u8fdf\u77ed\u4fe1\u5931\u8d25, mobile={}, error={}", new Object[]{mobile, e.getMessage(), e});
            }
        }
    }

    private long calculateDelay(LocalTime startOfBusiness, LocalTime endOfBusiness) {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
        if (now.toLocalTime().isAfter(startOfBusiness) && now.toLocalTime().isBefore(endOfBusiness)) {
            return 0L;
        }
        ZonedDateTime nextDayStartOfBusiness = now.toLocalDate().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).plusHours(9L);
        Duration delay = Duration.between(now, nextDayStartOfBusiness);
        return delay.toMillis();
    }

    static class Response {
        private String rspcod;
        private Boolean success;

        Response() {
        }

        public String getRspcod() {
            return this.rspcod;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

