/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms;

import cn.smarthse.modules.datacentre.bootstrap.properties.SmtDaHanProperties;
import cn.smarthse.modules.datacentre.model.sms.JSONHttpClient;
import cn.smarthse.modules.datacentre.model.sms.SmsDaHanRes;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderDaHanService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import com.alibaba.fastjson.JSON;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class SmsProvideDaHanServiceImpl
implements ISMSProviderDaHanService {
    protected Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private SmtDaHanProperties smtDaHanProperties;
    @Autowired
    ISMSProviderService smsProviderService;
    private final String dataCentreError = "-1";

    public String sendVcode(String vcode, String mobile, String subcode) {
        return this.smsProviderService.sendVcode(vcode, mobile);
    }

    public String sendTextSms(String text, String mobiles, String subcode) {
        try {
            JSONHttpClient jsonHttpClient = new JSONHttpClient(this.smtDaHanProperties.getMASTER_URL());
            jsonHttpClient.setRetryCount(this.smtDaHanProperties.getTrytime());
            String sendRes = jsonHttpClient.sendSms(this.smtDaHanProperties.getACCOUNT(), this.smtDaHanProperties.getPASSWORD(), mobiles, text, this.smtDaHanProperties.getSIGN(), subcode);
            this.logger.info("\u63d0\u4ea4\u5355\u6761\u666e\u901a\u77ed\u4fe1\u54cd\u5e94\uff1a" + sendRes);
            return this.getResult(sendRes);
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u5f02\u5e38", (Throwable)e);
            return "-1";
        }
    }

    private String getResult(String res) {
        SmsDaHanRes resData = (SmsDaHanRes)JSON.parseObject((String)res, SmsDaHanRes.class);
        return resData.getResult();
    }
}

