/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.entity.system.SysVirtualArea;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysVirtualAreaProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysVirtualAreaService;
import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.modules.platform.model.SuperviseVirtualAreaModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SysVirtualAreaProvideServiceImpl
implements ISysVirtualAreaProvideService {
    @Autowired
    private ISysVirtualAreaService sysVirtualAreaService;
    @Autowired
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private ISysAreaService sysAreaService;

    public SuperviseVirtualAreaModel getById(Long id) {
        SuperviseVirtualAreaModel superviseVirtualAreaModel = new SuperviseVirtualAreaModel();
        SysVirtualArea sysVirtualArea = (SysVirtualArea)this.sysVirtualAreaService.getById(id);
        if (sysVirtualArea == null) {
            return superviseVirtualAreaModel;
        }
        BeanUtils.copyProperties((Object)sysVirtualArea, (Object)superviseVirtualAreaModel);
        superviseVirtualAreaModel.setVirtualPid(sysVirtualArea.getChildrenId());
        if (sysVirtualArea.getChildrenId() != null) {
            List<SysArea> sysAreaList = this.sysAreaService.getListByIds(sysVirtualArea.getChildrenId());
            ArrayList result = new ArrayList();
            if (CollectionUtils.isNotEmpty(sysAreaList)) {
                sysAreaList.forEach(en -> {
                    if (en != null) {
                        SuperviseAreaModel am = new SuperviseAreaModel();
                        BeanUtils.copyProperties((Object)en, (Object)am);
                        am.setPid("" + en.getParentId());
                        result.add(am);
                    }
                });
            }
            superviseVirtualAreaModel.setAreaModels(result);
        }
        return superviseVirtualAreaModel;
    }

    @Transactional(readOnly=false)
    public int showOrHide(Long areaId, Boolean show, Long loginStaffId) {
        if (areaId != null && show != null) {
            SysVirtualArea result = (SysVirtualArea)this.sysVirtualAreaService.getById(areaId);
            if (result == null) {
                return 0;
            }
            SysVirtualArea virtualArea = new SysVirtualArea();
            virtualArea.setId(result.getId());
            virtualArea.setIsValid(show);
            virtualArea.setUpdateBy(loginStaffId);
            virtualArea.setUpdateDate(new Date());
            return this.sysVirtualAreaService.update(virtualArea);
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public SuperviseAreaModel addOrUpdateBySupervise(SuperviseAreaModel model, Long loginStaffId) throws Exception {
        return this.sysVirtualAreaService.addOrUpdateVirtualArea(model, loginStaffId);
    }
}

