/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.model.sms.SysRemindConfig;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.datacentre.provider.system.ISysRemindProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysRemindConfigService;
import cn.smarthse.util.common.StringUtils;
import jakarta.annotation.Resource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

@DubboService
public class SysRemindProvideServiceImpl
implements ISysRemindProvideService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysRemindProvideServiceImpl.class);
    @Autowired
    ISysRemindConfigService sysRemindConfigService;
    @Autowired
    private JavaMailSenderImpl mailSender;
    @Autowired
    private ISMSProvideMasService smsService;
    @Autowired(required=false)
    @Qualifier(value="commonThreadPoolExecutor")
    private ThreadPoolExecutor taskExecutor;
    @Resource
    protected RedissonClient redissonClient;

    public void sendEmail(String[] receivers, String subject, String emailContent) {
        if (ArrayUtils.isEmpty((Object[])receivers) || StringUtils.isEmpty((CharSequence)subject)) {
            return;
        }
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.mailSender.getUsername());
            helper.setText(emailContent, true);
            helper.setSubject(subject);
            helper.setTo(receivers);
            helper.setSentDate(new Date());
            this.mailSender.send(message);
        }
        catch (MailException e) {
            log.error("MailException\u90ae\u7bb1\u53d1\u9001\u9519\u8bef\uff1a", (Throwable)e);
        }
        catch (MessagingException e) {
            log.error("MessagingException\u90ae\u7bb1\u53d1\u9001\u9519\u8bef\uff1a", (Throwable)e);
        }
    }

    public void sendSms(SysRemindConfig sysRemindConfig, String context) {
        if (StringUtils.isEmpty((CharSequence)sysRemindConfig.getMobiles()) || StringUtils.isEmpty((CharSequence)context)) {
            return;
        }
        String smsContent = context;
        if (StringUtils.isNotBlank((CharSequence)sysRemindConfig.getSmsTemp())) {
            smsContent = StrUtil.format((CharSequence)sysRemindConfig.getSmsTemp(), (Object[])new Object[]{context});
        }
        for (String mobile : StrUtil.split((CharSequence)sysRemindConfig.getMobiles(), (CharSequence)",")) {
            this.smsService.sendSms(mobile, smsContent);
        }
    }

    private boolean isSameConfig(RateLimiterConfig current, SysRemindConfig newConfig) {
        ChronoUnit chronoUnit = ChronoUnit.valueOf(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)newConfig.getTimeUnit())));
        long rateInterval = chronoUnit.getDuration().multipliedBy(newConfig.getTimeAmount().intValue()).toMillis();
        return Objects.equals(current.getRate(), newConfig.getRateLimit().longValue()) && Objects.equals(current.getRateInterval(), rateInterval);
    }

    private boolean acquirePermission(SysRemindConfig config) {
        String limiterKey = String.format("remind:rate:%s", config.getRemindKey());
        if (StringUtils.isNotBlank((CharSequence)config.getTimeUnit()) || config.getTimeAmount() != null || config.getRateLimit() != null) {
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(limiterKey);
            RateLimiterConfig currentConfig = rateLimiter.getConfig();
            if (currentConfig == null || !this.isSameConfig(currentConfig, config)) {
                ChronoUnit chronoUnit = ChronoUnit.valueOf(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)config.getTimeUnit())));
                Duration duration = chronoUnit.getDuration().multipliedBy(config.getTimeAmount().intValue());
                rateLimiter.setRate(RateType.OVERALL, (long)config.getRateLimit().intValue(), duration);
            }
            return rateLimiter.tryAcquire(1L);
        }
        log.error("\u672a\u6b63\u786e\u914d\u7f6e\u9650\u901f\uff1aremindKey={}", (Object)config.getRemindKey());
        return true;
    }

    public void sendRemind(String remindKey, String title, String context) {
        if (StringUtils.isEmpty((CharSequence)remindKey) || StringUtils.isEmpty((CharSequence)title) || StringUtils.isEmpty((CharSequence)context)) {
            return;
        }
        this.taskExecutor.execute(() -> {
            SysRemindConfig sysRemindConfig = this.sysRemindConfigService.getSysRemindConfigByKey(remindKey);
            String emails = sysRemindConfig.getEmails();
            if (StringUtils.isBlank((CharSequence)emails) && StringUtils.isBlank((CharSequence)sysRemindConfig.getMobiles())) {
                return;
            }
            if (!this.acquirePermission(sysRemindConfig)) {
                throw new HealthException(String.format("\u63d0\u9192\u53d1\u9001\u9891\u7387\u8d85\u9650\uff0c\u7b56\u7565\uff1a%s\uff0c%d %s\u5185\u6700\u591a\u53d1\u9001%d\u6b21", sysRemindConfig.getRemindKey(), sysRemindConfig.getTimeAmount(), sysRemindConfig.getTimeUnit(), sysRemindConfig.getRateLimit()));
            }
            this.sendEmail(StrUtil.splitToArray((CharSequence)emails, (CharSequence)","), title, context);
            this.sendSms(sysRemindConfig, context);
        });
    }
}

