/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.smarthse.modules.datacentre.entity.system.SysParam;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.IndustrialClassification;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.datacentre.util.SysParamModelUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class SysParamProvideServiceImpl
implements ISysParamProvideService {
    @Autowired
    private ISysParamService service;
    Cache<Long, SysParamModel> sysParamModelCache = Caffeine.newBuilder().expireAfterWrite(4L, TimeUnit.HOURS).build();

    public void init() {
        this.getParamMap();
    }

    public SysParamModel getById(Long id) {
        if (id == null) {
            return new SysParamModel();
        }
        SysParamModel sysParamModel = (SysParamModel)this.sysParamModelCache.getIfPresent((Object)id);
        if (sysParamModel != null) {
            return sysParamModel;
        }
        SysParam param = this.service.getParamById(id);
        SysParamModel model = SysParamModelUtil.param2model(param);
        this.sysParamModelCache.put((Object)id, (Object)model);
        return model;
    }

    public List<SysParamModel> getListByIds(String ids) {
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        List<SysParam> list = this.service.getListByIds(ids);
        list.forEach(param -> data.add(SysParamModelUtil.param2model(param)));
        return data;
    }

    public List<SysParamModel> getSysParamList(String paramGroup) {
        List<SysParam> list = this.service.getSysParamList(paramGroup);
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        list.forEach(param -> data.add(SysParamModelUtil.param2model(param)));
        return data;
    }

    public List<SysParamModel> getListByPid(Long parentId) {
        List<SysParam> list = this.service.getListByPid(parentId);
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        list.forEach(param -> data.add(SysParamModelUtil.param2model(param)));
        return data;
    }

    public String getNames(Long id) {
        if (id == null) {
            return null;
        }
        SysParamModel lv = null;
        SysParamModel lv2 = null;
        SysParamModel lv3 = this.getById(id);
        Object name = "";
        if (lv3 != null && lv3.getParentId() != null && lv3.getParentId() > 0L) {
            lv2 = this.getById(lv3.getParentId());
        }
        if (lv2 != null && lv2.getParentId() != null && lv2.getParentId() > 0L) {
            lv = this.getById(lv2.getParentId());
        }
        if (lv != null) {
            name = lv.getParamValue() + "-";
        }
        if (lv2 != null) {
            name = (String)name + lv2.getParamValue() + "-";
        }
        if (lv3 != null) {
            name = (String)name + lv3.getParamValue();
        }
        return name;
    }

    public List<SysParamModel> getSysParamListByChildren(String paramGroup) {
        List<SysParam> list = this.service.getSysParamListByChildren(paramGroup);
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        list.forEach(param -> data.add(SysParamModelUtil.param2model(param)));
        return data;
    }

    public List<SysParamModel> getSysParamListByChildrenSearch(String paramGroup, String search) {
        List<SysParam> list = this.service.getSysParamListByChildren(paramGroup, search);
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        list.forEach(param -> data.add(SysParamModelUtil.param2model(param)));
        return data;
    }

    public SysParamModel getSysParamByName(String paramValue, Long cid, SysParamGroupEnum group) {
        return this.getSysParamByNameGroupCode(paramValue, cid, group, null);
    }

    public SysParamModel getSysParamByNameGroupCode(String paramValue, Long cid, SysParamGroupEnum group, String paramCode) {
        SysParam param = this.service.getSysParamByNameGroupCode(paramValue, cid, group, paramCode);
        if (param == null) {
            return null;
        }
        return SysParamModelUtil.param2model(param);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<Long, SysParamModel> getParamMap() {
        @NonNull @NonNull ConcurrentMap cacheObj = this.sysParamModelCache.asMap();
        if (MapUtils.isNotEmpty((Map)cacheObj)) {
            return cacheObj;
        }
        HashMap<Long, SysParamModel> paramMap = new HashMap<Long, SysParamModel>();
        List<SysParam> list = this.service.getParamList();
        if (list == null || list.isEmpty()) {
            return paramMap;
        }
        list.forEach(sysParam -> {
            SysParamModel model = SysParamModelUtil.param2model(sysParam);
            paramMap.put(sysParam.getId(), model);
        });
        this.sysParamModelCache.putAll(paramMap);
        return paramMap;
    }

    public List<IndustrialClassification> getIndustrialClassification() {
        return this.service.getIndustrialClassification();
    }
}

