/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.system.SysFile;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysFileService;
import cn.smarthse.modules.datacentre.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SysFileProvideServiceImpl
implements ISysFileProvideService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysFileProvideServiceImpl.class);
    @Autowired
    ISysFileService sysFileService;
    @Autowired
    OssClientBean ossClientBean;

    public SysFileModel getFileById(Long fileId) {
        if (fileId == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = (SysFile)this.sysFileService.getById(fileId);
        if (sysFile == null) {
            return null;
        }
        sysFile.setDestPath(sysFile.getOssUrl());
        sysFile.setFullOssurl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        sysFile.setOssUrl(sysFile.getFullOssurl());
        return this.toggleSysFile(sysFile);
    }

    public SysFileModel getSmartHseFileById(Long fileId) {
        if (fileId == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = (SysFile)this.sysFileService.getById(fileId);
        if (sysFile == null) {
            return null;
        }
        sysFile.setDestPath(sysFile.getOssUrl());
        sysFile.setFullOssurl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        sysFile.setOssUrl(sysFile.getOssUrl());
        return this.toggleSysFile(sysFile);
    }

    public SysFileModel getFileByHash(String fileHash) {
        if (StringUtils.isEmpty((CharSequence)fileHash)) {
            throw new ServiceException("\u6587\u4ef6hash\u503c\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = this.sysFileService.getFileByHash(fileHash);
        if (sysFile == null) {
            return null;
        }
        sysFile.setFullOssurl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.toggleSysFile(sysFile);
    }

    public String getFileUrl(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel sysFileModel = this.getFileById(fileId);
        return sysFileModel == null ? null : sysFileModel.getOssUrl();
    }

    public List<SysFileModel> getListByIds(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids) || ids.equals(",")) {
            return Collections.emptyList();
        }
        List<SysFile> list = this.sysFileService.getListByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<SysFileModel> result = new ArrayList<SysFileModel>(list.size());
        list.forEach(record -> {
            record.setDestPath(record.getOssUrl());
            record.setFullOssurl(this.ossClientBean.getUrl(record.getOssUrl()));
            record.setOssUrl(record.getOssUrl());
            result.add(this.toggleSysFile((SysFile)record));
        });
        return result;
    }

    public List<SysFileModel> getListByIds(List<Long> ids) {
        if (ids == null && ids.size() == 0) {
            return Collections.emptyList();
        }
        List<SysFile> list = this.sysFileService.getListByIds(ids.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SysFileModel> result = new ArrayList<SysFileModel>(list.size());
        list.stream().forEach(record -> {
            record.setFullOssurl(this.ossClientBean.getUrl(record.getOssUrl()));
            result.add(this.toggleSysFile((SysFile)record));
        });
        return result;
    }

    private SysFileModel toggleSysFile(SysFile record) {
        if (record == null) {
            return null;
        }
        SysFileModel model = new SysFileModel();
        model.setId(record.getId());
        model.setCid(record.getCid());
        model.setFileName(record.getFileName());
        model.setFileSize(record.getFileSize());
        model.setFileExt(record.getFileExt());
        model.setFileHash(record.getFileHash());
        model.setDestPath(record.getDestPath());
        model.setFullPath(record.getFullPath());
        model.setFullOssurl(record.getFullOssurl());
        model.setOssUrl(record.getOssUrl());
        model.setCreateDate(record.getCreateDate());
        model.setUpdateDate(record.getUpdateDate());
        return model;
    }

    @Transactional(readOnly=false)
    public SysFileModel addSysFile(SysFileModel record, Long adminId) {
        SysFile sysFile = new SysFile();
        BeanUtils.copyProperties((Object)record, (Object)sysFile);
        SysFile result = this.sysFileService.add(sysFile, adminId);
        if (result != null) {
            record.setId(result.getId());
        }
        record.setFullOssurl(this.ossClientBean.getUrl(result.getOssUrl()));
        record.setOssUrl(record.getFullOssurl());
        return record;
    }

    @Transactional(readOnly=false)
    public SysFileModel addSysFile(SysFileModel record, Long adminId, Long cid) {
        record.setCid(cid);
        return this.addSysFile(record, adminId);
    }

    public SysFileModel getFileByCid(Long cid, String filehash) {
        SysFile result = this.sysFileService.getFileByCid(cid, filehash);
        if (result == null) {
            return null;
        }
        SysFileModel model = new SysFileModel();
        BeanUtils.copyProperties((Object)result, (Object)model);
        return model;
    }

    public SysFileModel getFileByUrl(String url) {
        SysFile result = this.sysFileService.getFileByUrl(url);
        if (result == null) {
            return null;
        }
        SysFileModel model = new SysFileModel();
        BeanUtils.copyProperties((Object)result, (Object)model);
        return model;
    }

    public SysFileModel addFile(Long cid, String fileName, File file, String ossUrl) {
        SysFile result = this.sysFileService.addFile(cid, fileName, file, ossUrl);
        if (result == null) {
            return null;
        }
        SysFileModel model = new SysFileModel();
        BeanUtils.copyProperties((Object)result, (Object)model);
        return model;
    }

    public Long sumSpaceByCid(Long cid) {
        return this.sysFileService.sumSpaceByCid(cid);
    }

    public String uploadOutUrlFile2Oss(String outOssUrl) throws Exception {
        String fileName = FileUtils.getFileNameFromURL(outOssUrl);
        String suffixName = FileUtils.suffixFromUrl(outOssUrl);
        File destFile = null;
        try {
            String oss;
            destFile = File.createTempFile(UUID.randomUUID().toString(), suffixName);
            log.info("\u4e0b\u8f7d\u7b2c\u4e09\u65b9\u9644\u4ef6:{}", (Object)outOssUrl);
            HttpUtil.downloadFile((String)outOssUrl, (File)destFile);
            String string = oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + suffixName, destFile, "outurl/convertfile", fileName, null);
            return string;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            if (destFile != null) {
                destFile.delete();
            }
        }
    }

    public String uploadOutUrlFile2OssMore(String outOssUrlsMore, String splitStr) throws Exception {
        Object[] outOssUrlArr = StringUtils.splitByWholeSeparator((String)outOssUrlsMore, (String)splitStr);
        ArrayList<String> resultList = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])outOssUrlArr)) {
            for (Object outOssUrl : outOssUrlArr) {
                String result = this.uploadOutUrlFile2Oss((String)outOssUrl);
                resultList.add(result);
            }
        }
        return StringUtils.join(resultList, (String)splitStr);
    }

    @Transactional(readOnly=false)
    public List<Long> cloneFile(String fileIds, boolean copyNewFile) {
        try {
            if (StringUtils.isNotBlank((CharSequence)fileIds)) {
                ArrayList<Long> fileIdList = new ArrayList<Long>();
                Object[] fileArr = StringUtils.split((String)fileIds, (String)",");
                if (ArrayUtils.isNotEmpty((Object[])fileArr)) {
                    for (Object s : fileArr) {
                        Long fileId;
                        SysFileModel fileModel;
                        if (!StringUtils.isNumber((String)s) || (fileModel = this.getSmartHseFileById(fileId = Long.valueOf((String)s))) == null) continue;
                        if (copyNewFile) {
                            String copyOssFile = this.ossClientBean.copyOssFile(fileModel.getOssUrl());
                            fileModel.setOssUrl(copyOssFile);
                        }
                        fileModel.setId(null);
                        fileModel = this.addSysFile(fileModel, null);
                        fileIdList.add(fileModel.getId());
                    }
                }
                return fileIdList;
            }
        }
        catch (Exception e) {
            log.error("\u514b\u9686\u9644\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return null;
    }

    @Transactional
    public void delFile(String fileIds, Long updateBy) {
        if (StringUtils.isNotBlank((CharSequence)fileIds)) {
            List<SysFile> sysFileList = this.sysFileService.getListByIds(fileIds);
            if (CollectionUtils.isEmpty(sysFileList)) {
                return;
            }
            for (SysFile sysFile : sysFileList) {
                sysFile.setUpdateDate(new Date());
                sysFile.setIsValid(false);
                this.sysFileService.update(sysFile, updateBy);
                this.ossClientBean.delFile(sysFile);
            }
        }
    }

    @Transactional(readOnly=false)
    public void updateRecycleFlag(Integer recycleFlag, List<Long> fileIds) {
        if (recycleFlag == null || CollectionUtils.isEmpty(fileIds)) {
            return;
        }
        this.sysFileService.updateRecycleFlag(recycleFlag, fileIds);
    }

    @Transactional
    public SysFileModel updateFileNameById(Long id, String fileName, Long loginUserId) {
        if (id == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = (SysFile)this.sysFileService.getById(id);
        if (sysFile == null) {
            return null;
        }
        sysFile.setFileName(fileName);
        sysFile.setUpdateDate(new Date());
        sysFile.setUpdateBy(loginUserId);
        this.sysFileService.update(sysFile);
        sysFile.setDestPath(sysFile.getOssUrl());
        sysFile.setFullOssurl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        sysFile.setOssUrl(sysFile.getFullOssurl());
        return this.toggleSysFile(sysFile);
    }

    public String checkFileType(String ids, Set<String> allowedTypes) {
        List<SysFileModel> list = this.getListByIds(ids);
        if (list == null || list.isEmpty()) {
            return "\u672a\u627e\u5230\u6587\u4ef6";
        }
        List invalidFileDetails = list.stream().filter(file -> !this.isValidFileType((SysFileModel)file, allowedTypes)).map(file -> {
            String fileName = file.getFileName();
            String fileExtension = FileUtil.getSuffix((String)fileName);
            return String.format("%s(%s)", fileName, fileExtension != null ? fileExtension : "\u65e0\u540e\u7f00");
        }).collect(Collectors.toList());
        if (!invalidFileDetails.isEmpty()) {
            return String.format("\u4ee5\u4e0b\u6587\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1a%s", String.join((CharSequence)"\u3001", invalidFileDetails), String.join((CharSequence)"\u3001", allowedTypes));
        }
        return null;
    }

    private boolean isValidFileType(SysFileModel file, Set<String> allowedTypes) {
        if (file == null || file.getFileName() == null) {
            return false;
        }
        String fileExtension = FileUtil.getSuffix((String)file.getFileName());
        if (fileExtension == null || fileExtension.isEmpty()) {
            return false;
        }
        return allowedTypes.stream().anyMatch(allowedType -> allowedType.equalsIgnoreCase(fileExtension));
    }
}

