/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.hutool.http.HttpUtil;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.provider.system.ISysFileConvertProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysFileService;
import cn.smarthse.modules.datacentre.util.FileUtils;
import cn.smarthse.util.common.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StopWatch;

@DubboService(timeout=1000000)
public class SysFileConvertProvideServiceImpl
implements ISysFileConvertProvideService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysFileConvertProvideServiceImpl.class);
    @Autowired
    ISysFileService sysFileService;
    @Autowired
    OssClientBean ossClientBean;

    public String uploadOutUrlFile2Oss(String outOssUrl) throws Exception {
        String fileName = FileUtils.getFileNameFromURL(outOssUrl);
        String suffixName = FileUtils.suffixFromUrl(outOssUrl);
        File destFile = null;
        try {
            String oss;
            destFile = File.createTempFile(UUID.randomUUID().toString(), suffixName);
            StopWatch sw = new StopWatch();
            sw.start("download");
            HttpUtil.downloadFile((String)outOssUrl, (File)destFile);
            sw.stop();
            log.info("\u4e0b\u8f7d\u7b2c\u4e09\u65b9\u9644\u4ef6:\u8017\u65f6\uff1a{}s\uff0c \u5730\u5740\uff1a{}", (Object)sw.getTotalTimeSeconds(), (Object)outOssUrl);
            String string = oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + suffixName, destFile, "outurl/convertfile", fileName, null);
            return string;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            if (destFile != null) {
                destFile.delete();
            }
        }
    }

    public String uploadOutUrlFile2OssMore(String outOssUrlsMore, String splitStr) throws Exception {
        Object[] outOssUrlArr = StringUtils.splitByWholeSeparator((String)outOssUrlsMore, (String)splitStr);
        ArrayList<String> resultList = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])outOssUrlArr)) {
            for (Object outOssUrl : outOssUrlArr) {
                String result = this.uploadOutUrlFile2Oss((String)outOssUrl);
                resultList.add(result);
            }
        }
        return StringUtils.join(resultList, (String)splitStr);
    }
}

