/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.entity.system.SysVirtualArea;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysVirtualAreaService;
import cn.smarthse.modules.datacentre.util.PinyinUtil;
import cn.smarthse.modules.platform.core.framework.cache.ehcache.EhCacheUtils;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3AddParam;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3EditParam;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3ListVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3Param;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3ShowOrHideParam;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3TreeParam;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class SysAreaProvideServiceImpl
implements ISysAreaProvideService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysAreaProvideServiceImpl.class);
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private ISysVirtualAreaService virtualAreaService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;

    public List<AreaModel> getChildByPrefix(String prefix) {
        List<SysArea> childByPrefix = this.areaService.getChildByPrefix(prefix);
        ArrayList<AreaModel> areaModel = new ArrayList<AreaModel>();
        if (CollUtil.isNotEmpty(childByPrefix)) {
            for (SysArea byPrefix : childByPrefix) {
                areaModel.add(this.convert(byPrefix));
            }
        }
        return areaModel;
    }

    public AreaModel getAreaById(Long areaId) {
        if (areaId == null) {
            return new AreaModel();
        }
        return this.convert(this.areaService.getAreaById(areaId));
    }

    public String getFullAreaName(Long areaId, String connector) {
        return this.areaService.getFullAreaName(areaId, connector);
    }

    public String getFullName(Long areaId, String separation) {
        return this.areaService.getFullName(areaId, separation);
    }

    private AreaModel convert(SysArea sysArea) {
        AreaModel model = new AreaModel();
        if (sysArea != null) {
            BeanUtils.copyProperties((Object)sysArea, (Object)model);
        }
        return model;
    }

    public List<AreaModel> getAreaListByIds(String areaIds) {
        return this.areaService.getAreaListByIds(areaIds);
    }

    public List<Long> getAreaIdByParent(Long parentId) {
        List<SysArea> list = this.areaService.getChildByPrefix(String.valueOf(parentId));
        ArrayList<Long> data = new ArrayList<Long>();
        list.forEach(area -> data.add(area.getId()));
        return data;
    }

    public List<AreaModel> getAllProvinceList() {
        List<SysArea> allProvinceList = this.areaService.getAllProvinceList();
        List<AreaModel> result = this.convertArea2Model(allProvinceList);
        return result;
    }

    public List<AreaModel> getAllProvinceList(String areaIds) {
        List<SysArea> allProvinceList = this.areaService.getAllProvinceList(areaIds);
        List<AreaModel> result = this.convertArea2Model(allProvinceList);
        return result;
    }

    public List<AreaModel> getCityList(Long provinceId) {
        List<SysArea> cityList = this.areaService.getCityList(provinceId);
        List<AreaModel> result = this.convertArea2Model(cityList);
        return result;
    }

    public List<AreaModel> getCityList(Long provinceId, String areaIds) {
        List<SysArea> cityList = this.areaService.getCityList(provinceId, areaIds);
        List<AreaModel> result = this.convertArea2Model(cityList);
        return result;
    }

    public List<AreaModel> getAreaList(Long cityId) {
        List<SysArea> areaList = this.areaService.getAreaList(cityId);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getAreaList(Long cityId, String areaIds) {
        List<SysArea> areaList = this.areaService.getAreaList(cityId, areaIds);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getStreetList(Long areaId) {
        List<SysArea> areaList = this.areaService.getStreetList(areaId);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getStreetList(Long areaId, String areaIds) {
        List<SysArea> areaList = this.areaService.getStreetList(areaId, areaIds);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getChildByParentId(Long parentId, String name) {
        List<SysArea> sysAreaList = this.areaService.getChildByParentId(parentId, name);
        List<AreaModel> result = this.convertArea2Model(sysAreaList);
        return result;
    }

    public List<AreaModel> getProvinceAllById(Long provinceId) {
        List<SysArea> sysAreaList = this.areaService.getProvinceAllById(provinceId);
        List<AreaModel> result = this.convertArea2Model(sysAreaList);
        return result;
    }

    public Integer getCountChildByPid(Long pid) {
        return this.areaService.getCountChildByPid(pid);
    }

    public Map<Long, Map<String, Long>> getCountChildByPids(List<Long> pids) {
        return this.areaService.getCountChildByPids(pids);
    }

    private List<AreaModel> convertArea2Model(List<SysArea> cityList) {
        ArrayList<AreaModel> result = new ArrayList<AreaModel>(cityList.size());
        if (CollectionUtils.isNotEmpty(cityList)) {
            cityList.forEach(en -> {
                AreaModel am = new AreaModel();
                BeanUtils.copyProperties((Object)en, (Object)am);
                result.add(am);
            });
        }
        return result;
    }

    private List<SuperviseAreaModel> convertArea2SuperviseModel(List<SysArea> cityList) {
        ArrayList<SuperviseAreaModel> result = new ArrayList<SuperviseAreaModel>();
        if (CollectionUtils.isNotEmpty(cityList)) {
            cityList.forEach(en -> {
                if (en != null) {
                    SuperviseAreaModel am = new SuperviseAreaModel();
                    BeanUtils.copyProperties((Object)en, (Object)am);
                    am.setPid("" + en.getParentId());
                    result.add(am);
                }
            });
        }
        return result;
    }

    public AreaModel getAreaByName(Long parentId, String name) {
        if (name == null) {
            return null;
        }
        SysArea criObj = new SysArea();
        criObj.setParentId(parentId);
        if (parentId != null && parentId.equals(0L)) {
            if (name.equals("\u65b0\u7586")) {
                name = "\u65b0\u7586\u7ef4\u543e\u5c14";
            }
            criObj.setName(name);
        } else {
            criObj.setName(name);
        }
        List<SysArea> list = this.commonQuerySysArea(criObj);
        if (list != null && list.size() > 0) {
            SysArea area = list.get(0);
            AreaModel model = new AreaModel();
            BeanUtils.copyProperties((Object)area, (Object)model);
            return model;
        }
        return null;
    }

    public List<SysArea> commonQuerySysArea(SysArea queryObj) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        queryObj.setIsValid(true);
        cri.andEqualTo((Object)queryObj);
        example.orderBy("orderBy");
        return this.areaService.selectByExample(example);
    }

    public AreaModel centerAreaInfo(Long areaId, Byte areaLevel, Long centerAreaId) {
        SysArea sysArea = new SysArea();
        if (areaLevel == 1) {
            sysArea.setProvinceId(areaId);
        } else if (areaLevel == 2) {
            sysArea.setCityId(areaId);
        } else if (areaLevel == 3) {
            sysArea.setAreaId(areaId);
        } else if (areaLevel == 4) {
            sysArea.setStreetId(areaId);
        }
        sysArea.setId(centerAreaId);
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        sysArea.setIsValid(true);
        cri.andEqualTo((Object)sysArea);
        List<SysArea> sysAreaList = this.areaService.selectByExample(example);
        if (CollectionUtils.isNotEmpty(sysAreaList)) {
            SysArea sysArea1 = sysAreaList.get(0);
            AreaModel areaModel = new AreaModel();
            BeanUtils.copyProperties((Object)sysArea1, (Object)areaModel);
            if (sysArea1.getParentId() != null) {
                sysArea.setId(sysArea1.getParentId());
                Example example2 = new Example(SysArea.class);
                Example.Criteria cri2 = example2.createCriteria();
                cri2.andEqualTo((Object)sysArea);
                List<SysArea> parentArea = this.areaService.selectByExample(example2);
                if (CollectionUtils.isNotEmpty(parentArea)) {
                    AreaModel parentModel = new AreaModel();
                    BeanUtils.copyProperties((Object)sysAreaList.get(0), (Object)parentModel);
                    areaModel.setParentModel(parentModel);
                }
            }
            return areaModel;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void addArea(AreaModel areaModel, Long adminId) {
        if (areaModel == null || areaModel.getId() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212\u4ee3\u7801\u4e3a\u7a7a\uff01");
        }
        if (areaModel.getName() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (areaModel.getParentId() == null) {
            throw new ServiceException("\u4e0a\u7ea7\u884c\u653f\u533a\u5212\u4ee3\u7801\u4e3a\u7a7a\uff01");
        }
        if (this.areaService.getById(areaModel.getId()) != null) {
            throw new ServiceException("\u5f53\u524d\u884c\u653f\u533a\u5212\u4ee3\u7801\u5df2\u5b58\u5728\uff01");
        }
        SysArea parentArea = (SysArea)this.areaService.getById(areaModel.getParentId());
        if (parentArea == null) {
            throw new ServiceException("\u67e5\u65e0\u4e0a\u7ea7\u884c\u653f\u533a\u5212\uff01");
        }
        SysArea sysArea = new SysArea();
        BeanUtils.copyProperties((Object)areaModel, (Object)sysArea);
        if (parentArea.getLevel() >= 1) {
            sysArea.setProvinceId(parentArea.getProvinceId());
            sysArea.setProvinceName(parentArea.getProvinceName());
        }
        if (parentArea.getLevel() >= 2) {
            sysArea.setCityId(parentArea.getCityId());
            sysArea.setCityName(parentArea.getCityName());
        }
        if (parentArea.getLevel() >= 3) {
            sysArea.setAreaId(parentArea.getAreaId());
            sysArea.setAreaName(parentArea.getAreaName());
        }
        if (parentArea.getLevel() >= 4) {
            sysArea.setStreetId(parentArea.getStreetId());
            sysArea.setStreetName(parentArea.getStreetName());
        }
        sysArea.setLevel((byte)(parentArea.getLevel() + 1));
        sysArea.setSort(sysArea.getId());
        sysArea.setCreateBy(adminId);
        sysArea.setCreateDate(new Date());
        this.areaService.add(sysArea);
    }

    @Transactional(readOnly=false)
    public void saveArea(AreaModel areaModel, Long adminId) {
        if (areaModel.getId() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212\u4ee3\u7801\u4e3a\u7a7a\uff01");
        }
        if (this.areaService.getById(areaModel.getId()) == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u884c\u653f\u533a\u5212\uff01");
        }
        SysArea sysArea = new SysArea();
        BeanUtils.copyProperties((Object)areaModel, (Object)sysArea);
        sysArea.setUpdateBy(adminId);
        sysArea.setUpdateDate(new Date());
        this.areaService.update(sysArea, adminId);
    }

    @Transactional(readOnly=false)
    public void delArea(Long id, Long adminId) {
        if (id == null) {
            throw new ServiceException("\u533a\u57dfid\u4e3a\u7a7a\uff01");
        }
        SysArea sysArea = new SysArea();
        sysArea.setId(id);
        sysArea.setIsValid(false);
        sysArea.setUpdateBy(adminId);
        sysArea.setUpdateDate(new Date());
        this.areaService.update(sysArea, adminId);
    }

    @Transactional(readOnly=false)
    public void sortArea(Long id, Integer upOrDwon, Long adminId) {
        if (id == null) {
            throw new ServiceException("\u533a\u57dfid\u4e3a\u7a7a\uff01");
        }
        if (upOrDwon == null) {
            throw new ServiceException("\u4e0a\u4e0b\u79fb\u52a8\u6807\u5fd7\u4f4d\u4e3a\u7a7a\uff01");
        }
        SysArea area = (SysArea)this.areaService.getById(id);
        if (area == null) {
            throw new ServiceException("\u6ca1\u6709\u8be5\u533a\u57df\uff01");
        }
        SysArea lastArea = null;
        lastArea = upOrDwon <= 0 ? this.areaService.getLastArea(id) : this.areaService.getNextArea(id);
        if (lastArea == null) {
            return;
        }
        Long lastSort = lastArea.getSort();
        Long sort = area.getSort();
        lastArea.setSort(sort);
        lastArea.setUpdateBy(adminId);
        lastArea.setUpdateDate(new Date());
        this.areaService.update(lastArea, adminId);
        area.setSort(lastSort);
        area.setUpdateBy(adminId);
        area.setUpdateDate(new Date());
        this.areaService.update(area, adminId);
    }

    public PageInfo<AreaModel> getAreaListData(Integer pageNum, Integer pageSize, String keyword) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page list = (Page)this.areaService.getAreaListData(keyword);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        list.forEach(record -> {
            AreaModel model = new AreaModel();
            BeanUtils.copyProperties((Object)record, (Object)model);
            result.add(model);
        });
        PageInfo page = new PageInfo(result);
        page.setTotal(list.getTotal());
        page.setPages(list.getPages());
        return page;
    }

    public AreaModel getAreaByName(String areaName) {
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)">");
            String[] areaArr = StringUtils.split((String)(areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)">")), (String)">");
            if (areaArr == null || areaArr.length == 0) {
                return null;
            }
            int leng = areaArr.length;
            SysArea criObj = new SysArea();
            if (leng == 1) {
                criObj.setProvinceName(areaArr[0]);
            }
            if (leng == 2) {
                criObj.setProvinceName(areaArr[0]);
                criObj.setCityName(areaArr[1]);
            }
            if (leng == 3) {
                criObj.setProvinceName(areaArr[0]);
                criObj.setCityName(areaArr[1]);
                criObj.setAreaName(areaArr[2]);
            }
            if (leng == 4) {
                criObj.setProvinceName(areaArr[0]);
                criObj.setCityName(areaArr[1]);
                criObj.setAreaName(areaArr[2]);
                criObj.setStreetName(areaArr[3]);
            }
            criObj.setIsValid(true);
            criObj.setLevel((byte)leng);
            List<SysArea> areaList = this.areaService.getAreaListData(criObj);
            if (CollUtil.isNotEmpty(areaList)) {
                SysArea sa = areaList.get(0);
                AreaModel sysAreaMode = new AreaModel();
                BeanUtils.copyProperties((Object)sa, (Object)sysAreaMode);
                return sysAreaMode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, AreaModel> getAreaMap() {
        String cache = this.cacheProperties.getSysareaCache();
        String cacheMap = cache + "Map";
        Object cacheObj = null;
        try {
            cacheObj = EhCacheUtils.get(cache, cacheMap);
            Class<SysAreaProvideServiceImpl> clazz = SysAreaProvideServiceImpl.class;
            synchronized (SysAreaProvideServiceImpl.class) {
                if (cacheObj == null) {
                    HashMap areaMap = new HashMap();
                    SysArea param = new SysArea();
                    param.setIsValid(true);
                    List<SysArea> list = this.areaService.getAreaListData(param);
                    if (CollectionUtils.isNotEmpty(list)) {
                        list.forEach(sysArea -> {
                            AreaModel sysAreaMode = new AreaModel();
                            BeanUtils.copyProperties((Object)sysArea, (Object)sysAreaMode);
                            areaMap.put(sysArea.getId(), sysAreaMode);
                        });
                    }
                    EhCacheUtils.put(cache, cacheMap, areaMap);
                }
                cacheObj = EhCacheUtils.get(cache, cacheMap);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        {
            if (cacheObj != null) {
                Map areaMap = (Map)cacheObj;
                return areaMap;
            }
            return new HashMap<Long, AreaModel>();
        }
    }

    public List<SuperviseAreaModel> listAllArea(SuperviseAreaModel areaModel) {
        List<SysArea> sysAreaList = this.areaService.listAllArea(areaModel);
        return this.convertArea2SuperviseModel(sysAreaList);
    }

    public List<AreaModel> getProvCityAreaList(SuperviseAreaModel areaModel) {
        List<SysArea> sysAreaList = this.areaService.getProvCityAreaList(areaModel);
        return this.convertArea2Model(sysAreaList);
    }

    public List<SuperviseAreaModel> getChildOrSearch(SuperviseAreaModel areaModel) {
        List<SysArea> sysAreaList = this.areaService.listAllArea(areaModel);
        List<SuperviseAreaModel> result = this.convertArea2SuperviseModel(sysAreaList);
        if (areaModel.getPid() != null) {
            result = this.convertVirtualArea2SuperviseModel(result, Long.parseLong(areaModel.getPid()));
        } else if (areaModel.getCityId() != null) {
            result = this.convertVirtualArea2SuperviseModel(result, areaModel.getCityId());
        }
        return result;
    }

    public List<SuperviseAreaModel> getChildOrSearchExcludeDeleteOrHide(SuperviseAreaModel areaModel) {
        List<SysArea> sysAreaList = this.areaService.listAllAreaExcludeDeleteOrHide(areaModel);
        List<SuperviseAreaModel> result = this.convertArea2SuperviseModel(sysAreaList);
        if (areaModel.getPid() != null) {
            result = this.convertVirtualArea2SuperviseModel(result, Long.parseLong(areaModel.getPid()));
        } else if (areaModel.getCityId() != null) {
            result = this.convertVirtualArea2SuperviseModel(result, areaModel.getCityId());
        }
        return result;
    }

    private List<SuperviseAreaModel> convertVirtualArea2SuperviseModel(List<SuperviseAreaModel> result, Long areaId) {
        SysArea area = this.areaService.getAreaById(areaId);
        if (area != null && area.getLevel() == 2) {
            List<SysVirtualArea> virtualAreaList = this.virtualAreaService.getListByParentId(area.getId());
            virtualAreaList.forEach(item -> {
                SuperviseAreaModel model = new SuperviseAreaModel();
                BeanUtils.copyProperties((Object)item, (Object)model);
                if (item.getParentId() != null) {
                    model.setPid("" + item.getParentId());
                }
                if (item.getChildrenId() != null) {
                    model.setVirtualPid(item.getChildrenId());
                }
                model.setVirtualLevel(item.getLevel());
                model.setLevel(Byte.valueOf((byte)3));
                result.add(model);
            });
        }
        return result;
    }

    @Transactional(readOnly=false)
    public int showHideCascChild(Long areaId, Boolean show, Long loginStaffId) {
        if (areaId != null && show != null) {
            SysArea sysArea = (SysArea)this.areaService.getById(areaId);
            if (sysArea == null || sysArea.getLevel() == null) {
                return 0;
            }
            SysArea result = new SysArea();
            result.setIsValid(show);
            result.setUpdateBy(loginStaffId);
            result.setUpdateDate(new Date());
            Example e = new Example(SysArea.class);
            if (sysArea.getLevel() == 1) {
                e.createCriteria().andEqualTo("provinceId", (Object)areaId);
            } else if (sysArea.getLevel() == 2) {
                e.createCriteria().andEqualTo("cityId", (Object)areaId);
            } else if (sysArea.getLevel() == 3) {
                e.createCriteria().andEqualTo("areaId", (Object)areaId);
            } else if (sysArea.getLevel() == 4) {
                e.createCriteria().andEqualTo("streetId", (Object)areaId);
            }
            return this.areaService.updateByExampleSelective(result, e);
        }
        return 0;
    }

    private void settingPinyin(SysArea result) {
        if (StringUtils.isNotBlank((CharSequence)result.getName())) {
            String pinyin = PinyinUtil.getPinyin(result.getName());
            String firstLetters = PinyinUtil.getFirstLettersUp(result.getName());
            result.setPy(firstLetters);
            result.setPyFull(pinyin);
        }
    }

    public SuperviseAreaModel getSuperviseAreaById(Long areaId) {
        SuperviseAreaModel superviseAreaModel = new SuperviseAreaModel();
        if (areaId == 0L) {
            List sysAreaList = this.areaService.getListByIds("0");
            if (CollectionUtils.isNotEmpty(sysAreaList)) {
                SysArea areaModel = (SysArea)sysAreaList.get(0);
                superviseAreaModel.setPid("" + areaModel.getParentId());
                BeanUtils.copyProperties((Object)areaModel, (Object)superviseAreaModel);
            }
        } else {
            SysArea sysArea = (SysArea)this.areaService.getById(areaId);
            if (sysArea != null) {
                BeanUtils.copyProperties((Object)sysArea, (Object)superviseAreaModel);
                superviseAreaModel.setPid("" + sysArea.getParentId());
            }
        }
        return superviseAreaModel;
    }

    public boolean containAuthArea(Long areaId, Long orgAreaId) {
        if (orgAreaId == null || areaId == null) {
            return false;
        }
        if (Objects.equals(orgAreaId, 0L)) {
            return true;
        }
        String areaIdStr = areaId.toString();
        String orgAreaIdStr = orgAreaId.toString();
        areaIdStr = areaIdStr.replaceAll("(0+)$", "");
        orgAreaIdStr = orgAreaIdStr.replaceAll("(0+)$", "");
        return areaIdStr.startsWith(orgAreaIdStr);
    }

    @Transactional(readOnly=false)
    public SuperviseAreaModel addOrUpdateBySupervise(SuperviseAreaModel model, Long loginStaffId) {
        SysArea result = new SysArea();
        BeanUtils.copyProperties((Object)model, (Object)result);
        result.setParentId(Long.parseLong(model.getPid()));
        this.settingPinyin(result);
        if (model.getId() == null) {
            String newAreaId = this.areaService.getNewAreaId(Long.parseLong(model.getPid()));
            result.setId(Long.parseLong(newAreaId));
            result.setSort(Long.parseLong(newAreaId));
            result.setNameCustom(true);
            this.areaService.add(result, loginStaffId);
        } else {
            SysArea dbAreaInfo;
            if (!model.getOldPid().equals(model.getPid())) {
                String newSort = this.areaService.getNewSort(Long.parseLong(model.getPid()));
                result.setSort(Long.parseLong(newSort));
            }
            if (!StringUtils.equals((CharSequence)(dbAreaInfo = (SysArea)this.areaService.getById(result.getId())).getName(), (CharSequence)result.getName())) {
                if (result.getLevel() == 1) {
                    result.setProvinceName(result.getName());
                } else if (result.getLevel() == 2) {
                    result.setCityName(result.getName());
                } else if (result.getLevel() == 3) {
                    result.setAreaName(result.getName());
                } else if (result.getLevel() == 4) {
                    result.setStreetName(result.getName());
                }
            }
            this.areaService.update(result, loginStaffId);
            if (result.getId() != 0L) {
                if (!StringUtils.equals((CharSequence)dbAreaInfo.getName(), (CharSequence)result.getName()) && dbAreaInfo.getLevel() < 4) {
                    SysArea updater = new SysArea();
                    updater.setUpdateBy(loginStaffId);
                    updater.setUpdateDate(new Date());
                    Example e = new Example(SysArea.class);
                    dbAreaInfo = (SysArea)this.areaService.getById(result.getId());
                    if (result.getLevel() == 1) {
                        updater.setProvinceName(dbAreaInfo.getProvinceName());
                        e.createCriteria().andEqualTo("provinceId", (Object)result.getId());
                    } else if (result.getLevel() == 2) {
                        updater.setCityName(dbAreaInfo.getCityName());
                        e.createCriteria().andEqualTo("cityId", (Object)result.getId());
                    } else if (result.getLevel() == 3) {
                        updater.setAreaName(dbAreaInfo.getAreaName());
                        e.createCriteria().andEqualTo("areaId", (Object)result.getId());
                    }
                    this.areaService.updateByExampleSelective(updater, e);
                }
                if (!model.getOldPid().equals(model.getPid())) {
                    SysArea parent = (SysArea)this.areaService.getById(Long.parseLong(model.getPid()));
                    SysArea dbresult = (SysArea)this.areaService.getById(model.getId());
                    SysArea updater = new SysArea();
                    updater.setUpdateBy(loginStaffId);
                    updater.setUpdateDate(new Date());
                    Example e = new Example(SysArea.class);
                    if (parent.getProvinceId() != null) {
                        updater.setProvinceId(parent.getProvinceId());
                        updater.setProvinceName(parent.getProvinceName());
                    }
                    if (parent.getCityId() != null) {
                        updater.setCityId(parent.getCityId());
                        updater.setCityName(parent.getCityName());
                    }
                    if (parent.getAreaId() != null) {
                        updater.setAreaId(parent.getAreaId());
                        updater.setAreaName(parent.getAreaName());
                    }
                    Example.Criteria criteria = e.createCriteria();
                    if (dbresult.getProvinceId() != null) {
                        criteria.andEqualTo("provinceId", (Object)dbresult.getProvinceId());
                    }
                    if (dbresult.getCityId() != null) {
                        criteria.andEqualTo("cityId", (Object)dbresult.getCityId());
                    }
                    if (dbresult.getAreaId() != null) {
                        criteria.andEqualTo("areaId", (Object)dbresult.getAreaId());
                    }
                    if (dbresult.getStreetId() != null) {
                        criteria.andEqualTo("streetId", (Object)dbresult.getStreetId());
                    }
                    this.areaService.updateByExampleSelective(updater, e);
                }
            }
        }
        model.setId(result.getId());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AreaModel> getAreaNameMap() {
        Map map = (Map)this.redissonClient.getBucket("datacenter-getAreaNameMap").get();
        if (MapUtils.isNotEmpty((Map)map)) {
            return map;
        }
        RLock lock = this.redissonClient.getLock("datacenter-getAreaNameMap-lock");
        if (lock.tryLock()) {
            try {
                Map<Long, AreaModel> areaMap1 = this.getAreaMap();
                if (MapUtils.isNotEmpty(areaMap1)) {
                    Collection<AreaModel> areaList = areaMap1.values();
                    Map<String, AreaModel> collect = areaList.stream().collect(Collectors.toMap(k -> {
                        StringBuffer key = new StringBuffer();
                        if (StringUtils.isNotBlank((CharSequence)k.getProvinceName())) {
                            key.append(k.getProvinceName());
                        }
                        if (StringUtils.isNotBlank((CharSequence)k.getCityName())) {
                            key.append(k.getCityName());
                        }
                        if (StringUtils.isNotBlank((CharSequence)k.getAreaName())) {
                            key.append(k.getAreaName());
                        }
                        if (StringUtils.isNotBlank((CharSequence)k.getStreetName())) {
                            key.append(k.getStreetName());
                        }
                        return key.toString();
                    }, v -> v, (v1, v2) -> v1));
                    if (MapUtils.isNotEmpty(collect)) {
                        this.redissonClient.getBucket("datacenter-getAreaNameMap").set(collect, 2L, TimeUnit.HOURS);
                    }
                    Map<String, AreaModel> map2 = collect;
                    return map2;
                }
                Map<String, AreaModel> map3 = Collections.emptyMap();
                return map3;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u533a\u57df\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return Collections.emptyMap();
    }

    public List<AreaModel> getByAreaName(String keyword, Byte level, AreaModel areaModel) {
        List<SysArea> list = this.areaService.getAreaListDataGtLevel(keyword, level, areaModel);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<AreaModel> result = new ArrayList<AreaModel>();
        list.forEach(record -> {
            AreaModel model = new AreaModel();
            BeanUtils.copyProperties((Object)record, (Object)model);
            result.add(model);
        });
        return result;
    }

    @Transactional(readOnly=false)
    public void resetAreaSortByPid(Long pid, Long loginStaffId) {
        String resetSort = this.areaService.resetAreaSortByPid(pid);
        List<SysArea> areaList = this.areaService.getChildByPid(pid);
        int num = 1;
        for (SysArea area : areaList) {
            if (area.getLevel() != 4) continue;
            area.setSort(Long.parseLong(resetSort) + (long)num);
            this.areaService.update(area, loginStaffId);
            ++num;
        }
    }

    public List<Long> getAllAreaIdByParentAndLevel(Long areaId, Integer level) {
        List<SysArea> list = this.areaService.getAllAreaIdByParentAndLevel(areaId, level);
        ArrayList<Long> data = new ArrayList<Long>(list.size());
        list.forEach(area -> data.add(area.getId()));
        return data;
    }

    public List<AreaModel> getListByLevel(Long areaId, Byte resLevel, Byte areaLevel) {
        SysArea criObj = new SysArea();
        criObj.setLevel(resLevel);
        if (areaLevel == 1) {
            criObj.setProvinceId(areaId);
        } else if (areaLevel == 2) {
            criObj.setCityId(areaId);
        } else if (areaLevel == 3) {
            criObj.setAreaId(areaId);
        } else if (areaLevel == 4) {
            criObj.setStreetId(areaId);
        }
        List<SysArea> sysAreas = this.commonQuerySysArea(criObj);
        return this.convertArea2Model(sysAreas);
    }

    public Tree<String> getAllAreaTreeV3(SysAreaV3TreeParam param) {
        List<SysAreaV3ListVo> rst = this.getAllAreaV3();
        return this.getStringTree(param, rst, null);
    }

    public Tree<String> getNextLevelAreaTreeV3(SysAreaV3TreeParam param) {
        if (Objects.isNull(param.getId())) {
            throw new ServiceException("\u8bf7\u5148\u9009\u62e9\u533a\u57df");
        }
        List<SysAreaV3ListVo> rst = this.getAllAreaV3();
        return this.getStringTree(param, rst, param.getId());
    }

    private Tree<String> getStringTree(SysAreaV3TreeParam param, List<SysAreaV3ListVo> rst, Long rootId) {
        if (CollUtil.isEmpty(rst)) {
            return null;
        }
        if (Objects.isNull(rootId)) {
            List orgLevel0List = rst.stream().filter(i -> i.getLevel() == 0).collect(Collectors.toList());
            if (CollUtil.isEmpty(orgLevel0List)) {
                return null;
            }
            rootId = ((SysAreaV3ListVo)orgLevel0List.get(0)).getParentId();
        }
        if (!Objects.equals(param.getIsOnlineSpecialTestUser(), Boolean.TRUE) && CollUtil.isEmpty(rst = rst.stream().filter(i -> Objects.equals(i.getIsValid(), Boolean.TRUE)).collect(Collectors.toList()))) {
            return null;
        }
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setParentIdKey("parentId");
        treeNodeConfig.setNameKey("name");
        Tree built = TreeUtil.buildSingle(rst, (Object)String.valueOf(rootId), (TreeNodeConfig)treeNodeConfig, (treeNode, tree) -> {
            tree.setId((Object)String.valueOf(treeNode.getId()));
            tree.setParentId((Object)String.valueOf(treeNode.getParentId()));
            tree.setName((CharSequence)treeNode.getName());
            tree.putExtra("level", (Object)treeNode.getLevel());
            tree.putExtra("isLeaf", (Object)treeNode.getIsLeaf());
            tree.putExtra("isValid", (Object)treeNode.getIsValid());
        });
        if (StrUtil.isNotBlank((CharSequence)param.getKeyword())) {
            built.filter(stringTree -> StrUtil.containsIgnoreCase((CharSequence)stringTree.getName(), (CharSequence)param.getKeyword()));
        }
        return built;
    }

    public List<SysAreaV3ListVo> getAllAreaV3() {
        List<SysAreaV3ListVo> rst = this.areaService.getAllAreaV3();
        return (List)this.redisClient.get("v3SysArea", "getAllAreaV3", TimeUnit.HOURS.toSeconds(2L), () -> rst);
    }

    public Map<Long, AreaModel> getAreaMapByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyMap();
        }
        Example example = new Example(SysArea.class);
        example.createCriteria().andIn("id", idList);
        List<SysArea> sysAreaList = this.areaService.selectByExample(example);
        if (CollUtil.isEmpty(sysAreaList)) {
            return Collections.emptyMap();
        }
        List<AreaModel> areaModelList = this.convertArea2Model(sysAreaList);
        return areaModelList.stream().collect(Collectors.toMap(AreaModel::getId, item -> item, (v1, v2) -> v1));
    }

    public List<SysAreaV3ListVo> getNextLevelAreaListByParentIdV3(SysAreaV3Param param) {
        List<SysAreaV3ListVo> rst = this.areaService.getNextLevelAreaListByParentIdV3(param);
        return (List)this.redisClient.get("v3SysArea", RedisClient.generateCacheKey((Object[])new Object[]{"getNextLevelAreaListByParentIdV3", param.getId(), param.getName(), param.getIsOnlineSpecialTestUser(), param.getIsValid()}), TimeUnit.HOURS.toSeconds(2L), () -> rst);
    }

    public SysAreaV3OneVo getAreaByIdV3(Long id) {
        SysAreaV3OneVo rst = this.areaService.getAreaByIdV3(id);
        return (SysAreaV3OneVo)this.redisClient.get("v3SysArea", RedisClient.generateCacheKey((Object[])new Object[]{"getAreaByIdV3", id}), TimeUnit.HOURS.toSeconds(2L), () -> rst);
    }

    @Transactional
    public Boolean saveV3(SysAreaV3AddParam param) {
        String newAreaId = this.areaService.getNewAreaId(param.getParentId());
        SysArea result = new SysArea();
        result.setName(param.getName());
        result.setParentId(param.getParentId());
        result.setId(Long.parseLong(newAreaId));
        result.setSort(Long.parseLong(newAreaId));
        result.setLevel((byte)(this.areaService.getAreaById(param.getParentId()).getLevel() + 1));
        result.setNameCustom(true);
        this.settingPinyin(result);
        this.areaService.add(result, param.getLoginUserId());
        this.redisClient.delPrefix("v3SysArea");
        return true;
    }

    @Transactional
    public Boolean updateV3(SysAreaV3EditParam param) {
        SysArea result;
        Date date = new Date();
        SysArea oldSysArea = (SysArea)this.areaService.getById(param.getId());
        if (!StringUtils.equals((CharSequence)oldSysArea.getName(), (CharSequence)param.getName())) {
            result = new SysArea();
            result.setId(param.getId());
            result.setName(param.getName());
            result.setUpdateBy(param.getLoginUserId());
            result.setUpdateDate(date);
            if (oldSysArea.getLevel() == 1) {
                result.setProvinceName(param.getName());
            } else if (oldSysArea.getLevel() == 2) {
                result.setCityName(param.getName());
            } else if (oldSysArea.getLevel() == 3) {
                result.setAreaName(param.getName());
            } else if (oldSysArea.getLevel() == 4) {
                result.setStreetName(param.getName());
            }
            this.settingPinyin(result);
            this.areaService.update(result);
            if (param.getId() != 0L) {
                result = new SysArea();
                result.setUpdateBy(param.getLoginUserId());
                result.setUpdateDate(date);
                Example example = new Example(SysArea.class);
                Example.Criteria criteria = example.createCriteria();
                if (oldSysArea.getLevel() == 1) {
                    result.setProvinceName(param.getName());
                    criteria.andEqualTo("provinceId", (Object)param.getId());
                } else if (oldSysArea.getLevel() == 2) {
                    result.setCityName(param.getName());
                    criteria.andEqualTo("cityId", (Object)param.getId());
                } else if (oldSysArea.getLevel() == 3) {
                    result.setAreaName(param.getName());
                    criteria.andEqualTo("areaId", (Object)param.getId());
                } else if (oldSysArea.getLevel() == 4) {
                    result.setStreetName(param.getName());
                    criteria.andEqualTo("streetId", (Object)param.getId());
                }
                this.areaService.updateByExampleSelective(result, example);
            }
        }
        if (param.getParentId().longValue() != oldSysArea.getParentId().longValue()) {
            String newSort = this.areaService.getNewAreaId(param.getParentId());
            result = new SysArea();
            result.setSort(Long.parseLong(newSort));
            result.setUpdateBy(param.getLoginUserId());
            result.setUpdateDate(date);
            SysArea parentSysArea = (SysArea)this.areaService.getById(param.getParentId());
            if (parentSysArea.getProvinceId() != null) {
                result.setProvinceId(parentSysArea.getProvinceId());
                result.setProvinceName(parentSysArea.getProvinceName());
            }
            if (parentSysArea.getCityId() != null) {
                result.setCityId(parentSysArea.getCityId());
                result.setCityName(parentSysArea.getCityName());
            }
            if (parentSysArea.getAreaId() != null) {
                result.setAreaId(parentSysArea.getAreaId());
                result.setAreaName(parentSysArea.getAreaName());
            }
            Example example = new Example(SysArea.class);
            Example.Criteria criteria = example.createCriteria();
            if (oldSysArea.getProvinceId() != null) {
                criteria.andEqualTo("provinceId", (Object)oldSysArea.getProvinceId());
            }
            if (oldSysArea.getCityId() != null) {
                criteria.andEqualTo("cityId", (Object)oldSysArea.getCityId());
            }
            if (oldSysArea.getAreaId() != null) {
                criteria.andEqualTo("areaId", (Object)oldSysArea.getAreaId());
            }
            if (oldSysArea.getStreetId() != null) {
                criteria.andEqualTo("streetId", (Object)oldSysArea.getStreetId());
            }
            this.areaService.updateByExampleSelective(result, example);
        }
        this.redisClient.delPrefix("v3SysArea");
        return true;
    }

    @Transactional
    public Boolean showOrHideV3(SysAreaV3ShowOrHideParam param) {
        boolean b;
        SysArea sysArea = (SysArea)this.areaService.getById(param.getId());
        if (Objects.isNull(sysArea) || Objects.isNull(sysArea.getLevel())) {
            return Boolean.FALSE;
        }
        if (!param.getIsValid().booleanValue() && this.companyService.getCompanyNumsByAreaId(param.getId()) > 0L) {
            throw new ServiceException("\u9690\u85cf\u5931\u8d25\uff0c\u8be5\u533a\u57df\u4e0b\u5b58\u5728\u975e\u6d4b\u8bd5\u4f01\u4e1a");
        }
        Example example = new Example(SysArea.class);
        Example.Criteria criteria = example.createCriteria();
        if (sysArea.getLevel() == 1) {
            criteria.andEqualTo("provinceId", (Object)param.getId());
        } else if (sysArea.getLevel() == 2) {
            criteria.andEqualTo("cityId", (Object)param.getId());
        } else if (sysArea.getLevel() == 3) {
            criteria.andEqualTo("areaId", (Object)param.getId());
        } else if (sysArea.getLevel() == 4) {
            criteria.andEqualTo("streetId", (Object)param.getId());
        }
        SysArea update = new SysArea();
        update.setIsValid(param.getIsValid());
        update.setUpdateBy(param.getLoginUserId());
        update.setUpdateDate(new Date());
        boolean bl = b = this.areaService.updateByExampleSelective(update, example) > 0;
        if (b) {
            this.redisClient.delPrefix("v3SysArea");
            this.redisClient.delPrefix("v3SuperviseOrg");
            this.redisClient.delPrefix("datacenter-getAreaNameMap");
        }
        return b;
    }

    public Map<String, String> getNativePlaceByIdCards(Set<String> idCardSet) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(idCardSet)) {
            return map;
        }
        Set idCardAreaList = idCardSet.stream().filter(IdcardUtil::isValidCard).filter(org.apache.commons.lang3.StringUtils::isNotBlank).map(idCard -> String.valueOf(idCard.substring(0, 6) + "000000")).collect(Collectors.toSet());
        int pageSize = 1000;
        int page = (int)Math.ceil((double)idCardAreaList.size() * 1.0 / (double)pageSize);
        for (int i = 0; i < page; ++i) {
            List subList = idCardAreaList.stream().skip(i * pageSize).limit(pageSize).collect(Collectors.toList());
            List list = this.areaService.getListByIds(StringUtils.join(subList, (String)","));
            if (!CollectionUtils.isNotEmpty(list)) continue;
            for (SysArea area : list) {
                StringBuffer areaName = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)area.getProvinceName())) {
                    areaName.append(area.getProvinceName());
                    if (StringUtils.isNotBlank((CharSequence)area.getCityName())) {
                        areaName.append(area.getCityName());
                        if (StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
                            areaName.append(area.getAreaName());
                            if (StringUtils.isNotBlank((CharSequence)area.getStreetName())) {
                                areaName.append(area.getStreetName());
                            }
                        }
                    }
                }
                map.put(String.valueOf(area.getId()), areaName.toString());
            }
        }
        return map;
    }

    public List<AreaModel> getAreaListByParentId(Long parentId, Boolean isCity, Boolean isCountry) {
        if (isCity != null && isCity.booleanValue() || isCountry != null && isCountry.booleanValue()) {
            parentId = null;
        }
        List<SysArea> list = this.areaService.getAreaListByParentId(parentId, isCity, isCountry);
        return this.convertArea2Model(list);
    }
}

