/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.entity.system.SysFile;
import cn.smarthse.modules.datacentre.util.FileUtils;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OssClientBean {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static final String FILE_NAME_POINT_STRING = ".";
    @Value(value="${ossclient.oss_domain}")
    private String domain = "oss-cn-hangzhou.aliyuncs.com";
    @Value(value="${ossclient.oss_endpoint}")
    private String endpoint;
    @Value(value="${ossclient.oss_accesskey}")
    private String accessKeyId;
    @Value(value="${ossclient.oss_accesssecret}")
    private String accessKeySecret;
    @Value(value="${ossclient.oss_bucketname}")
    private String bucketName;
    @Value(value="${ossclient.oss_asynch}")
    private boolean asynch;
    private int exptime = 7200;
    private OSS client = null;
    @Value(value="${ossclient.oss_publicread}")
    private boolean publicread = true;

    public OSS getClient() {
        if (this.client == null) {
            this.client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        }
        return this.client;
    }

    public String getUrl(String urlfile) {
        return this.getUrl(urlfile, null, this.exptime);
    }

    public String getUrl(String urlfile, String filename, int exptime) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
            if (StringUtils.isNotEmpty((String)filename)) {
                url.append("?response-content-disposition=attachment;filename=" + filename);
            }
            return url.toString();
        }
        Date exp = DateUtils.addSecond((Date)new Date(), (int)exptime);
        return this.generatePresignedUrl(this.bucketName, filename, urlfile, exp, HttpMethod.GET).toString();
    }

    private URL generatePresignedUrl(String bucketName, String attachmentFilename, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        if (StringUtils.isNotEmpty((String)attachmentFilename)) {
            ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
            responseHeaders.setContentDisposition("attachment;filename=\"" + attachmentFilename + "\"");
            request.setResponseHeaders(responseHeaders);
        }
        if (key.endsWith(".m3u8")) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("x-oss-process", "hls/sign");
            request.setQueryParameter(param);
        }
        return this.getClient().generatePresignedUrl(request);
    }

    public String getUrlBybucket(String bucket, String urlfile) {
        if (StringUtils.isEmpty((CharSequence)urlfile) || StringUtils.isEmpty((CharSequence)bucket)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append("oss-cn-hangzhou.aliyuncs.com").append("/").append(urlfile);
            return url.toString();
        }
        Date exp = DateUtils.addSecond((Date)new Date(), (int)this.exptime);
        URL url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String getThumbnail(String urlfile, String styleName) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (((String)urlfile).indexOf("http://") >= 0 || ((String)urlfile).indexOf("https://") >= 0) {
            return urlfile;
        }
        URL url = null;
        Date exp = DateUtils.addSecond((Date)new Date(), (int)this.exptime);
        urlfile = (String)urlfile + "@!" + styleName;
        url = this.getClient().generatePresignedUrl(this.bucketName, (String)urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, contentMD5, null);
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        if (StringUtils.isNotEmpty((String)fileFullname)) {
            try {
                fileFullname = URLEncoder.encode(fileFullname, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("UnsupportedEncodingException\uff1a", (Throwable)e);
            }
            objectMeta.setContentDisposition("inline;filename*=utf-8'zh_cn'" + fileFullname);
            objectMeta.setHeader("Content-disposition", (Object)("filename*=utf-8'zh_cn'" + fileFullname));
            objectMeta.setContentEncoding("UTF-8");
        }
        if (StringUtils.isNotEmpty((String)contentType)) {
            objectMeta.setContentType(contentType + ";charset=utf-8");
        }
        if (StringUtils.isNotEmpty((String)contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(serviceFilename, file, serviceDir, objectMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String OSSPutObject(String serviceFilename, File file, String serviceDir, ObjectMetadata objectMeta) {
        StringBuilder ossfile = new StringBuilder();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            serviceDir = serviceDir.replace("\\", "/");
            if (serviceDir.endsWith(serviceFilename)) {
                ossfile.append(serviceDir);
            } else if (serviceDir.endsWith("/")) {
                ossfile.append(serviceDir).append(serviceFilename);
            } else {
                ossfile.append(serviceDir).append("/").append(serviceFilename);
            }
            PutObjectResult putObjectResult = this.getClient().putObject(this.bucketName, ossfile.toString(), (InputStream)input, objectMeta);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException\uff1a", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                this.logger.error("IOException\uff1a", (Throwable)e);
            }
        }
        return ossfile.toString();
    }

    public String copyOssFile(String sourceOssUrl) {
        if (StringUtils.isBlank((CharSequence)sourceOssUrl)) {
            return null;
        }
        String filePath = "";
        if (StringUtils.indexOf((CharSequence)sourceOssUrl, (CharSequence)"/") > -1) {
            filePath = StringUtils.substring((String)sourceOssUrl, (int)0, (int)(sourceOssUrl.lastIndexOf("/") + 1));
        }
        String suffixName = FileUtils.suffixFromUrl(sourceOssUrl);
        String targetFileName = String.valueOf(UUID.randomUUID()) + FILE_NAME_POINT_STRING + suffixName;
        String ossTargetFile = filePath + targetFileName;
        CopyObjectResult copyObjectResult = this.getClient().copyObject(this.bucketName, sourceOssUrl, this.bucketName, ossTargetFile);
        return ossTargetFile;
    }

    public void moveOssFile(String sourceOssUrl, String destinationKey, boolean isBackUp) {
        if (StringUtils.isBlank((CharSequence)sourceOssUrl)) {
            return;
        }
        try {
            if (isBackUp) {
                CopyObjectResult copyObjectResult = this.getClient().copyObject(this.bucketName, sourceOssUrl, this.bucketName, destinationKey);
            }
            this.getClient().deleteObject(this.bucketName, sourceOssUrl);
        }
        catch (OSSException oe) {
            throw new ServiceException("\u79fb\u52a8\u6587\u4ef6\u51fa\u9519\uff1a{}", oe.getMessage());
        }
        catch (ClientException ce) {
            throw new ServiceException("oss clienct\u5f02\u5e38\uff1a{}", ce.getMessage());
        }
    }

    public void copyOssFile(String sourceOssUrl, String destinationKey) {
        if (StringUtils.isBlank((CharSequence)sourceOssUrl) || StringUtils.isBlank((CharSequence)destinationKey)) {
            return;
        }
        try {
            this.getClient().copyObject(this.bucketName, sourceOssUrl, this.bucketName, destinationKey);
        }
        catch (OSSException oe) {
            throw new ServiceException("\u590d\u5236\u6587\u4ef6\u51fa\u9519\uff1a{}", oe.getMessage());
        }
        catch (ClientException ce) {
            throw new ServiceException("oss clienct\u5f02\u5e38\uff1a{}", ce.getMessage());
        }
    }

    public OSSObject downloadFile(String file) {
        OSSObject obj = null;
        try {
            obj = this.getClient().getObject(this.bucketName, file);
        }
        catch (OSSException oe) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + oe.getMessage());
        }
        catch (ClientException ce) {
            this.logger.error("\u963f\u91cc\u4e91\u8fde\u63a5\u5931\u8d25:" + ce.getMessage());
        }
        catch (NullPointerException n) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + n.getMessage());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String fileOssurl, String destFilePath, String fileName) throws IOException {
        OSSObject ossObject = this.downloadFile(fileOssurl);
        if (StringUtils.isEmpty((CharSequence)fileOssurl) || StringUtils.isEmpty((CharSequence)destFilePath) || ossObject == null || ossObject.getObjectContent() == null) {
            return fileName;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        String[] names = new String[]{fileName};
        File file = this.getNoRepeatDestFilePath(destFilePath, names);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            reader = ossObject.getObjectContent();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return names[0];
    }

    private File getNoRepeatDestFilePath(String destFilePath, String[] fileName) {
        if (!((String)destFilePath).endsWith(File.separator)) {
            destFilePath = (String)destFilePath + File.separator;
        }
        String fileSuffix = "";
        String pointStr = FILE_NAME_POINT_STRING;
        int pointIndex = fileName[0].lastIndexOf(FILE_NAME_POINT_STRING);
        if (pointIndex > 0) {
            fileSuffix = fileName[0].substring(pointIndex + 1);
            fileName[0] = fileName[0].substring(0, pointIndex);
        } else {
            pointStr = "";
        }
        File file = new File((String)destFilePath + fileName[0] + pointStr + fileSuffix);
        int i = 1;
        while (file.exists()) {
            file = new File((String)destFilePath + fileName[0] + i + pointStr + fileSuffix);
            ++i;
        }
        fileName[0] = i > 1 ? fileName[0] + --i + pointStr + fileSuffix : fileName[0] + pointStr + fileSuffix;
        return file;
    }

    public ObjectMetadata getObjectMetadataByUrl(String url) {
        ObjectMetadata metadata = this.getClient().getObjectMetadata(this.bucketName, url);
        return metadata;
    }

    public Map<String, String> getPostSignature(String dir) throws Exception {
        String host = "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
        long expireTime = 30L;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        String postPolicy = this.getClient().generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.getClient().calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", dir);
        respMap.put("host", host);
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        JSONObject jasonCallback = new JSONObject();
        StringBuffer callbackBody = new StringBuffer("{");
        callbackBody.append("bucket:").append("${bucket}");
        callbackBody.append(",filename:").append("${object}");
        callbackBody.append(",etag:").append("${etag}");
        callbackBody.append(",size:").append("${size}");
        callbackBody.append(",mimeType:").append("${mimeType}");
        callbackBody.append(",height:").append("${imageInfo.height}");
        callbackBody.append(",width:").append("${imageInfo.width}");
        callbackBody.append(",format:").append("${imageInfo.format}");
        callbackBody.append("}");
        jasonCallback.put("callbackBody", (Object)callbackBody.toString());
        jasonCallback.put("callbackBodyType", (Object)"application/json");
        String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
        respMap.put("callback", base64CallbackBody);
        return respMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) {
        BufferedReader in = null;
        String content = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {}
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return content;
        }
    }

    public static boolean doCheck(String content, byte[] sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = BinaryUtil.fromBase64String((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            boolean bverify = signature.verify(sign);
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void delFile(SysFile sysFile) {
        if (sysFile == null || StringUtils.isBlank((CharSequence)sysFile.getOssUrl())) {
            return;
        }
        this.getClient().deleteObject(this.bucketName, sysFile.getOssUrl());
    }

    @Generated
    public OssClientBean() {
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public boolean isAsynch() {
        return this.asynch;
    }

    @Generated
    public int getExptime() {
        return this.exptime;
    }

    @Generated
    public boolean isPublicread() {
        return this.publicread;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Generated
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    @Generated
    public void setExptime(int exptime) {
        this.exptime = exptime;
    }

    @Generated
    public void setClient(OSS client) {
        this.client = client;
    }

    @Generated
    public void setPublicread(boolean publicread) {
        this.publicread = publicread;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssClientBean)) {
            return false;
        }
        OssClientBean other = (OssClientBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsynch() != other.isAsynch()) {
            return false;
        }
        if (this.getExptime() != other.getExptime()) {
            return false;
        }
        if (this.isPublicread() != other.isPublicread()) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        OSS this$client = this.getClient();
        OSS other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OssClientBean;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsynch() ? 79 : 97);
        result = result * 59 + this.getExptime();
        result = result * 59 + (this.isPublicread() ? 79 : 97);
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        OSS $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OssClientBean(logger=" + String.valueOf(this.getLogger()) + ", domain=" + this.getDomain() + ", endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ", asynch=" + this.isAsynch() + ", exptime=" + this.getExptime() + ", client=" + String.valueOf(this.getClient()) + ", publicread=" + this.isPublicread() + ")";
    }
}

