/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.smarthse.modules.datacentre.entity.system.Industry;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.datacentre.service.system.IIndustryService;
import cn.smarthse.modules.datacentre.util.SysParamModelUtil;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class IndustryProvideServiceImpl
implements IndustryProvideService {
    @Autowired
    private IIndustryService industryService;
    @Autowired
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    OssClientBean ossClientBean;

    public List<IndustryModel> getIndustryListByPid(Long parentId) {
        if (parentId == null) {
            throw new ServiceException("parentId\u4e3a\u7a7a\uff01");
        }
        List<IndustryModel> list = this.industryService.getIndustryListByPid(parentId);
        return list;
    }

    public PageInfo<IndustryModel> getIndustryList(Integer pageNum, Integer pageSize, String keyword) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page list = (Page)this.industryService.getIndustryList(keyword, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        PageInfo page = new PageInfo((List)list);
        page.setTotal(list.getTotal());
        page.setPages(list.getPages());
        return page;
    }

    public List<IndustryModel> searchIndustryList4(String keyword) {
        return this.industryService.getIndustryList4(keyword);
    }

    public List<IndustryModel> searchIndustryList(String keyword, String code) {
        List<IndustryModel> list = this.industryService.getIndustryList(keyword, code);
        return list;
    }

    public List<IndustryModel> getIndustryList() {
        List<IndustryModel> list = this.industryService.getIndustryList(null);
        return list;
    }

    public List<IndustryModel> getIndustryByIds(String ids) {
        List<IndustryModel> list = this.industryService.getIndustryModelByIds(ids);
        return list;
    }

    @Transactional(readOnly=false)
    public void addIndustry(IndustryModel industryModel, Long adminId) {
        this.industryService.addIndustry(industryModel, adminId);
    }

    @Transactional(readOnly=false)
    public void saveIndustry(IndustryModel industryModel, Long adminId) {
        this.industryService.saveIndustry(industryModel, adminId);
    }

    @Transactional(readOnly=false)
    public void delIndustry(Long industryId, Long adminId) {
        this.industryService.delIndustry(industryId, adminId);
    }

    @Transactional(readOnly=false)
    public void sortIndustry(String code, Integer upOrDwon, Long adminId) {
        this.industryService.sortIndustry(code, upOrDwon, adminId);
    }

    private List<IndustryModel> getImportIndustryList(List<List<String>> list) {
        ArrayList<IndustryModel> resultSet = new ArrayList<IndustryModel>(list.size());
        try {
            for (int i = 0; i < list.size(); ++i) {
                List<String> colList = list.get(i);
                IndustryModel record = new IndustryModel();
                record.setName(colList.get(0));
                record.setCode(colList.get(1));
                record.setPcode(colList.get(2));
                record.setDescription(colList.get(3));
                resultSet.add(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    private void addIndustry(List<IndustryModel> industryList, Long adminId) {
        if (industryList != null && !industryList.isEmpty()) {
            industryList.stream().forEach(record -> this.addIndustry((IndustryModel)record, adminId));
        }
    }

    public IndustryModel getIndustryById(Long id) {
        Industry record = (Industry)this.industryService.getById(id);
        if (record != null) {
            IndustryModel model = new IndustryModel();
            BeanUtils.copyProperties((Object)record, (Object)model);
            return model;
        }
        return null;
    }

    public IndustryModel getIndustryByCode(String code) {
        return this.industryService.getIndustryByCode(code);
    }

    public IndustryModel getIndustryBySubCode(String code) {
        return this.industryService.getIndustryBySubCode(code);
    }

    private List<String> checkImportIndustry(List<IndustryModel> industryList) {
        ArrayList<CallSite> errorList = new ArrayList<CallSite>();
        if (industryList != null && !industryList.isEmpty()) {
            Iterator<IndustryModel> iterator = industryList.iterator();
            int row = 1;
            while (iterator.hasNext()) {
                boolean isRemove = false;
                IndustryModel industryModel = iterator.next();
                if (StringUtils.isEmpty((CharSequence)industryModel.getPcode())) {
                    errorList.add((CallSite)((Object)("\u7b2c" + row + "\u884c\uff1a\u4e0a\u7ea7\u884c\u4e1a\u7f16\u7801\u4e3a\u7a7a, \u8bbe\u7f6e\u4e3a\u7b2c\u4e00\u7ea7\u884c\u4e1a\uff01")));
                    isRemove = false;
                }
                if (industryModel.getName() == null) {
                    errorList.add((CallSite)((Object)("\u7b2c" + row + "\u884c\uff1a\u884c\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01")));
                    isRemove = true;
                }
                if (industryModel.getCode() == null) {
                    errorList.add((CallSite)((Object)("\u7b2c" + row + "\u884c\uff1a\u884c\u4e1a\u7f16\u7801\u4e3a\u7a7a\uff01")));
                    isRemove = true;
                }
                if (this.industryService.hasIndustryCode(industryModel.getCode())) {
                    errorList.add((CallSite)((Object)("\u7b2c" + row + "\u884c\uff1a\u8be5\u884c\u4e1a\u7f16\u7801\u5df2\u5b58\u5728\uff01")));
                    isRemove = true;
                }
                if (isRemove) {
                    iterator.remove();
                }
                ++row;
            }
        }
        return errorList == null || errorList.isEmpty() ? null : errorList;
    }

    public List<IndustryModel> getIndustryListByNames(String induNames) {
        Object[] induNamesArr;
        if (StringUtils.isNotBlank((CharSequence)induNames) && ArrayUtils.isNotEmpty((Object[])(induNamesArr = StringUtils.splitByWholeSeparator((String)induNames, (String)",")))) {
            ArrayList<IndustryModel> industryModelSet = new ArrayList<IndustryModel>();
            for (Object induName : induNamesArr) {
                if (!StringUtils.isNotBlank((CharSequence)induName)) continue;
                IndustryModel industryModelByName = this.industryService.getIndustryModelByName((String)induName);
                industryModelSet.add(industryModelByName);
            }
            return industryModelSet;
        }
        return Collections.emptyList();
    }

    public IndustryModel getIndustryByName(String induName) {
        return this.industryService.getIndustryModelByName(induName);
    }

    public List<IndustryModel> getIndustryChildList(Long parentId, String keyword) {
        return this.industryService.getIndustryChildList(parentId, keyword);
    }

    public List<SysParamModel> getListByIds(String ids) {
        ArrayList<SysParamModel> data = new ArrayList<SysParamModel>();
        List<Industry> list = this.industryService.getListByIds(ids);
        list.forEach(param -> data.add(SysParamModelUtil.param3model(param)));
        return data;
    }
}

