/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.modules.datacentre.dao.CompanyStorageMapper;
import cn.smarthse.modules.datacentre.entity.CompanyStorage;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyStorageVo;
import cn.smarthse.modules.datacentre.provider.system.ICompanyStorageProvideService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService(version="1.0.0")
public class CompanyStorageProvideServiceImpl
implements ICompanyStorageProvideService {
    @Autowired
    private CompanyStorageMapper companyStorageMapper;

    @Transactional(readOnly=false)
    public void addCompanyStorageFiles(String files, Long cid, Long userId) {
        this.companyStorageMapper.updateCompanyStorageFiles(files, cid, userId);
    }

    @Transactional
    public void saveOrUpdateCompanyStorage(CompanyBaseInfoModel companyModel, Long loginStaffId) {
        Long cid = companyModel.getCid();
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Example e = new Example(CompanyStorage.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Boolean.TRUE);
        List companyStorageList = this.companyStorageMapper.selectByExample(e);
        Date now = new Date();
        if (CollUtil.isEmpty((Collection)companyStorageList)) {
            CompanyStorage cs = new CompanyStorage();
            cs.setId(IdWorker.getId());
            cs.setCid(cid);
            cs.setStorageFiles(companyModel.getStorageFiles());
            cs.setStorageReason(companyModel.getStorageReason());
            cs.setStorageDate(now);
            cs.setCreateDate(now);
            cs.setCreateBy(loginStaffId);
            cs.setUpdateDate(now);
            cs.setUpdateBy(loginStaffId);
            cs.setIsValid(Boolean.TRUE);
            cs.setIsUpload(ObjectUtil.isNull((Object)companyModel.getIsUpload()) ? true : companyModel.getIsUpload());
            cs.setIsManualDeclare(ObjectUtil.isNull((Object)companyModel.getIsManualDeclare()) ? false : companyModel.getIsManualDeclare());
            cs.setManualDeclareBy(companyModel.getManualDeclareBy());
            this.companyStorageMapper.insert(cs);
        } else {
            CompanyStorage cs = (CompanyStorage)companyStorageList.get(0);
            cs.setStorageFiles(companyModel.getStorageFiles());
            cs.setStorageReason(companyModel.getStorageReason());
            cs.setUpdateDate(now);
            cs.setUpdateBy(loginStaffId);
            cs.setIsUpload(ObjectUtil.isNull((Object)companyModel.getIsUpload()) ? true : companyModel.getIsUpload());
            cs.setIsManualDeclare(ObjectUtil.isNull((Object)companyModel.getIsManualDeclare()) ? false : companyModel.getIsManualDeclare());
            cs.setManualDeclareBy(companyModel.getManualDeclareBy());
            this.companyStorageMapper.updateByPrimaryKey(cs);
        }
    }

    @Transactional
    public void saveOrUpdateCompanyStorageBatch(List<CompanyBaseInfoModel> companyStorageList, Long loginStaffId, Boolean falg) {
        if (CollectionUtils.isEmpty(companyStorageList)) {
            return;
        }
        List cids = companyStorageList.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCid())).map(CompanyBaseInfoModel::getCid).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cids)) {
            return;
        }
        Map<Long, CompanyBaseInfoModel> companyBaseInfoModelMap = companyStorageList.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCid())).collect(Collectors.toMap(CompanyBaseInfoModel::getCid, c -> c, (c1, c2) -> c1));
        Example example = new Example(CompanyStorage.class);
        example.createCriteria().andIn("cid", cids).andEqualTo("isValid", (Object)Boolean.TRUE);
        List companyStorages = this.companyStorageMapper.selectByExample(example);
        Map<Long, CompanyStorage> companyStorageMap = companyStorages.stream().collect(Collectors.toMap(CompanyStorage::getCid, cs -> cs, (cs1, cs2) -> cs1));
        ArrayList<CompanyStorage> insertOrUpdateBatchList = new ArrayList<CompanyStorage>();
        for (Long cid : cids) {
            CompanyStorage companyStorage;
            CompanyBaseInfoModel companyBaseInfoModel = companyBaseInfoModelMap.get(cid);
            if (MapUtils.isNotEmpty(companyStorageMap) && ObjectUtil.isNotNull((Object)companyStorageMap.get(cid))) {
                if (!falg.booleanValue()) continue;
                companyStorage = companyStorageMap.get(cid);
                companyStorage.setStorageDate(ObjectUtil.isNull((Object)companyBaseInfoModel.getStorageDate()) ? new Date() : companyBaseInfoModel.getStorageDate());
                companyStorage.setStorageFiles(companyBaseInfoModel.getStorageFiles());
                companyStorage.setStorageReason(companyBaseInfoModel.getStorageReason());
                companyStorage.setUpdateBy(loginStaffId);
                companyStorage.setUpdateDate(new Date());
                companyStorage.setIsUpload(ObjectUtil.isNull((Object)companyBaseInfoModel.getIsUpload()) ? true : companyBaseInfoModel.getIsUpload());
                companyStorage.setIsManualDeclare(ObjectUtil.isNull((Object)companyBaseInfoModel.getIsManualDeclare()) ? false : companyBaseInfoModel.getIsManualDeclare());
                companyStorage.setManualDeclareBy(companyBaseInfoModel.getManualDeclareBy());
                insertOrUpdateBatchList.add(companyStorage);
                continue;
            }
            companyStorage = new CompanyStorage();
            companyStorage.setId(IdWorker.getId());
            companyStorage.setCid(cid);
            companyStorage.setStorageDate(ObjectUtil.isNull((Object)companyBaseInfoModel.getStorageDate()) ? new Date() : companyBaseInfoModel.getStorageDate());
            companyStorage.setStorageFiles(companyBaseInfoModel.getStorageFiles());
            companyStorage.setStorageReason(companyBaseInfoModel.getStorageReason());
            companyStorage.setCreateDate(new Date());
            companyStorage.setUpdateDate(new Date());
            companyStorage.setCreateBy(loginStaffId);
            companyStorage.setUpdateBy(loginStaffId);
            companyStorage.setIsValid(Boolean.TRUE);
            companyStorage.setIsUpload(ObjectUtil.isNull((Object)companyBaseInfoModel.getIsUpload()) ? true : companyBaseInfoModel.getIsUpload());
            companyStorage.setIsManualDeclare(ObjectUtil.isNull((Object)companyBaseInfoModel.getIsManualDeclare()) ? false : companyBaseInfoModel.getIsManualDeclare());
            companyStorage.setManualDeclareBy(companyBaseInfoModel.getManualDeclareBy());
            insertOrUpdateBatchList.add(companyStorage);
        }
        if (insertOrUpdateBatchList.size() > 0) {
            this.companyStorageMapper.insertOrUpdateBatch(insertOrUpdateBatchList);
        }
    }

    public List<CompanyStorageVo> getIsUploadListByCids(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<CompanyStorageVo>();
        }
        return this.companyStorageMapper.selectIsUploadListByCids(cidList);
    }
}

