/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.harmFactor;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.dao.system.riskFactors.HarmFactorMapper;
import cn.smarthse.modules.datacentre.model.harmfactor.DcHarmFactorQueryModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorAttr;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.IHarmFactorDBService;
import cn.smarthse.modules.datacentre.util.PinyinUtil;
import cn.smarthse.modules.datacentre.util.StringUtils;
import cn.smarthse.modules.platform.core.framework.cache.ehcache.EhCacheUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.sf.ehcache.CacheManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService(version="1.0.0", timeout=50000)
@Transactional(readOnly=true)
public class HarmFactorServiceImpl
extends ZYJBaseServiceImpl<HarmFactorMapper, HarmFactor>
implements IHarmFactorService,
IHarmFactorDBService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "thirdServiceCache";
    private Cache<String, Map<Long, String>> idAndTypeCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();
    @Autowired
    protected CacheManager cacheManager;
    @Autowired
    RedisClient redisClient;

    private Map<String, HarmFactor> getHarmCache(Long cid) {
        try {
            StringBuffer cacheKey = new StringBuffer();
            cacheKey.append(cacheName).append("-harmFactorMap-").append(cid);
            Object cacheObj = EhCacheUtils.get("harmFactorMap", cacheKey.toString());
            if (cacheObj == null) {
                Map<String, HarmFactor> allMap = this.getAllMap(cid);
                EhCacheUtils.put("harmFactorMap", cacheKey.toString(), allMap);
                return allMap;
            }
            return (Map)cacheObj;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7b2c\u4e09\u65b9\u670d\u52a1\u7684\u5371\u5bb3\u56e0\u7d20Map\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return this.getAllMap(cid);
        }
    }

    public Map<String, HarmFactor> getAllMap(Long cid) {
        HashMap<String, HarmFactor> factorMap = new HashMap<String, HarmFactor>();
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllList(cid);
        if (list == null || list.isEmpty()) {
            return factorMap;
        }
        for (HarmFactor l : list) {
            if (Objects.equals(1, l.getExposureHazards())) {
                l.setNameCh(l.getBlendName());
            }
            String key = StringUtils.toDBC(l.getNameCh());
            factorMap.put(key, l);
        }
        return factorMap;
    }

    public Map<String, List<HarmFactor>> getAllMap() {
        HashMap<String, List<HarmFactor>> factorMap = new HashMap<String, List<HarmFactor>>();
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllList(null);
        if (list == null || list.isEmpty()) {
            return factorMap;
        }
        for (HarmFactor l : list) {
            if (l == null) continue;
            if (Objects.equals(1, l.getExposureHazards())) {
                l.setNameCh(l.getBlendName());
            }
            if (!StringUtils.isNotBlank((String)l.getNameCh())) continue;
            String key = StringUtils.toDBC(l.getNameCh());
            ArrayList<HarmFactor> harmFactors = (ArrayList<HarmFactor>)factorMap.get(key);
            if (harmFactors == null) {
                harmFactors = new ArrayList<HarmFactor>();
            }
            harmFactors.add(l);
            factorMap.put(key, harmFactors);
        }
        return factorMap;
    }

    public Map<String, String> getAllIdAndNameMap() {
        return this.doGetAllIdAndNameMap();
    }

    public Map<String, String> getAllIdAndNameMapForCheckPlan() {
        return this.doGetAllIdAndNameMapForCheckPlan();
    }

    private Map<String, String> doGetAllIdAndNameMapForCheckPlan() {
        return (Map)this.redisClient.get("HarmFactorServiceImpl", "doGetAllIdAndNameMapForCheckPlan", 21600L, () -> {
            HashMap<String, String> factorMap = new HashMap<String, String>();
            List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
            if (list == null || list.isEmpty()) {
                return factorMap;
            }
            for (HarmFactor l : list) {
                if (l.getCid() == null) {
                    if (l.getBelongGbz22007().equals(1) && l.getBelongGbz22019().equals(1)) {
                        factorMap.put(String.valueOf(l.getId()), l.getNameCh());
                        continue;
                    }
                    if (l.getBelongGbz22019().equals(1)) {
                        factorMap.put(String.valueOf(l.getId()), l.getGbz22019Name());
                        continue;
                    }
                    if (l.getBelongGbz22007().equals(1)) {
                        factorMap.put(String.valueOf(l.getId()), l.getGbz22007Name());
                        continue;
                    }
                    factorMap.put(String.valueOf(l.getId()), l.getNameCh());
                    continue;
                }
                factorMap.put(String.valueOf(l.getId()), l.getNameCh());
            }
            return factorMap;
        });
    }

    public Map<String, String> getAllIdAndNameMapIncludeInValid() {
        return (Map)this.redisClient.get("HarmFactorServiceImpl", "getAllIdAndNameMapIncludeInValid", 21600L, () -> {
            HashMap<String, String> factorMap = new HashMap<String, String>();
            List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
            if (list == null || list.isEmpty()) {
                return factorMap;
            }
            for (HarmFactor l : list) {
                factorMap.put(String.valueOf(l.getId()), l.getNameCh());
            }
            return factorMap;
        });
    }

    public Map<String, String> getAllIdAndNameMapIncludeInValid2007() {
        return (Map)this.redisClient.get("HarmFactorServiceImpl", "getAllIdAndNameMapIncludeInValid2007", 21600L, () -> {
            HashMap<String, String> factorMap = new HashMap<String, String>();
            List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
            if (list == null || list.isEmpty()) {
                return factorMap;
            }
            for (HarmFactor l : list) {
                if (l.getCid() == null) {
                    if (l.getBelongGbz22007().equals(1)) {
                        factorMap.put(String.valueOf(l.getId()), l.getGbz22007Name());
                        continue;
                    }
                    factorMap.put(String.valueOf(l.getId()), l.getNameCh());
                    continue;
                }
                factorMap.put(String.valueOf(l.getId()), l.getNameCh());
            }
            return factorMap;
        });
    }

    public Map<String, String> getAllIdAndNameMapIncludeInValid2019() {
        Map result = (Map)this.redisClient.get("HarmFactorServiceImpl", "getAllIdAndNameMapIncludeInValid2019", 21600L, () -> {
            HashMap<String, String> factorMap = new HashMap<String, String>();
            List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
            if (list == null || list.isEmpty()) {
                return factorMap;
            }
            for (HarmFactor l : list) {
                if (l.getCid() == null) {
                    if (l.getBelongGbz22019().equals(1)) {
                        factorMap.put(String.valueOf(l.getId()), l.getGbz22019Name());
                        continue;
                    }
                    factorMap.put(String.valueOf(l.getId()), l.getNameCh());
                    continue;
                }
                factorMap.put(String.valueOf(l.getId()), l.getNameCh());
            }
            return factorMap;
        });
        return result;
    }

    public Map<String, String> getAllNameAndIdMap() {
        Map<String, String> nameMap = this.getAllIdAndNameMap();
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : nameMap.entrySet()) {
            nameToIdMap.put(entry.getValue(), entry.getKey());
        }
        return nameToIdMap;
    }

    public Map<String, String> getAllNameAndIdMap2007() {
        Map<String, String> nameMap = this.getAllIdAndNameMapIncludeInValid2007();
        return this.nameToIdMap(nameMap);
    }

    public Map<String, String> getAllNameAndIdMap2019() {
        Map<String, String> nameMap = this.getAllIdAndNameMapIncludeInValid2019();
        return this.nameToIdMap(nameMap);
    }

    public Map<String, String> getAllNameAndIdMap2007(Long cid) {
        List<Object> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
        list = list.stream().filter(h -> h.getIsValid() != null && h.getIsValid() != false).collect(Collectors.toList());
        HashMap<String, String> idToNameMap = new HashMap<String, String>();
        for (HarmFactor harmFactor : list) {
            Long fcid = harmFactor.getCid();
            if (fcid != null && !fcid.equals(cid)) continue;
            if (harmFactor.getBelongGbz22007() != null && harmFactor.getBelongGbz22007().equals(1) && harmFactor.getGbz22007Name() != null) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getGbz22007Name());
                continue;
            }
            if (!Objects.equals(fcid, cid)) continue;
            idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
        }
        return this.nameToIdMap(idToNameMap);
    }

    public Map<String, String> getAllNameAndIdMap2007ContailRay(Long cid) {
        List<Object> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
        list = list.stream().filter(h -> h.getIsValid() != null && h.getIsValid() != false).collect(Collectors.toList());
        HashMap<String, String> idToNameMap = new HashMap<String, String>();
        for (HarmFactor harmFactor : list) {
            Long fcid = harmFactor.getCid();
            if (fcid != null && !fcid.equals(cid)) continue;
            if ("\u624b\u518c".equals(harmFactor.getBlendRemark())) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
                continue;
            }
            if (harmFactor.getBelongGbz22007() != null && harmFactor.getBelongGbz22007().equals(1) && harmFactor.getGbz22007Name() != null) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getGbz22007Name());
                continue;
            }
            if (!Objects.equals(fcid, cid)) continue;
            idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
        }
        return this.nameToIdMap(idToNameMap);
    }

    public Map<String, String> getAllNameAndIdMap2019(Long cid) {
        List<Object> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
        list = list.stream().filter(h -> h.getIsValid() != null && h.getIsValid() != false).collect(Collectors.toList());
        HashMap<String, String> idToNameMap = new HashMap<String, String>();
        for (HarmFactor harmFactor : list) {
            Long fcid = harmFactor.getCid();
            if (fcid != null && !fcid.equals(cid)) continue;
            if (harmFactor.getBelongGbz22019() != null && harmFactor.getBelongGbz22019().equals(1) && harmFactor.getGbz22019Name() != null) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getGbz22019Name());
                continue;
            }
            if (!Objects.equals(fcid, cid)) continue;
            idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
        }
        return this.nameToIdMap(idToNameMap);
    }

    public Map<String, String> getAllNameAndIdMap2019ContailRay(Long cid) {
        List<Object> list = ((HarmFactorMapper)this.dao).getAllListIncludeInvalid();
        list = list.stream().filter(h -> h.getIsValid() != null && h.getIsValid() != false).collect(Collectors.toList());
        HashMap<String, String> idToNameMap = new HashMap<String, String>();
        for (HarmFactor harmFactor : list) {
            Long fcid = harmFactor.getCid();
            if (fcid != null && !fcid.equals(cid)) continue;
            if ("\u624b\u518c".equals(harmFactor.getBlendRemark())) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
                continue;
            }
            if (harmFactor.getBelongGbz22019() != null && harmFactor.getBelongGbz22019().equals(1) && harmFactor.getGbz22019Name() != null) {
                idToNameMap.put("" + harmFactor.getId(), harmFactor.getGbz22019Name());
                continue;
            }
            if (!Objects.equals(fcid, cid)) continue;
            idToNameMap.put("" + harmFactor.getId(), harmFactor.getNameCh());
        }
        return this.nameToIdMap(idToNameMap);
    }

    private Map<String, String> nameToIdMap(Map<String, String> idToNameMap) {
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idToNameMap.entrySet()) {
            String id = entry.getKey();
            String name = entry.getValue();
            if (nameToIdMap.containsKey(name)) {
                String i = (String)nameToIdMap.get(name);
                if (Long.parseLong(id) >= Long.parseLong(i)) continue;
                nameToIdMap.put(name, id);
                continue;
            }
            nameToIdMap.put(name, id);
        }
        return nameToIdMap;
    }

    private Map<String, String> doGetAllIdAndNameMap() {
        HashMap<String, String> factorMap = new HashMap<String, String>();
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllList(null);
        if (list == null || list.isEmpty()) {
            return factorMap;
        }
        for (HarmFactor l : list) {
            if (Objects.equals(l.getExposureHazards(), 1)) {
                l.setNameCh(l.getBlendName());
            }
            factorMap.put(String.valueOf(l.getId()), l.getNameCh());
        }
        return factorMap;
    }

    public HarmFactor getOccupationalRiskFactorsAutoCompleteByNameCh(String type, String name, Long cid) {
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getOccupationalRiskFactorsAutoCompleteByNameCh(type, name, cid);
        if (list.size() > 0) {
            return list.get(0);
        }
        return new HarmFactor();
    }

    public HarmFactor getOccupationalRiskFactorsAutoCompleteByBlendName(String type, String name, Long cid) {
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getOccupationalRiskFactorsAutoCompleteByBlendName(type, name, cid);
        if (list.size() > 0) {
            return list.get(0);
        }
        return new HarmFactor();
    }

    public List<HarmFactor> getOccupationalRiskFactorsListByCid(String type, String searchKey, Long cid) {
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getOccupationalRiskFactorsByTypeAndSearch(type, searchKey, cid);
        return list;
    }

    public List<HarmFactor> getOccupationalRiskFactors(String type, String searchKey, Long cid) {
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getOccupationalRiskFactors(type, searchKey, cid);
        return list;
    }

    public List<HarmFactor> getHarmByIds(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return Collections.EMPTY_LIST;
        }
        List<HarmFactor> harmFactorList = this.getListByIds(ids);
        if (CollectionUtils.isNotEmpty(harmFactorList)) {
            harmFactorList.forEach(h -> {
                if (Objects.equals(1, h.getExposureHazards())) {
                    h.setNameCh(h.getBlendName());
                }
            });
        }
        return harmFactorList;
    }

    public String getHarmIdsByNames(String harmNames) {
        String[] arr;
        if (StringUtils.isEmpty((String)harmNames)) {
            return "";
        }
        String spliter = ",";
        if (harmNames.indexOf("\u3001") >= 0) {
            spliter = "\u3001";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (String a : arr = harmNames.split(spliter)) {
            if (StringUtils.isBlank((String)a)) continue;
            nameList.add(a);
        }
        if (nameList == null || nameList.isEmpty()) {
            return "";
        }
        return ((HarmFactorMapper)this.dao).getHarmIdsByNames(nameList);
    }

    @Transactional(readOnly=false)
    public Map<Boolean, HarmFactor> addOtherHarmFactorSubmit(HarmFactor factors, Long userId, Long cid) {
        return this.addOtherHarmFactorSubmit(factors, userId, cid, false);
    }

    @Transactional(readOnly=false)
    public Map<Boolean, HarmFactor> addOtherHarmFactorSubmit(HarmFactor factors, Long userId, Long cid, boolean isRiskEvAdd) {
        Example example = new Example(HarmFactor.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("nameCh", (Object)("\u5176\u4ed6" + factors.getType() + "(" + factors.getNameCh() + ")")).andEqualTo("cid", (Object)cid);
        example.or().andEqualTo("nameCh", (Object)factors.getNameCh()).andIsNull("cid").andEqualTo("isValid", (Object)true);
        List list = ((HarmFactorMapper)this.dao).selectByExample(example);
        if (isRiskEvAdd && CollectionUtils.isNotEmpty((Collection)list)) {
            list = list.stream().filter(f -> Objects.equals(f.getBelongGbz22007(), 1) || Objects.equals(f.getBelongGbz22019(), 1)).collect(Collectors.toList());
        }
        HashMap<Boolean, HarmFactor> map = new HashMap<Boolean, HarmFactor>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            map.put(Boolean.TRUE, (HarmFactor)list.get(0));
        } else {
            factors.setCid(cid);
            factors.setNameCh("\u5176\u4ed6" + factors.getType() + "(" + factors.getNameCh() + ")");
            factors.setBelongGbz22007(Integer.valueOf(1));
            factors.setBelongGbz22019(Integer.valueOf(1));
            this.add(factors);
            map.put(Boolean.FALSE, factors);
            this.redisClient.delPrefix("HarmFactorServiceImpl");
        }
        return map;
    }

    @Transactional(readOnly=false)
    public void deleteOtherOccupationalRiskFactorsById(Long id) {
        if (id != null) {
            HarmFactor occ = new HarmFactor();
            occ.setId(id);
            occ.setIsValid(Boolean.valueOf(false));
            ((HarmFactorMapper)this.dao).updateByPrimaryKeySelective(occ);
        }
    }

    @Transactional(readOnly=false)
    public Long getOrAddHarmIdByName(String harmName, Long cid, String harmType, Long creator) {
        String harmNameDBC = StringUtils.toDBC(harmName);
        Map<String, HarmFactor> harmFactorMap = this.getHarmCache(cid);
        HarmFactor occ = harmFactorMap.get(harmNameDBC);
        if (occ != null && occ.getId() != null) {
            return occ.getId();
        }
        HarmFactor newHF = this.customHarm(harmName, cid, creator);
        if (newHF != null) {
            return newHF.getId();
        }
        if (StringUtils.isBlank((String)harmType)) {
            harmType = this.getHarmTypeByName(harmName);
        }
        newHF = this.addByNameAndType(harmNameDBC, harmType, cid, creator);
        harmFactorMap.put(harmNameDBC, newHF);
        return newHF.getId();
    }

    private String getCustomHarmName(String customHarmName) {
        if (!(customHarmName = StringUtils.toDBC(customHarmName)).contains("(") || !customHarmName.contains(")")) {
            return null;
        }
        String[] harmInfos = customHarmName.split("\\(");
        String newHarmType = this.getHarmTypeByCustomType(harmInfos[0]);
        if (newHarmType == null) {
            return null;
        }
        Object newHarmName = "";
        for (int i = 1; i < harmInfos.length; ++i) {
            newHarmName = (String)newHarmName + harmInfos[i];
            if (i >= harmInfos.length - 1) continue;
            newHarmName = (String)newHarmName + "(";
        }
        return ((String)newHarmName).substring(0, ((String)newHarmName).length() - 1);
    }

    private HarmFactor customHarm(String harmName, Long cid, Long creator) {
        if (!(harmName = StringUtils.toDBC(harmName)).contains("(") || !harmName.contains(")")) {
            return null;
        }
        String[] harmInfos = harmName.split("\\(");
        String newHarmType = this.getHarmTypeByCustomType(harmInfos[0]);
        if (newHarmType == null) {
            return null;
        }
        Object newHarmName = "";
        for (int i = 1; i < harmInfos.length; ++i) {
            newHarmName = (String)newHarmName + harmInfos[i];
            if (i >= harmInfos.length - 1) continue;
            newHarmName = (String)newHarmName + "(";
        }
        HarmFactor newHF = this.addByNameAndType(((String)newHarmName).substring(0, ((String)newHarmName).length() - 1), newHarmType, cid, creator);
        return newHF;
    }

    @Transactional(readOnly=false)
    public HarmFactor addByNameAndType(String harmName, String harmType, Long cid, Long creator) {
        HarmFactor newHF = new HarmFactor();
        newHF.setNameCh(harmName);
        newHF.setBlendName(harmName);
        newHF.setType(harmType);
        if (cid == null) {
            cid = -1L;
        }
        newHF.setCid(cid);
        newHF.setCreateBy(creator);
        newHF.setCreateDate(new Date());
        this.add(newHF);
        return newHF;
    }

    private String getHarmTypeByName(String name) {
        String type = this.getHarmTypeByCustomType(name);
        return type == null ? "\u5176\u4ed6\u56e0\u7d20" : type;
    }

    private String getHarmTypeByCustomType(String type) {
        if (type.contains("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20") || type.contains("\u5316\u5b66\u56e0\u7d20") || type.contains("\u5316\u5b66")) {
            return "\u5316\u5b66\u56e0\u7d20";
        }
        if (type.contains("\u5176\u4ed6\u7269\u7406\u56e0\u7d20") || type.contains("\u7269\u7406\u56e0\u7d20") || type.contains("\u7269\u7406")) {
            return "\u7269\u7406\u56e0\u7d20";
        }
        if (type.contains("\u5176\u4ed6\u653e\u5c04\u56e0\u7d20") || type.contains("\u653e\u5c04\u56e0\u7d20") || type.contains("\u653e\u5c04")) {
            return "\u653e\u5c04\u56e0\u7d20";
        }
        if (type.contains("\u5176\u4ed6\u751f\u7269\u56e0\u7d20") || type.contains("\u751f\u7269\u56e0\u7d20") || type.contains("\u751f\u7269")) {
            return "\u751f\u7269\u56e0\u7d20";
        }
        if (type.contains("\u5176\u4ed6\u7c89\u5c18\u56e0\u7d20") || type.contains("\u5176\u4ed6\u7c89\u5c18") || type.contains("\u7c89\u5c18")) {
            return "\u7c89\u5c18";
        }
        if (type.contains("\u5176\u4ed6") || type.contains("\u5176\u4ed6\u56e0\u7d20")) {
            return "\u5176\u4ed6\u56e0\u7d20";
        }
        return null;
    }

    public String getHarmIdsByNames(String harmNames, Map<String, Long> existHarm, Long cid, String harmType, Long creator) {
        String[] arr;
        HashSet<CallSite> harmIds = new HashSet<CallSite>();
        if (StringUtils.isEmpty((String)harmNames)) {
            return "";
        }
        String spliter = ",";
        if (harmNames.indexOf("\u3001") >= 0) {
            spliter = "\u3001";
        }
        for (String harmName : arr = harmNames.split(spliter)) {
            if (StringUtils.isBlank((String)harmName)) continue;
            Long existHarmId = existHarm.get(harmName);
            if (existHarmId != null) {
                harmIds.add((CallSite)((Object)("" + existHarmId)));
                continue;
            }
            Long harmId = this.getOrAddHarmIdByName(harmName, cid, harmType, creator);
            existHarm.put(harmName, harmId);
            harmIds.add((CallSite)((Object)("" + harmId)));
        }
        return String.join((CharSequence)",", harmIds);
    }

    public List<HarmFactor> getHarmByNameAndCid(String nameCh, String customerNameCh, Long cid) {
        Example example = new Example(HarmFactor.class);
        example.or().andEqualTo("nameCh", (Object)nameCh).andIsNull("cid").andEqualTo("isValid", (Object)true);
        example.or().andEqualTo("nameCh", (Object)customerNameCh).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return ((HarmFactorMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void addCustomHarm(HarmFactor factor, Long userId) {
        this.add(factor);
    }

    public List<HarmFactor> getOccupationalRiskFactors(String type, String searchKey, Long cid, int gbz22007) {
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getOccupationalRiskFactorsByGbz22007(type, searchKey, cid, gbz22007);
        return list;
    }

    public List<FactorAttr> getByFactorIds(List<Long> factorIds) {
        if (factorIds == null || factorIds.isEmpty()) {
            return new ArrayList<FactorAttr>(0);
        }
        return ((HarmFactorMapper)this.dao).getFactorAttrByFactorIds(factorIds);
    }

    public List<HarmFactor> getByHarm(HarmFactor harm) {
        return ((HarmFactorMapper)this.dao).getByHarm(harm);
    }

    @Transactional(readOnly=false)
    public void updateById(HarmFactor harmFactor, Long creator) {
        this.updateByPrimaryKey(harmFactor, creator);
    }

    public HarmFactor getThisById(Long id) {
        return (HarmFactor)this.getById(id);
    }

    public String getHarmNames(String harmIds) {
        List<Long> ids = StringUtils.parseToLongList(harmIds);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return ((HarmFactorMapper)this.dao).getHarmNames(ids);
    }

    public Map<String, List<HarmFactor>> getSortByHarm(HarmFactor harm) {
        HashMap<String, List<HarmFactor>> sortmap = new HashMap<String, List<HarmFactor>>();
        List<HarmFactor> occupationalRiskFactors = ((HarmFactorMapper)this.dao).getByHarm(harm);
        if (harm.getSearchKey() != null && !"".equals(harm.getSearchKey())) {
            sortmap.put("", occupationalRiskFactors);
            return sortmap;
        }
        occupationalRiskFactors.forEach(item -> {
            String nameCh = item.getNameCh();
            if (StringUtils.isNotEmpty(nameCh)) {
                String letterUp = PinyinUtil.getFirstLettersUp(nameCh).toUpperCase();
                String string = letterUp = StringUtils.isNotEmpty(letterUp = letterUp.replaceAll("[^A-Z]", "")) ? letterUp.substring(0, 1) : nameCh.substring(0, 1);
                if (sortmap.containsKey(letterUp)) {
                    List harmFactors = (List)sortmap.get(letterUp);
                    harmFactors.add(item);
                    sortmap.put(letterUp, harmFactors);
                } else {
                    ArrayList<HarmFactor> harmFactors = new ArrayList<HarmFactor>();
                    harmFactors.add((HarmFactor)item);
                    sortmap.put(letterUp, harmFactors);
                }
            }
        });
        return sortmap;
    }

    public Map<String, List<HarmFactor>> getCheckFactorSortByHarm(HarmFactor harm, Long standardId) {
        HashMap<String, List<HarmFactor>> sortmap = new HashMap<String, List<HarmFactor>>();
        String businessType = harm.getBusinessType();
        List<HarmFactor> occupationalRiskFactors = ((HarmFactorMapper)this.dao).getCheckFactorByHarm(harm);
        Iterator<HarmFactor> iterator = occupationalRiskFactors.iterator();
        while (iterator.hasNext()) {
            HarmFactor factor = iterator.next();
            if (standardId.equals(1L)) {
                if (!factor.getBelongGbz22007().equals(1) && factor.getCid() == null) {
                    iterator.remove();
                    continue;
                }
                if (factor.getCid() == null) {
                    factor.setNameCh(factor.getGbz22007Name());
                }
            }
            if (!standardId.equals(2L)) continue;
            if (!factor.getBelongGbz22019().equals(1) && factor.getCid() == null) {
                iterator.remove();
                continue;
            }
            if (factor.getCid() != null) continue;
            factor.setNameCh(factor.getGbz22019Name());
        }
        List<HarmFactor> fangs = ((HarmFactorMapper)this.dao).getFangShe(harm);
        occupationalRiskFactors.addAll(fangs);
        if (harm.getSearchKey() != null && !"".equals(harm.getSearchKey())) {
            sortmap.put("", occupationalRiskFactors);
            return sortmap;
        }
        occupationalRiskFactors.forEach(item -> {
            String nameCh = item.getNameCh();
            if ("0".equals(businessType)) {
                nameCh = item.getBlendName();
            }
            if (StringUtils.isNotEmpty(nameCh)) {
                String letterUp = PinyinUtil.getFirstLettersUp(nameCh).toUpperCase();
                String string = letterUp = StringUtils.isNotEmpty(letterUp = letterUp.replaceAll("[^A-Z]", "")) ? letterUp.substring(0, 1) : nameCh.substring(0, 1);
                if (sortmap.containsKey(letterUp)) {
                    List harmFactors = (List)sortmap.get(letterUp);
                    harmFactors.add(item);
                    sortmap.put(letterUp, harmFactors);
                } else {
                    ArrayList<HarmFactor> harmFactors = new ArrayList<HarmFactor>();
                    harmFactors.add((HarmFactor)item);
                    sortmap.put(letterUp, harmFactors);
                }
            }
        });
        return sortmap;
    }

    public Map<String, List<HarmFactor>> getUnionFactorSortByHarm(HarmFactor harm) {
        HashMap<String, List<HarmFactor>> sortmap = new HashMap<String, List<HarmFactor>>();
        String businessType = harm.getBusinessType();
        List<HarmFactor> occupationalRiskFactors = ((HarmFactorMapper)this.dao).getCheckFactorByHarm(harm);
        Iterator<HarmFactor> iterator = occupationalRiskFactors.iterator();
        ArrayList<HarmFactor> differentHarmFactorName = new ArrayList<HarmFactor>();
        while (iterator.hasNext()) {
            HarmFactor item2 = iterator.next();
            if (!StringUtils.isNotEmpty(item2.getGbz22007Name()) || !StringUtils.isNotEmpty(item2.getGbz22019Name()) || !StringUtils.isNotEmpty(item2.getNameCh()) || item2.getGbz22007Name().equals(item2.getGbz22019Name())) continue;
            HarmFactor harmFactor2007 = new HarmFactor();
            HarmFactor harmFactor2019 = new HarmFactor();
            BeanUtils.copyProperties((Object)item2, (Object)harmFactor2007);
            BeanUtils.copyProperties((Object)item2, (Object)harmFactor2019);
            harmFactor2007.setNameCh(item2.getGbz22007Name() + "(2007)");
            harmFactor2019.setNameCh(item2.getGbz22019Name() + "(2019)");
            differentHarmFactorName.add(harmFactor2007);
            differentHarmFactorName.add(harmFactor2019);
            iterator.remove();
        }
        occupationalRiskFactors.addAll(differentHarmFactorName);
        if (harm.getSearchKey() != null && !"".equals(harm.getSearchKey())) {
            sortmap.put("", occupationalRiskFactors);
            return sortmap;
        }
        occupationalRiskFactors.forEach(item -> {
            String nameCh = item.getNameCh();
            if ("0".equals(businessType)) {
                nameCh = item.getBlendName();
            }
            if (StringUtils.isNotEmpty(nameCh)) {
                String letterUp = PinyinUtil.getFirstLettersUp(nameCh).toUpperCase();
                String string = letterUp = StringUtils.isNotEmpty(letterUp = letterUp.replaceAll("[^A-Z]", "")) ? letterUp.substring(0, 1) : nameCh.substring(0, 1);
                if (sortmap.containsKey(letterUp)) {
                    List harmFactors = (List)sortmap.get(letterUp);
                    harmFactors.add(item);
                    sortmap.put(letterUp, harmFactors);
                } else {
                    ArrayList<HarmFactor> harmFactors = new ArrayList<HarmFactor>();
                    harmFactors.add((HarmFactor)item);
                    sortmap.put(letterUp, harmFactors);
                }
            }
        });
        return sortmap;
    }

    public List<HarmFactor> getByHazardRating(String hazardRating) {
        return ((HarmFactorMapper)this.dao).getByHazardRating(hazardRating);
    }

    public List<String> getTypes() {
        return ((HarmFactorMapper)this.dao).getTypes();
    }

    @Transactional(readOnly=false)
    public HarmFactor addHarm(HarmFactor dicValue) {
        if (dicValue.getBelongGbz188() != null && dicValue.getBelongGbz188() == 1 || dicValue.getBelongGbz22007() != null && dicValue.getBelongGbz22007() == 1) {
            dicValue.setIsShow(Boolean.valueOf(true));
        } else {
            dicValue.setIsShow(Boolean.valueOf(false));
        }
        return this.add(dicValue);
    }

    public boolean isSameHarmName(String nameCh, Long id) {
        Example example = new Example(HarmFactor.class);
        example.createCriteria().andEqualTo("nameCh", (Object)nameCh).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
        return ((HarmFactorMapper)this.dao).selectCountByExample(example) > 0;
    }

    public boolean isSameParamCode(String paramcode, Long id) {
        Example example = new Example(HarmFactor.class);
        example.createCriteria().andEqualTo("paramcode", (Object)paramcode).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
        return ((HarmFactorMapper)this.dao).selectCountByExample(example) > 0;
    }

    public List<HarmFactor> getHarmFactorListBySearch(String type, Integer status, String searchKey) {
        return ((HarmFactorMapper)this.dao).getHarmFactorListBySearch(type, status, searchKey);
    }

    @Transactional(readOnly=false)
    public HarmFactor updateHarm(HarmFactor dicValue) {
        if (dicValue.getId() != null) {
            if (dicValue.getBelongGbz188() != null && dicValue.getBelongGbz188() == 1 || dicValue.getBelongGbz22007() != null && dicValue.getBelongGbz22007() == 1) {
                dicValue.setIsShow(Boolean.valueOf(true));
            } else {
                dicValue.setIsShow(Boolean.valueOf(false));
            }
            this.update(dicValue);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void showOrHide(Integer flag, Long id, Long loginStaffId) {
        if (flag == null || id == null) {
            return;
        }
        boolean isShow = true;
        HarmFactor hf = new HarmFactor();
        hf.setId(id);
        if (flag == 2) {
            isShow = false;
            hf.setBelongGbz22007(Integer.valueOf(0));
            hf.setBelongGbz188(Integer.valueOf(0));
        }
        if (flag == 1) {
            hf.setBelongGbz22007(Integer.valueOf(1));
            hf.setBelongGbz188(Integer.valueOf(1));
        }
        hf.setUpdateDate(new Date());
        hf.setUpdateBy(loginStaffId);
        hf.setIsShow(Boolean.valueOf(isShow));
        this.update(hf);
    }

    public Map<Long, String> doGetAllIdAndTypeMap() {
        return (Map)this.redisClient.get("HarmFactorServiceImpl", "doGetAllIdAndTypeMap", 21600L, () -> {
            HashMap<Long, String> factorMap = new HashMap<Long, String>();
            List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllFactorList();
            if (list == null || list.isEmpty()) {
                return factorMap;
            }
            for (HarmFactor l : list) {
                factorMap.put(l.getId(), l.getType());
            }
            return factorMap;
        }, (TypeReference)new TypeReference<Map<Long, String>>(){});
    }

    public Map<Long, String> doGetAllIdAndTypeFactorMap() {
        HashMap<Long, String> factorMap = new HashMap<Long, String>();
        List<HarmFactor> list = ((HarmFactorMapper)this.dao).getAllFactorList();
        if (list == null || list.isEmpty()) {
            return factorMap;
        }
        for (HarmFactor l : list) {
            factorMap.put(l.getId(), l.getType());
        }
        return factorMap;
    }

    public String getTypeByName(String harmName) {
        Example example = new Example(HarmFactor.class);
        example.createCriteria().andEqualTo("nameCh", (Object)harmName).andEqualTo("isValid", (Object)true);
        List list = ((HarmFactorMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return ((HarmFactor)list.get(0)).getType();
        }
        return "\u5176\u4ed6\u56e0\u7d20";
    }

    public String getHarmIdsForApiByNames(String harmNames) {
        String[] arr;
        if (StringUtils.isEmpty((String)harmNames)) {
            return "";
        }
        String spliter = ",";
        if (harmNames.indexOf(";") > 0) {
            spliter = ";";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (String a : arr = harmNames.split(spliter)) {
            if (StringUtils.isBlank((String)a)) continue;
            nameList.add(a);
        }
        if (nameList == null || nameList.isEmpty()) {
            return "";
        }
        return ((HarmFactorMapper)this.dao).getHarmIdsByNames(nameList);
    }

    public List<HarmFactor> selectList(Long cid, String keyword, String harmTypes) {
        List<String> harmTypesList = null;
        if (StringUtils.isNotBlank((String)harmTypes)) {
            harmTypesList = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
        }
        return ((HarmFactorMapper)this.dao).selectList(cid, keyword, harmTypesList);
    }

    public List<HarmFactor> selectListByQueryModel(DcHarmFactorQueryModel dcHarmFactorQueryModel) {
        if (dcHarmFactorQueryModel == null) {
            return null;
        }
        return ((HarmFactorMapper)this.dao).selectListByQueryModel(dcHarmFactorQueryModel);
    }

    public List<HarmFactor> getHarmFactorsForInvestigation(String searchKey, Long cid) {
        return ((HarmFactorMapper)this.dao).getHarmFactorsForInvestigation(searchKey, cid);
    }

    public Map<Long, String> getFactorNature() {
        List<HarmFactor> list = this.getAllListIncludeInvalid();
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (HarmFactor factor : list) {
            if (factor.getHazardNature() == null || factor.getHazardNature().isEmpty()) continue;
            map.put(factor.getId(), factor.getHazardNature());
        }
        return map;
    }

    public List<HarmModel> getListByInitials(String initials, String type, String keyword) {
        return ((HarmFactorMapper)this.dao).selectListByInitials(initials, type, keyword);
    }

    public List<HarmFactor> getAllListIncludeInvalid() {
        return (List)this.redisClient.get("HarmFactorServiceImpl", "getAllListIncludeInvalid", 18000L, () -> ((HarmFactorMapper)this.dao).getAllListIncludeInvalid());
    }
}

