/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.email;

import cn.smarthse.modules.datacentre.bootstrap.properties.EmailProperties;
import cn.smarthse.modules.datacentre.provider.email.IEmailService;
import cn.smarthse.modules.kafka.model.EmailModel;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.ModelMap;

@DubboService(version="1.0.0", timeout=50000)
@Transactional(readOnly=true)
public class EmailServiceImpl
implements IEmailService {
    @Autowired
    private JavaMailSenderImpl mailSender;
    @Autowired(required=false)
    @Qualifier(value="taskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private EmailProperties emailProperties;
    private static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    public void sendEmail(EmailModel emailModel, Date date) throws MessagingException {
        this.sendEmail(emailModel, null, null, date);
    }

    public void sendExceptionEmail(String subject, Exception ex) {
        String[] exceptionCustomer = this.emailProperties.getExceptionCustomer();
        if (!"true".equals(this.emailProperties.getSendFlag()) || exceptionCustomer == null || exceptionCustomer.length == 0) {
            return;
        }
        if (ex == null) {
            return;
        }
        StringBuffer errorStr = new StringBuffer();
        errorStr.append(ex.toString() + "\n");
        for (StackTraceElement s : ex.getStackTrace()) {
            errorStr.append(s.toString() + "\n");
        }
        EmailModel emailModel = new EmailModel();
        emailModel.setEmailContent(errorStr.toString());
        emailModel.setReceivers(exceptionCustomer);
        emailModel.setSubject(this.emailProperties.getEmailSubjectStart() + subject + "\u5f02\u5e38\uff1a" + ex.getMessage());
        try {
            this.sendEmail(emailModel, new Date());
            logger.error("\u9519\u8bef\u4fe1\u606f\u90ae\u4ef6\u5df2\u53d1\u9001");
        }
        catch (MessagingException e) {
            logger.error("\u9519\u8bef\u4fe1\u606f\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    private void sendEmail(EmailModel emailModel, String templateName, ModelMap model, Date date) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        helper.setFrom(this.mailSender.getUsername());
        helper.setValidateAddresses(true);
        helper.setText(emailModel.getEmailContent(), true);
        helper.setSubject(emailModel.getSubject());
        helper.setCc(emailModel.getCc());
        helper.setTo(emailModel.getReceivers());
        helper.setBcc(emailModel.getBcc());
        if (null == date) {
            date = new Date();
        }
        helper.setSentDate(date);
        if (emailModel.getAttachFile() != null) {
            for (File file : emailModel.getAttachFile()) {
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                helper.addAttachment(file.getName(), (InputStreamSource)fileSystemResource);
            }
        }
        this.addSendMailTask(message);
    }

    private void addSendMailTask(final MimeMessage message) {
        if (this.taskExecutor != null) {
            try {
                this.taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        EmailServiceImpl.this.mailSender.send(message);
                    }
                });
            }
            catch (Exception e) {
                logger.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38,\u90ae\u4ef6\u8be6\u7ec6\u4fe1\u606f\u4e3a{}", (Object)e.getMessage());
            }
        } else {
            this.mailSender.send(message);
        }
    }
}

