/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.apps.wm;

import cn.smarthse.modules.datacentre.dao.apps.wm.WmRecommendpicMapper;
import cn.smarthse.modules.datacentre.model.apps.WmAdminModel;
import cn.smarthse.modules.datacentre.model.entity.wm.WmRecommendpic;
import cn.smarthse.modules.datacentre.provider.impl.OssClientBean;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.apps.wm.IWmRecommendpicProviderByPlatformService;
import cn.smarthse.modules.datacentre.util.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class WmRecommendpicProviderByPlatformServiceImpl
extends ZYJBaseServiceImpl<WmRecommendpicMapper, WmRecommendpic>
implements IWmRecommendpicProviderByPlatformService {
    @Autowired
    OssClientBean ossclient;
    public Cache<String, String> imgPathCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();
    public Cache<String, List<WmRecommendpic>> picsList = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.DAYS).build();

    @Override
    public List<WmRecommendpic> getListByRecommendId(String recommendId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommendIds", recommendId.split(","));
        return ((WmRecommendpicMapper)this.dao).selectPicListByMap(map);
    }

    @Override
    public List<WmRecommendpic> getAllList() {
        if (this.picsList.estimatedSize() == 0L) {
            this.picsList.invalidateAll();
            this.picsList.cleanUp();
            HashMap<String, List<WmRecommendpic>> map = new HashMap<String, List<WmRecommendpic>>();
            List<WmRecommendpic> picList = ((WmRecommendpicMapper)this.dao).selectAllPicList();
            map.put("picsList", picList);
            this.picsList.putAll(map);
        }
        List picsList = (List)this.picsList.getIfPresent((Object)"picsList");
        for (WmRecommendpic pic : picsList) {
            if (pic == null) continue;
            pic.setLocalPath(this.getImgPathByNameFromCache(pic.getName()));
        }
        return picsList;
    }

    @Override
    public List<WmAdminModel> getAdminPicListByMap(Map<String, Object> map) {
        return ((WmRecommendpicMapper)this.dao).selectAdminPicList(map);
    }

    @Override
    public String getImgPathByName(String name) {
        this.logger.info("\u6309\u8b66\u793a\u6807\u8bc6\u63d0\u793a\u5f97\u5230\u56fe\u7247\u5168\u8def\u5f84:name={}", (Object)name);
        Example example = new Example(WmRecommendpic.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("name", (Object)name).andIsNotNull("graphicSymbol");
        WmRecommendpic pic = (WmRecommendpic)this.getOneByExample(example);
        if (pic != null) {
            String url = this.ossclient.getUrl("uploadf/warningsigns/" + pic.getGraphicSymbol());
            return url;
        }
        return null;
    }

    @Override
    public String getImgPathByNameFromCache(String name) {
        if (this.imgPathCache.estimatedSize() == 0L) {
            this.imgPathCache.invalidateAll();
            this.imgPathCache.cleanUp();
            Example example = new Example(WmRecommendpic.class);
            example.createCriteria().andEqualTo("isValid", (Object)true).andIsNotNull("name").andIsNotNull("graphicSymbol");
            List picList = this.getListByExample(example);
            Map<String, String> collect = picList.stream().collect(Collectors.toMap(WmRecommendpic::getName, WmRecommendpic::getGraphicSymbol, (v1, v2) -> v2));
            this.imgPathCache.putAll(collect);
        }
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        String s = (String)this.imgPathCache.getIfPresent((Object)name);
        if (StringUtils.isNotEmpty(s)) {
            String url = this.ossclient.getUrl("uploadf/warningsigns/" + s);
            return url;
        }
        return null;
    }

    @Override
    public List<WmRecommendpic> getByName(String name) {
        this.logger.info("\u6309\u8b66\u793a\u6807\u8bc6\u63d0\u793a\u5f97\u5230\u5b9e\u4f53:name={}", (Object)name);
        Example example = new Example(WmRecommendpic.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("name", (Object)name);
        return this.getListByExample(example);
    }
}

