/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.apps.protective;

import cn.smarthse.modules.datacentre.dao.apps.protective.ProtectListMapper;
import cn.smarthse.modules.datacentre.entity.apps.protective.ProtectList;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectListModel;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectModel;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectSechModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoSeachModel;
import cn.smarthse.modules.datacentre.provider.apps.protective.IProtectListService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.util.common.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService(version="3.3.0")
@Transactional(readOnly=true)
public class ProtectListServiceImpl
extends ZYJBaseServiceImpl<ProtectListMapper, ProtectList>
implements IProtectListService {
    @Autowired
    IRiskFactorsProvideByPlatformService riskFactorsProvideByPlatformService;

    public List<cn.smarthse.modules.datacentre.model.entity.protect.ProtectList> getByClassId(Long classId) {
        ArrayList<cn.smarthse.modules.datacentre.model.entity.protect.ProtectList> list = new ArrayList<cn.smarthse.modules.datacentre.model.entity.protect.ProtectList>();
        Example example = new Example(ProtectList.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("classId", (Object)classId);
        List<ProtectList> protectLists = this.getListByExample(example);
        if (protectLists != null && protectLists.size() > 0) {
            protectLists.forEach(item -> {
                cn.smarthse.modules.datacentre.model.entity.protect.ProtectList protect = new cn.smarthse.modules.datacentre.model.entity.protect.ProtectList();
                BeanUtils.copyProperties((Object)item, (Object)protect);
                list.add(protect);
            });
        }
        return list;
    }

    public ProtectModel getProtectModelByHarm(ProtectSechModel model) {
        if (model == null) {
            throw new ServiceException("\u67e5\u8be2\u53c2\u6570\u4e3anull");
        }
        if (model.getIsHypoxia().booleanValue()) {
            ProtectModel pModel = new ProtectModel();
            pModel.setMaxHarmNum(null);
            pModel.setIsHypoxia(Boolean.valueOf(true));
            pModel.setTips("\u6839\u636eGB/T 18664-2002\u4e2d\u7684\u8981\u6c42\uff0c\u7f3a\u6c27\u73af\u5883\u4e0b\u4e0d\u8bba\u662f\u5426\u5b58\u5728\u6709\u5bb3\u56e0\u7d20\uff0c\u5747\u89c6\u4e3a\u7acb\u5373\u5a01\u80c1\u751f\u547d\u548c\u5065\u5eb7\uff08IDLH\uff09\u73af\u5883\u3002\u6211\u4eec\u63a8\u8350\u60a8\u4f7f\u7528\u6700\u9ad8\u7ea7\u522b\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u76f8\u5e94\u7684\u5546\u54c1\uff1a</br>1.\u975e\u7206\u70b8\u73af\u5883\u65f6\uff0c\u914d\u5907\u643a\u6c14\u6b63\u538b\u5f0f\u6c27\u6c14\u547c\u5438\u5668\uff08\u7206\u70b8\u73af\u5883\u65f6\uff0c\u914d\u5907\u643a\u6c14\u6b63\u538b\u5f0f\u7a7a\u6c14\u547c\u5438\u5668\uff09</br>2.\u5728\u4f69\u6234\u643a\u6c14\u5f0f\u8f85\u52a9\u9003\u751f\u547c\u5438\u9632\u62a4\u7528\u54c1\u524d\u63d0\u4e0b\uff0c\u914d\u5907\u4f9b\u6c14\u6b63\u538b\u5f0f\u547c\u5438\u5668\uff08\u5168\u9762\u7f69\u548c\u9001\u6c14\u5934\u7f69\uff09");
            return pModel;
        }
        if (model.getList() == null) {
            throw new ServiceException("\u8bf7\u9009\u62e9\u5371\u5bb3\u56e0\u7d20\uff01");
        }
        List harms = model.getList();
        HashMap<Object, HarmInfoModel> harmTypeValue = new HashMap<Object, HarmInfoModel>();
        for (HarmInfoSeachModel seach : harms) {
            Long harmId = seach.getHarmId();
            if (harmId == null || harmTypeValue.get(harmId) != null) continue;
            HarmInfoSeachModel newSearch = new HarmInfoSeachModel();
            BeanUtils.copyProperties((Object)seach, (Object)newSearch);
            HarmInfoModel info = this.riskFactorsProvideByPlatformService.getHarmInfoById(newSearch);
            if (info.getTwaTotal() != null) {
                BigDecimal stelTotal = new BigDecimal(info.getTwaTotal()).multiply(new BigDecimal(2));
                info.setStelTotal(Double.valueOf(stelTotal.doubleValue()));
            }
            if (info.getStelRespirabel() != null) {
                BigDecimal stelRespirabel = new BigDecimal(info.getStelRespirabel()).multiply(new BigDecimal(1.4));
                info.setStelRespirabel(Double.valueOf(stelRespirabel.doubleValue()));
            }
            this.setHarmNum(info);
            harmTypeValue.put(harmId, info);
        }
        Double maxHarmNum = 0.0;
        HarmInfoModel harmInfo = null;
        for (HarmInfoModel info : harmTypeValue.values()) {
            Double harmNum = info.getHarmNum();
            if (harmNum <= 0.0 || !(harmNum > maxHarmNum)) continue;
            maxHarmNum = harmNum;
            harmInfo = info;
        }
        HarmInfoModel harmInfoPlatform = new HarmInfoModel();
        BeanUtils.copyProperties(harmInfo, (Object)harmInfoPlatform);
        harmInfoPlatform.setHarmIdList(new ArrayList(harmTypeValue.keySet()));
        List<ProtectListModel> protects = ((ProtectListMapper)this.dao).selectBreathProtects(harmInfoPlatform);
        ProtectModel pModel = new ProtectModel();
        pModel.setList(protects);
        pModel.setMaxHarmNum(maxHarmNum);
        pModel.setIsHypoxia(Boolean.valueOf(false));
        if (maxHarmNum == 0.0) {
            pModel.setTips("\u60a8\u8f93\u5165\u7684\u6709\u5bb3\u56e0\u7d20\u6d53\u5ea6\u4e3a\u96f6\uff0c\u6839\u636eGB/T 18664-2002\u53ef\u4e0d\u4f69\u6234\u547c\u5438\u9632\u62a4\u7528\u54c1\uff0c\u4f46\u662f\u7531\u4e8e\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4ee3\u8868\u751f\u4ea7\u5168\u8fc7\u7a0b\uff0c\u82e5\u751f\u4ea7\u8fc7\u7a0b\u4e2d\u5b58\u5728\u6709\u53ef\u80fd\u4ea7\u751f\u6709\u5bb3\u56e0\u7d20\u5371\u5bb3\u7684\u610f\u5916\u60c5\u51b5\uff0c\u5efa\u8bae\u60a8\u4e3a\u5458\u5de5\u9009\u914d\u9632\u62a4\u7528\u54c1\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\u3002");
        } else if (maxHarmNum <= 1.0) {
            pModel.setTips("\u60a8\u8f93\u5165\u7684\u6709\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6839\u636e\u8ba1\u7b97\u6240\u5f97\u5371\u5bb3\u56e0\u6570\u22641\uff0c\u6839\u636eGB/T 18664-2002\u53ef\u4e0d\u4f69\u6234\u547c\u5438\u9632\u62a4\u7528\u54c1\uff0c\u4f46\u662f\uff1a</br>1.\u901a\u5e38\u7684\u505a\u6cd5\u662f\u5371\u5bb3\u56e0\u6570\u5927\u4e8e0.5\u5c31\u8981\u4f69\u6234\u9632\u62a4\u7528\u54c1\uff1b</br>2.\u7531\u4e8e\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4ee3\u8868\u751f\u4ea7\u5168\u8fc7\u7a0b\uff0c\u82e5\u751f\u4ea7\u8fc7\u7a0b\u4e2d\u5b58\u5728\u6709\u53ef\u80fd\u5bfc\u81f4\u6709\u5bb3\u56e0\u7d20\u8d85\u6807\u7684\u610f\u5916\u60c5\u51b5\uff0c\u5efa\u8bae\u60a8\u4e3a\u5458\u5de5\u9009\u914d\u9632\u62a4\u7528\u54c1\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\u3002");
        } else if (maxHarmNum > 1.0) {
            pModel.setTips("\u60a8\u8f93\u5165\u7684\u6709\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6839\u636e\u8ba1\u7b97\u6240\u5f97\u5371\u5bb3\u56e0\u6570\u6700\u5927\u503c\u4e3a" + new DecimalFormat("#.00").format(maxHarmNum) + ",\u6839\u636eGB/T 18664-2002\u4e2d\u7684\u8981\u6c42\uff0c\u4e3a\u60a8\u63a8\u8350\u5982\u4e0bPPE\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u9009\u62e9\uff0c\u8d2d\u4e70\u65f6\u8bf7\u54a8\u8be2\u5382\u5546\u9009\u62e9\u9002\u5408\u7684\u547c\u5438\u9632\u62a4\u7528\u54c1\uff1a");
        }
        return pModel;
    }

    private void setHarmNum(HarmInfoModel harmInfo) {
        Double max = 0.0;
        if (harmInfo == null) {
            return;
        }
        this.logger.info((Object)harmInfo);
        if (harmInfo.getMac() == null && harmInfo.getStel() == null && harmInfo.getTwa() == null && harmInfo.getTwaRespirabel() == null && harmInfo.getTwaTotal() == null) {
            max = 1.5;
            harmInfo.setHarmNum(max);
            return;
        }
        if (harmInfo.getMac() != null && harmInfo.getMac() > max) {
            max = harmInfo.getMac();
        }
        if (harmInfo.getStel() != null && harmInfo.getStel() > max) {
            max = harmInfo.getStel();
        }
        if (harmInfo.getTwa() != null && harmInfo.getTwa() > max) {
            max = harmInfo.getTwa();
        }
        if (harmInfo.getTwaRespirabel() != null && harmInfo.getTwaRespirabel() > max) {
            max = harmInfo.getTwaRespirabel();
        }
        if (harmInfo.getTwaTotal() != null && harmInfo.getTwaTotal() > max) {
            max = harmInfo.getTwaTotal();
        }
        harmInfo.setHarmNum(max);
    }

    private void mergeProtects(List<ProtectListModel> all, List<ProtectListModel> needMerges) {
        if (needMerges == null || needMerges.size() == 0) {
            return;
        }
        for (ProtectListModel p : needMerges) {
            String ppeId = p.getPpeId();
            if (StringUtils.isEmpty((CharSequence)ppeId)) continue;
            ProtectListModel alreadyExist = this.getProtectByPPEId(ppeId, all);
            if (alreadyExist == null) {
                all.add(p);
                continue;
            }
            alreadyExist.setOther(this.setLX(alreadyExist.getOther(), p.getOther()));
        }
    }

    private String setLX(String str1, String str2) {
        Object result = str1;
        if (StringUtils.isEmpty((CharSequence)str2)) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)str1)) {
            result = str2;
        } else if (str1.indexOf(str2) < 0) {
            result = (String)result + "+" + str2;
        }
        return result;
    }

    private ProtectListModel getProtectByPPEId(String ppeId, List<ProtectListModel> all) {
        for (ProtectListModel a : all) {
            if (!ppeId.equals(a.getPpeId())) continue;
            return a;
        }
        return null;
    }
}

